/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser.structure;

import java.util.HashMap;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.internal.javascript.parser.structure.IStructureRequestor;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.JSMethod;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitor;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.parser.PropertyExpressionUtils;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;

public class StructureReporter2
extends TypeInferencerVisitor {
    private static final Integer IDKIND_UNKNOWN = new Integer(-3);
    private static final Integer IDKIND_LOCAL = new Integer(-2);
    private static final Integer IDKIND_GLOBAL = new Integer(-1);
    private final IStructureRequestor fRequestor;

    public StructureReporter2(ITypeInferenceContext context, IStructureRequestor fRequestor) {
        super(context);
        this.fRequestor = fRequestor;
    }

    public IStructureRequestor getRequestor() {
        return this.fRequestor;
    }

    public IValueReference visitIdentifier(Identifier node) {
        IValueReference reference = super.visitIdentifier(node);
        this.checkIdentifier(node, reference);
        return reference;
    }

    private void checkIdentifier(Identifier node, IValueReference reference) {
        if (StructureReporter2.isFunctionDeclaration((Expression)node)) {
            return;
        }
        int argCount = this.checkIdentiferReferenceKind(node, reference);
        if (argCount != IDKIND_UNKNOWN) {
            if (argCount == IDKIND_LOCAL) {
                this.fRequestor.acceptLocalReference(node, reference);
            } else if (argCount == IDKIND_GLOBAL) {
                this.fRequestor.acceptFieldReference(node, reference);
            } else {
                this.fRequestor.acceptMethodReference(node, argCount, reference);
            }
        } else {
            ASTNode parent = node.getParent();
            if (parent instanceof PropertyExpression && ((PropertyExpression)parent).getProperty() == node) {
                while (parent instanceof PropertyExpression) {
                    parent = ((PropertyExpression)parent).getParent();
                }
            }
            if (parent instanceof CallExpression) {
                this.fRequestor.acceptMethodReference(node, ((CallExpression)parent).getArguments().size(), reference);
            } else if (!(parent instanceof PropertyInitializer)) {
                this.fRequestor.acceptFieldReference(node, reference);
            }
        }
    }

    private int checkIdentiferReferenceKind(Identifier node, IValueReference reference) {
        if (reference == null) {
            return IDKIND_UNKNOWN;
        }
        ReferenceKind kind = reference.getKind();
        if (kind == ReferenceKind.ARGUMENT || kind == ReferenceKind.LOCAL) {
            return IDKIND_LOCAL;
        }
        if (kind == ReferenceKind.FIELD || kind == ReferenceKind.GLOBAL) {
            return IDKIND_GLOBAL;
        }
        if (kind == ReferenceKind.FUNCTION) {
            IModelBuilder.IMethod method = (IModelBuilder.IMethod)reference.getAttribute("PARAMETERS");
            if (method == null) {
                return IDKIND_UNKNOWN;
            }
            return method.getParameterCount();
        }
        return IDKIND_UNKNOWN;
    }

    public IValueReference visitFunctionStatement(FunctionStatement node) {
        List<IModelBuilder.IParameter> parameters;
        IElementRequestor.MethodInfo methodInfo = new IElementRequestor.MethodInfo();
        methodInfo.declarationStart = node.sourceStart();
        JSMethod method = this.generateJSMethod(node);
        Identifier thisIdentifier = null;
        Identifier identifier = null;
        if (node.getParent() instanceof PropertyInitializer && ((PropertyInitializer)node.getParent()).getName() instanceof Identifier) {
            identifier = this.setNameProperties((Identifier)((PropertyInitializer)node.getParent()).getName(), methodInfo, method);
        } else if (node.getParent() instanceof VariableDeclaration && ((VariableDeclaration)node.getParent()).getIdentifier() != null) {
            identifier = this.setNameProperties(((VariableDeclaration)node.getParent()).getIdentifier(), methodInfo, method);
        } else {
            thisIdentifier = StructureReporter2.getThisIdentifier(node);
            if (thisIdentifier != null) {
                identifier = this.setNameProperties(thisIdentifier, methodInfo, method);
            } else if (node.getParent() instanceof BinaryOperation && ((BinaryOperation)node.getParent()).getOperation() == 104 && ((BinaryOperation)node.getParent()).getLeftExpression() instanceof PropertyExpression) {
                Expression expression = ((BinaryOperation)node.getParent()).getLeftExpression();
                identifier = PropertyExpressionUtils.getIdentifier((Expression)expression);
                method.setName(PropertyExpressionUtils.getPath((Expression)expression));
                if (method.getName() == null) {
                    method.setName("");
                }
                methodInfo.nameSourceStart = expression.sourceStart();
                methodInfo.nameSourceEnd = expression.sourceEnd() - 1;
            } else if (node.getName() != null) {
                identifier = this.setNameProperties(node.getName(), methodInfo, method);
            } else {
                method.setName("");
                methodInfo.nameSourceStart = node.getFunctionKeyword().sourceStart();
                methodInfo.nameSourceEnd = node.getFunctionKeyword().sourceEnd() - 1;
            }
        }
        methodInfo.name = method.getName();
        methodInfo.isConstructor = method.isConstructor();
        methodInfo.returnType = TypeUtil.getName(method.getType());
        if (method.isDeprecated()) {
            methodInfo.modifiers |= 0x40000;
        }
        if (method.isPrivate()) {
            methodInfo.modifiers |= 0x10;
        }
        if ((parameters = method.getParameters()) != null && parameters.size() > 0) {
            HashMap<String, Argument> arguments = new HashMap<String, Argument>();
            for (Argument argument : node.getArguments()) {
                arguments.put(argument.getIdentifier().getName(), argument);
            }
            String[] paramNames = new String[parameters.size()];
            String[] paramTypes = new String[parameters.size()];
            int i = 0;
            while (i < parameters.size()) {
                IModelBuilder.IParameter parameter = parameters.get(i);
                paramNames[i] = parameter.getName();
                paramTypes[i] = TypeUtil.getName(parameter.getType());
                this.fRequestor.acceptArgumentDeclaration((Argument)arguments.get(parameter.getName()), this.getSource().getSourceModule(), parameter.getType());
                ++i;
            }
            methodInfo.parameterNames = paramNames;
            methodInfo.parameterTypes = paramTypes;
        }
        this.fRequestor.enterMethod(methodInfo, (Expression)identifier, method);
        IValueReference reference = super.visitFunctionStatement(node);
        if (method.getType() == null) {
            if (reference.getDeclaredType() != null) {
                method.setType(reference.getDeclaredType());
                methodInfo.returnType = TypeUtil.getName(method.getType());
            } else if (!reference.getDeclaredTypes().isEmpty()) {
                method.setType(reference.getDeclaredTypes().getFirst());
                methodInfo.returnType = TypeUtil.getName(method.getType());
            }
        }
        this.fRequestor.exitMethod(node.sourceEnd());
        return reference;
    }

    public static Identifier getThisIdentifier(FunctionStatement fs) {
        ASTNode node = fs.getParent();
        if (node instanceof BinaryOperation && (node = ((BinaryOperation)node).getLeftExpression()) instanceof PropertyExpression) {
            Expression property = ((PropertyExpression)node).getProperty();
            if ((node = ((PropertyExpression)node).getObject()) instanceof ThisExpression && property instanceof Identifier) {
                return (Identifier)property;
            }
        }
        return null;
    }

    private Identifier setNameProperties(Identifier node, IElementRequestor.MethodInfo methodInfo, JSMethod method) {
        method.setName(node.getName());
        methodInfo.nameSourceStart = node.sourceStart();
        methodInfo.nameSourceEnd = node.sourceEnd() - 1;
        if (methodInfo.declarationStart > methodInfo.nameSourceStart) {
            methodInfo.declarationStart = methodInfo.nameSourceStart;
        }
        return node;
    }

    public IValueReference visitObjectInitializer(ObjectInitializer node) {
        Identifier fieldIdentifer = null;
        if (this.inFunction()) {
            if (node.getParent() instanceof VariableDeclaration && ((VariableDeclaration)node.getParent()).getIdentifier() != null) {
                fieldIdentifer = ((VariableDeclaration)node.getParent()).getIdentifier();
            } else if (node.getParent() instanceof PropertyInitializer && ((PropertyInitializer)node.getParent()).getName() instanceof Identifier) {
                fieldIdentifer = (Identifier)((PropertyInitializer)node.getParent()).getName();
            }
            if (fieldIdentifer != null) {
                this.fRequestor.enterField(this.createFieldInfo(fieldIdentifer, node.sourceStart(), null), (Expression)fieldIdentifer, null);
            }
        }
        PropertyInitializer[] propertyInitializerArray = node.getPropertyInitializers();
        int n = propertyInitializerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyInitializer pi = propertyInitializerArray[n2];
            if (!(pi.getValue() instanceof FunctionStatement) && pi.getName() instanceof Identifier) {
                Identifier identifier = (Identifier)pi.getName();
                this.fRequestor.enterField(this.createFieldInfo(identifier, pi.sourceStart(), null), (Expression)identifier, null);
                this.fRequestor.exitField(pi.sourceEnd());
            }
            ++n2;
        }
        IValueReference reference = super.visitObjectInitializer(node);
        if (fieldIdentifer != null) {
            this.fRequestor.exitField(node.sourceEnd());
        }
        return reference;
    }

    private IElementRequestor.FieldInfo createFieldInfo(Identifier identifer, int sourceStart, IModelBuilder.IVariable variable) {
        IElementRequestor.FieldInfo fieldInfo = new IElementRequestor.FieldInfo();
        fieldInfo.declarationStart = sourceStart;
        fieldInfo.name = identifer.getName();
        fieldInfo.nameSourceStart = identifer.sourceStart();
        fieldInfo.nameSourceEnd = identifer.sourceEnd() - 1;
        if (variable != null) {
            if (variable.isDeprecated()) {
                fieldInfo.modifiers |= 0x40000;
            }
            if (variable.isPrivate()) {
                fieldInfo.modifiers |= 0x10;
            }
            fieldInfo.type = TypeUtil.getName(variable.getType());
        }
        return fieldInfo;
    }

    protected void initializeVariable(IValueReference reference, VariableDeclaration declaration, IModelBuilder.IVariable variable) {
        if (!(declaration.getInitializer() instanceof FunctionStatement)) {
            IValueReference assignment;
            Identifier identifier = declaration.getIdentifier();
            IElementRequestor.FieldInfo fieldInfo = null;
            if (this.inFunction()) {
                this.fRequestor.enterLocal(identifier, this.getSource().getSourceModule(), variable.getType());
            } else {
                fieldInfo = this.createFieldInfo(identifier, declaration.sourceStart(), variable);
                this.fRequestor.enterField(fieldInfo, (Expression)identifier, variable.getType());
            }
            if (declaration.getInitializer() != null && (assignment = this.visit((ASTNode)declaration.getInitializer())) != null) {
                if (fieldInfo != null && variable.getType() == null && assignment.getDeclaredType() != null) {
                    fieldInfo.type = TypeUtil.getName(assignment.getDeclaredType());
                    this.fRequestor.updateField(fieldInfo, 1);
                }
                this.assign(reference, assignment);
                if (assignment.getKind() == ReferenceKind.FUNCTION && reference.getAttribute("PARAMETERS") != null) {
                    reference.setKind(ReferenceKind.FUNCTION);
                }
            }
            if (this.inFunction()) {
                this.fRequestor.exitLocal(declaration.sourceEnd());
            } else {
                this.fRequestor.exitField(declaration.sourceEnd());
            }
        } else {
            super.initializeVariable(reference, declaration, variable);
        }
    }

    public IValueReference visitPropertyExpression(PropertyExpression node) {
        ASTNode parent = node.getParent();
        if (node.getObject() instanceof ThisExpression && !(parent instanceof CallExpression) && (!(parent instanceof BinaryOperation) || parent instanceof BinaryOperation && !(((BinaryOperation)parent).getRightExpression() instanceof FunctionStatement))) {
            Expression name = node.getProperty();
            Identifier identifier = null;
            if (name instanceof Identifier) {
                identifier = (Identifier)name;
            }
            if (identifier != null) {
                IValueReference reference = super.visitPropertyExpression(node);
                if (this.fRequestor.enterFieldCheckDuplicates(this.createFieldInfo(identifier, name.sourceStart(), null), (Expression)identifier, null)) {
                    reference = super.visitPropertyExpression(node);
                    this.fRequestor.exitField(node.sourceEnd());
                    return reference;
                }
            }
        }
        IValueReference reference = super.visitPropertyExpression(node);
        if (node.getProperty() instanceof Identifier) {
            this.checkIdentifier((Identifier)node.getProperty(), reference);
        }
        return reference;
    }
}

