/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.internal.javascript.ti.AbstractReference;
import org.eclipse.dltk.internal.javascript.ti.ChildReference;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.Value;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableValueCollection
implements IValueCollection,
IValueProvider {
    private boolean scope;
    private boolean reference;
    private IValueCollection parent;
    private IValue value;
    private IValueReference thisValue;
    private IValueReference returnValue;

    public static ImmutableValueCollection getImmutableValueCollection(IValueCollection collection, Map<Object, Object> visited) {
        if (collection == null) {
            return null;
        }
        ImmutableValueCollection readOnlyCol = (ImmutableValueCollection)visited.get(collection);
        if (readOnlyCol != null) {
            return readOnlyCol;
        }
        readOnlyCol = new ImmutableValueCollection();
        visited.put(collection, readOnlyCol);
        boolean reference = false;
        IValue value = null;
        if (collection instanceof IValueProvider) {
            reference = ((IValueProvider)((Object)collection)).isReference();
            value = ((IValueProvider)((Object)collection)).getValue();
            if (value instanceof Value) {
                value = ((Value)value).getImmutableValue(visited);
            }
        }
        IValue thisValue = null;
        if (collection.getThis() instanceof IValueProvider && (thisValue = ((IValueProvider)((Object)collection.getThis())).getValue()) instanceof Value) {
            thisValue = ((Value)thisValue).getImmutableValue(visited);
        }
        IValue returnValue = null;
        if (collection.getReturnValue() instanceof IValueProvider && (returnValue = ((IValueProvider)((Object)collection.getReturnValue())).getValue()) instanceof Value) {
            returnValue = ((Value)returnValue).getImmutableValue(visited);
        }
        readOnlyCol.init(collection.isScope(), reference, ImmutableValueCollection.getImmutableValueCollection(collection.getParent(), visited), value, thisValue, returnValue);
        return readOnlyCol;
    }

    public void init(boolean scope, boolean reference, IValueCollection parent, IValue value, IValue thisValue, IValue returnValue) {
        this.scope = scope;
        this.reference = reference;
        this.parent = parent;
        this.value = value;
        this.thisValue = new ValueWrapper(thisValue);
        this.returnValue = new ValueWrapper(returnValue);
    }

    @Override
    public boolean isReference() {
        return this.reference;
    }

    @Override
    public IValue getValue() {
        return this.value;
    }

    @Override
    public IValue createValue() {
        return this.getValue();
    }

    @Override
    public Set<String> getDirectChildren() {
        return this.value.getDirectChildren();
    }

    @Override
    public Set<String> getDeletedChildren() {
        return this.value.getDeletedChildren();
    }

    @Override
    public boolean hasChild(String name) {
        IValue value = this.getValue();
        return value != null && value.getChild(name, true) != null;
    }

    @Override
    public IValueReference getChild(String name) {
        return new ChildReference(this, name);
    }

    @Override
    public ITypeInferenceContext getContext() {
        return null;
    }

    @Override
    public boolean isScope() {
        return this.scope;
    }

    @Override
    public IValueCollection getParent() {
        return this.parent;
    }

    @Override
    public IValueReference createChild(String name) {
        return null;
    }

    @Override
    public IValueReference getReturnValue() {
        return this.returnValue;
    }

    @Override
    public IValueReference getThis() {
        return this.thisValue;
    }

    public static class ValueWrapper
    extends AbstractReference {
        private final IValue value;

        ValueWrapper(IValue value) {
            this.value = value;
        }

        public boolean isReference() {
            return false;
        }

        public IValue getValue() {
            return this.value;
        }

        public IValue createValue() {
            return this.getValue();
        }

        public void delete() {
        }

        public String getName() {
            return "";
        }

        public ITypeInferenceContext getContext() {
            return null;
        }

        public IValueReference getParent() {
            return null;
        }

        protected String getToStringPrefix() {
            return "AnonymousValue";
        }

        public String toString() {
            return String.valueOf(this.getToStringPrefix()) + "@" + System.identityHashCode(this.value);
        }
    }
}

