/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.dltk.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public class RenameModifications
extends RefactoringModifications {
    private List fRename = new ArrayList();
    private List fRenameArguments = new ArrayList();
    private List fParticipantDescriptorFilter = new ArrayList();

    public void rename(IResource resource, RenameArguments args) {
        this.add(resource, (RefactoringArguments)args, null);
    }

    public void rename(IScriptProject project, RenameArguments args) {
        this.add(project, (RefactoringArguments)args, null);
        IProject rProject = project.getProject();
        if (rProject != null) {
            this.getResourceModifications().addRename((IResource)rProject, args);
            IProject[] referencingProjects = rProject.getReferencingProjects();
            int i = 0;
            while (i < referencingProjects.length) {
                IFile buildpath = this.getBuildpathFile((IResource)referencingProjects[i]);
                if (buildpath != null) {
                    this.getResourceModifications().addChanged(buildpath);
                }
                ++i;
            }
        }
    }

    public void rename(IProjectFragment sourceFolder, RenameArguments arguments) {
        this.add(sourceFolder, (RefactoringArguments)arguments, null);
        if (sourceFolder.getResource() != null) {
            this.getResourceModifications().addRename(sourceFolder.getResource(), arguments);
        }
    }

    public void rename(IScriptFolder rootPackage, RenameArguments args, boolean renameSubPackages) throws CoreException {
        IContainer container;
        this.add(rootPackage, (RefactoringArguments)args, null);
        IScriptFolder[] allSubPackages = null;
        if (renameSubPackages) {
            allSubPackages = this.getSubpackages(rootPackage);
            int i = 0;
            while (i < allSubPackages.length) {
                IScriptFolder pack = allSubPackages[i];
                RenameArguments subArgs = new RenameArguments(this.getNewPackageName(rootPackage, args.getNewName(), pack.getElementName()), args.getUpdateReferences());
                this.add(pack, (RefactoringArguments)subArgs, null);
                ++i;
            }
        }
        if ((container = (IContainer)rootPackage.getResource()) == null) {
            return;
        }
        IContainer target = (IContainer)((IProjectFragment)rootPackage.getParent()).getScriptFolder(args.getNewName()).getResource();
        if ((!rootPackage.hasSubfolders() || renameSubPackages) && this.canMove(container, target)) {
            this.createIncludingParents(target.getParent());
            if (container.getParent().equals((Object)target.getParent())) {
                this.getResourceModifications().addRename((IResource)container, new RenameArguments(target.getName(), args.getUpdateReferences()));
            } else {
                try {
                    this.getResourceModifications().ignoreForDelta();
                    this.addAllResourceModifications(rootPackage, args, renameSubPackages, allSubPackages);
                }
                finally {
                    this.getResourceModifications().trackForDelta();
                }
                this.getResourceModifications().addDelta(new ResourceModifications.MoveDescription((IResource)container, target.getFullPath()));
            }
        } else {
            this.addAllResourceModifications(rootPackage, args, renameSubPackages, allSubPackages);
        }
    }

    public void rename(ISourceModule unit, RenameArguments args) {
        this.add(unit, (RefactoringArguments)args, null);
        if (unit.getResource() != null) {
            this.getResourceModifications().addRename(unit.getResource(), new RenameArguments(args.getNewName(), args.getUpdateReferences()));
        }
    }

    public void rename(ILocalVariable variable, RenameArguments args) {
        this.add(variable, (RefactoringArguments)args, null);
    }

    public void rename(IField field, RenameArguments args) {
        this.add(field, (RefactoringArguments)args, null);
    }

    public void rename(IMethod method, RenameArguments args) {
        this.add(method, (RefactoringArguments)args, null);
    }

    public void buildDelta(IResourceChangeDescriptionFactory builder) {
        int i = 0;
        while (i < this.fRename.size()) {
            Object element = this.fRename.get(i);
            if (element instanceof IResource) {
                ResourceModifications.buildMoveDelta(builder, (IResource)element, (RenameArguments)this.fRenameArguments.get(i));
            }
            ++i;
        }
        this.getResourceModifications().buildDelta(builder);
    }

    public void buildValidateEdits(ValidateEditChecker checker) {
        for (Object element : this.fRename) {
            ISourceModule unit;
            IResource resource;
            if (!(element instanceof ISourceModule) || (resource = (unit = (ISourceModule)element).getResource()) == null || resource.getType() != 1) continue;
            checker.addFile((IFile)resource);
        }
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor owner, String[] natures, SharableParticipants shared) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < this.fRename.size()) {
            result.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)owner, this.fRename.get(i), (RenameArguments)((RenameArguments)this.fRenameArguments.get(i)), (IParticipantDescriptorFilter)((IParticipantDescriptorFilter)this.fParticipantDescriptorFilter.get(i)), (String[])natures, (SharableParticipants)shared)));
            ++i;
        }
        result.addAll(Arrays.asList(this.getResourceModifications().getParticipants(status, owner, natures, shared)));
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private void add(Object element, RefactoringArguments args, IParticipantDescriptorFilter filter) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)args);
        this.fRename.add(element);
        this.fRenameArguments.add(args);
        this.fParticipantDescriptorFilter.add(filter);
    }

    private void addAllResourceModifications(IScriptFolder rootPackage, RenameArguments args, boolean renameSubPackages, IScriptFolder[] allSubPackages) throws CoreException {
        this.addResourceModifications(rootPackage, args, rootPackage, renameSubPackages);
        if (renameSubPackages) {
            int i = 0;
            while (i < allSubPackages.length) {
                IScriptFolder pack = allSubPackages[i];
                this.addResourceModifications(rootPackage, args, pack, renameSubPackages);
                ++i;
            }
        }
    }

    private void addResourceModifications(IScriptFolder rootPackage, RenameArguments args, IScriptFolder pack, boolean renameSubPackages) throws CoreException {
        IContainer container = (IContainer)pack.getResource();
        if (container == null) {
            return;
        }
        IFolder target = this.computeTargetFolder(rootPackage, args, pack);
        this.createIncludingParents((IContainer)target);
        MoveArguments arguments = new MoveArguments((Object)target, args.getUpdateReferences());
        IResource[] resourcesToMove = this.collectResourcesOfInterest(pack);
        HashSet allMembers = new HashSet(Arrays.asList(container.members()));
        int i = 0;
        while (i < resourcesToMove.length) {
            IResource toMove = resourcesToMove[i];
            this.getResourceModifications().addMove(toMove, arguments);
            allMembers.remove(toMove);
            ++i;
        }
        Iterator iter = allMembers.iterator();
        while (iter.hasNext()) {
            IResource element = (IResource)iter.next();
            if (!(element instanceof IFile)) continue;
            this.getResourceModifications().addDelete(element);
            iter.remove();
        }
        if (renameSubPackages && rootPackage.equals(pack) || !renameSubPackages && allMembers.isEmpty()) {
            this.getResourceModifications().addDelete((IResource)container);
        }
    }

    private boolean canMove(IContainer source, IContainer target) {
        return !target.exists() && !source.getFullPath().isPrefixOf(target.getFullPath());
    }

    private IScriptFolder[] getSubpackages(IScriptFolder pack) throws CoreException {
        IProjectFragment root = (IProjectFragment)pack.getParent();
        IModelElement[] allPackages = root.getChildren();
        if (pack.isRootFolder()) {
            return new IScriptFolder[0];
        }
        ArrayList<IScriptFolder> result = new ArrayList<IScriptFolder>();
        String prefix = String.valueOf(pack.getElementName()) + '/';
        int i = 0;
        while (i < allPackages.length) {
            IScriptFolder currentPackage = (IScriptFolder)allPackages[i];
            if (currentPackage.getElementName().startsWith(prefix)) {
                result.add(currentPackage);
            }
            ++i;
        }
        return result.toArray(new IScriptFolder[result.size()]);
    }

    private IFolder computeTargetFolder(IScriptFolder rootPackage, RenameArguments args, IScriptFolder pack) {
        IPath path = pack.getParent().getPath();
        path = path.append(this.getNewPackageName(rootPackage, args.getNewName(), pack.getElementName()).replace('.', '/'));
        IFolder target = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        return target;
    }

    private String getNewPackageName(IScriptFolder rootPackage, String newPackageName, String oldSubPackageName) {
        String oldPackageName = rootPackage.getElementName();
        return String.valueOf(newPackageName) + oldSubPackageName.substring(oldPackageName.length());
    }
}

