/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.scriptdoc;

import java.io.IOException;
import org.eclipse.dltk.corext.documentation.SingleCharReader;
import org.eclipse.dltk.javascript.scriptdoc.IndentManipulation;

public abstract class JavaDocCommentReader
extends SingleCharReader {
    private int fCurrPos;
    private int fStartPos;
    private int fEndPos;
    private boolean fWasNewLine;

    public JavaDocCommentReader(int start, int end) {
        this.fStartPos = start + 3;
        this.fEndPos = end - 2;
        this.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() {
        char ch;
        if (this.fCurrPos >= this.fEndPos) return -1;
        if (this.fWasNewLine) {
            do {
                ch = this.getChar(this.fCurrPos++);
            } while (this.fCurrPos < this.fEndPos && Character.isWhitespace(ch));
            if (ch == '*') {
                if (this.fCurrPos >= this.fEndPos) return -1;
                while ((ch = this.getChar(this.fCurrPos++)) == '*') {
                }
            }
        } else {
            ch = this.getChar(this.fCurrPos++);
        }
        this.fWasNewLine = IndentManipulation.isLineDelimiterChar(ch);
        return ch;
    }

    public boolean containsOnlyInheritDoc() {
        int length = this.getLength();
        char[] content = new char[length];
        try {
            this.read(content, 0, length);
        }
        catch (IOException iOException) {
            return false;
        }
        return new String(content).trim().equals("{@inheritDoc}");
    }

    protected abstract int getLength();

    protected abstract char getChar(int var1);

    public void reset() {
        this.fCurrPos = this.fStartPos;
        this.fWasNewLine = true;
    }

    public int getOffset() {
        return this.fCurrPos;
    }
}

