/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.interpreters.AddScriptInterpreterDialog;
import org.eclipse.dltk.internal.debug.ui.interpreters.IAddInterpreterDialogRequestor;
import org.eclipse.dltk.internal.debug.ui.interpreters.IScriptInterpreterDialog;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.ui.util.SWTUtil;
import org.eclipse.dltk.internal.ui.util.TableLayoutComposite;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterSearcher;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class InterpretersBlock
implements IAddInterpreterDialogRequestor,
ISelectionProvider {
    private Composite fControl;
    protected List<IInterpreterInstall> fInterpreters = new ArrayList<IInterpreterInstall>();
    protected CheckboxTableViewer fInterpreterList;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private Button fCopyButton;
    private Button fSearchButton;
    private Combo fEnvironments;
    private Map<IEnvironment, IInterpreterInstall> checkedInterpreters = new HashMap<IEnvironment, IInterpreterInstall>();
    private int fSortColumn = 0;
    private ListenerList fSelectionListeners = new ListenerList();
    private ISelection fPrevSelection = new StructuredSelection();
    private Table fTable;
    private static String fgLastUsedID;
    private IEnvironment[] environments;
    protected Composite buttons;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.fInterpreterList.getCheckedElements());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.fPrevSelection)) {
            this.fPrevSelection = selection;
            Object interp = ((IStructuredSelection)selection).getFirstElement();
            if (interp == null) {
                this.fInterpreterList.setCheckedElements(new Object[0]);
            } else {
                this.fInterpreterList.setCheckedElements(new Object[]{interp});
                IInterpreterInstall install = (IInterpreterInstall)interp;
                this.checkedInterpreters.put(install.getEnvironment(), install);
                this.fInterpreterList.reveal(interp);
            }
            this.fireSelectionChanged();
        }
    }

    public void createControl(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Font font = ancestor.getFont();
        parent.setFont(font);
        parent.setLayout((Layout)layout);
        this.fControl = parent;
        Composite env = new Composite(parent, 0);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginLeft = -5;
        layout2.marginRight = -5;
        layout2.marginTop = -5;
        layout2.marginBottom = -5;
        env.setLayout((Layout)layout2);
        GridData data = new GridData(4, -1, true, false);
        data.horizontalSpan = 2;
        env.setLayoutData((Object)data);
        Label environmentLabel = new Label(env, 0);
        environmentLabel.setText(InterpretersMessages.InterpretersBlock_host);
        this.fEnvironments = new Combo(env, 12);
        data = new GridData(4, -1, true, false);
        this.fEnvironments.setLayoutData((Object)data);
        this.environments = EnvironmentManager.getEnvironments();
        String[] items = new String[this.environments.length];
        int local = 0;
        int i = 0;
        while (i < items.length) {
            items[i] = this.environments[i].getName();
            if (this.environments[i].isLocal()) {
                local = i;
            }
            ++i;
        }
        this.fEnvironments.setItems(items);
        this.fEnvironments.select(local);
        this.fEnvironments.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object install = InterpretersBlock.this.checkedInterpreters.get(InterpretersBlock.this.getCurrentEnvironment());
                InterpretersBlock.this.fInterpreterList.refresh();
                if (install != null) {
                    InterpretersBlock.this.fInterpreterList.setCheckedElements(new Object[]{install});
                } else {
                    InterpretersBlock.this.fInterpreterList.setCheckedElements(new Object[0]);
                }
            }
        });
        PixelConverter conv = new PixelConverter((Control)parent);
        data = new GridData(1808);
        data.widthHint = conv.convertWidthInCharsToPixels(50);
        TableLayoutComposite tblComposite = new TableLayoutComposite(parent, 0);
        tblComposite.setLayoutData((Object)data);
        this.fTable = new Table((Composite)tblComposite, 67618);
        data = new GridData(1808);
        data.widthHint = 450;
        this.fTable.setLayoutData((Object)data);
        this.fTable.setFont(font);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.fTable, 0);
        column1.setText(InterpretersMessages.InstalledInterpretersBlock_0);
        column1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterpretersBlock.this.sortByName();
            }
        });
        column1.setWidth(conv.convertWidthInCharsToPixels(15));
        TableColumn column2 = new TableColumn(this.fTable, 0);
        column2.setText(InterpretersMessages.InstalledInterpretersBlock_2);
        column2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterpretersBlock.this.sortByType();
            }
        });
        column2.setWidth(conv.convertWidthInCharsToPixels(15));
        TableColumn column3 = new TableColumn(this.fTable, 0);
        column3.setText(InterpretersMessages.InstalledInterpretersBlock_1);
        column3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterpretersBlock.this.sortByLocation();
            }
        });
        column3.setWidth(conv.convertWidthInCharsToPixels(20));
        this.fInterpreterList = new CheckboxTableViewer(this.fTable);
        this.fInterpreterList.setLabelProvider((IBaseLabelProvider)new InterpreterLabelProvider());
        this.fInterpreterList.setContentProvider((IContentProvider)new InterpretersContentProvider());
        this.sortByName();
        this.fInterpreterList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                InterpretersBlock.this.enableButtons();
            }
        });
        this.fInterpreterList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    InterpretersBlock.this.setCheckedInterpreter((IInterpreterInstall)event.getElement());
                } else {
                    InterpretersBlock.this.setCheckedInterpreter(null);
                }
            }
        });
        this.fInterpreterList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (!InterpretersBlock.this.fInterpreterList.getSelection().isEmpty()) {
                    InterpretersBlock.this.editInterpreter();
                }
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && InterpretersBlock.this.fRemoveButton.getEnabled()) {
                    InterpretersBlock.this.removeInterpreters();
                }
            }
        });
        this.fTable.layout();
        this.buttons = new Composite(parent, 0);
        this.buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.buttons.setLayout((Layout)layout);
        this.buttons.setFont(font);
        this.fAddButton = this.createPushButton(this.buttons, InterpretersMessages.InstalledInterpretersBlock_3);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InterpretersBlock.this.addInterpreter();
            }
        });
        this.fEditButton = this.createPushButton(this.buttons, InterpretersMessages.InstalledInterpretersBlock_4);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InterpretersBlock.this.editInterpreter();
            }
        });
        this.fCopyButton = this.createPushButton(this.buttons, InterpretersMessages.InstalledInterpretersBlock_16);
        this.fCopyButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InterpretersBlock.this.copyInterpreter();
            }
        });
        this.fRemoveButton = this.createPushButton(this.buttons, InterpretersMessages.InstalledInterpretersBlock_5);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InterpretersBlock.this.removeInterpreters();
            }
        });
        Label separator = new Label(this.buttons, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        this.fSearchButton = this.createPushButton(this.buttons, InterpretersMessages.InstalledInterpretersBlock_6);
        this.fSearchButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InterpretersBlock.this.search();
            }
        });
        this.fillWithWorkspaceInterpreters();
        this.enableButtons();
        this.fAddButton.setEnabled(ScriptRuntime.getInterpreterInstallTypes((String)this.getCurrentNature()).length > 0);
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] listeners = this.fSelectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    private void sortByType() {
        this.fInterpreterList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IInterpreterInstall && e2 instanceof IInterpreterInstall) {
                    String rightType;
                    IInterpreterInstall left = (IInterpreterInstall)e1;
                    IInterpreterInstall right = (IInterpreterInstall)e2;
                    String leftType = left.getInterpreterInstallType().getName();
                    int res = leftType.compareToIgnoreCase(rightType = right.getInterpreterInstallType().getName());
                    if (res != 0) {
                        return res;
                    }
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 3;
    }

    private void sortByName() {
        this.fInterpreterList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IInterpreterInstall && e2 instanceof IInterpreterInstall) {
                    IInterpreterInstall left = (IInterpreterInstall)e1;
                    IInterpreterInstall right = (IInterpreterInstall)e2;
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 1;
    }

    private void sortByLocation() {
        this.fInterpreterList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IInterpreterInstall && e2 instanceof IInterpreterInstall) {
                    IInterpreterInstall left = (IInterpreterInstall)e1;
                    IInterpreterInstall right = (IInterpreterInstall)e2;
                    return left.getInstallLocation().toString().compareToIgnoreCase(right.getInstallLocation().toString());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 2;
    }

    protected void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fInterpreterList.getSelection();
        int selectionCount = selection.size();
        this.fEditButton.setEnabled(selectionCount == 1);
        this.fCopyButton.setEnabled(selectionCount > 0);
        if (selectionCount > 0) {
            for (IInterpreterInstall install : selection) {
                if (!this.isContributed(install)) continue;
                this.fRemoveButton.setEnabled(false);
                return;
            }
            this.fRemoveButton.setEnabled(true);
        } else {
            this.fRemoveButton.setEnabled(false);
        }
    }

    protected Button createPushButton(Composite parent, String label) {
        return SWTUtil.createPushButton((Composite)parent, (String)label, null);
    }

    private boolean isContributed(IInterpreterInstall install) {
        return ScriptRuntime.isContributedInterpreterInstall((String)install.getId());
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setInterpreters(IInterpreterInstall[] Interpreters) {
        this.fInterpreters.clear();
        int i = 0;
        while (i < Interpreters.length) {
            this.fInterpreters.add(Interpreters[i]);
            ++i;
        }
        this.fInterpreterList.setInput(this.fInterpreters);
        this.fInterpreterList.refresh();
    }

    public IInterpreterInstall[] getInterpreters() {
        return this.fInterpreters.toArray(new IInterpreterInstall[this.fInterpreters.size()]);
    }

    public IInterpreterInstall[] getCurrentInterprers() {
        IEnvironment environment = this.getCurrentEnvironment();
        ArrayList<IInterpreterInstall> result = new ArrayList<IInterpreterInstall>();
        for (IInterpreterInstall install : this.fInterpreters) {
            if (!install.getInstallLocation().getEnvironmentId().equals(environment.getId())) continue;
            result.add(install);
        }
        return result.toArray(new IInterpreterInstall[result.size()]);
    }

    public boolean isDuplicateName(String name, IInterpreterInstall editedInterpreter) {
        int i = 0;
        while (i < this.fInterpreters.size()) {
            IInterpreterInstall interpreter = this.fInterpreters.get(i);
            if (interpreter.getName().equals(name) && interpreter != editedInterpreter) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isDuplicate(IFileHandle location) {
        int i = 0;
        while (i < this.fInterpreters.size()) {
            IInterpreterInstall interpreter = this.fInterpreters.get(i);
            if (interpreter.getInstallLocation().equals(location)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void removeInterpreters() {
        IStructuredSelection selection = (IStructuredSelection)this.fInterpreterList.getSelection();
        IInterpreterInstall[] Interpreters = new IInterpreterInstall[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Interpreters[i] = (IInterpreterInstall)iter.next();
            ++i;
        }
        this.removeInterpreters(Interpreters);
    }

    public void removeInterpreters(IInterpreterInstall[] Interpreters) {
        IStructuredSelection prev = (IStructuredSelection)this.getSelection();
        int i = 0;
        while (i < Interpreters.length) {
            this.fInterpreters.remove(Interpreters[i]);
            ++i;
        }
        this.fInterpreterList.refresh();
        IStructuredSelection curr = (IStructuredSelection)this.getSelection();
        if (!curr.equals(prev)) {
            IInterpreterInstall[] installs = this.getInterpreters();
            if (curr.size() == 0 && installs.length == 1) {
                this.setSelection((ISelection)new StructuredSelection((Object)installs[0]));
            } else {
                this.fireSelectionChanged();
            }
        }
    }

    protected void search() {
        final HashSet<IFileHandle> exstingLocations = new HashSet<IFileHandle>();
        Iterator<IInterpreterInstall> iter = this.fInterpreters.iterator();
        while (iter.hasNext()) {
            exstingLocations.add(iter.next().getInstallLocation());
        }
        final InterpreterSearcher searcher = new InterpreterSearcher();
        final IEnvironment currentEnvironment = this.getCurrentEnvironment();
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(InterpretersMessages.InstalledInterpretersBlock_11, -1);
                    searcher.search(currentEnvironment, InterpretersBlock.this.getCurrentNature(), exstingLocations, 1, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            ProgressMonitorDialog progress = new ProgressMonitorDialog(this.getShell()){

                protected void createCancelButton(Composite parent) {
                    super.createCancelButton(parent);
                    this.cancel.setText(InterpretersMessages.InterpretersBlock_0);
                }
            };
            progress.run(true, true, r);
        }
        catch (InvocationTargetException e) {
            DLTKDebugUIPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        final int[] widths = new int[]{15, 15};
        if (!searcher.hasResults()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)InterpretersMessages.InstalledInterpretersBlock_12, (String)InterpretersMessages.InstalledInterpretersBlock_113);
        } else {
            IFileHandle[] locations = searcher.getFoundFiles();
            IInterpreterInstallType[] types = searcher.getFoundInstallTypes();
            boolean added = false;
            int i = 0;
            while (i < locations.length) {
                IFileHandle file = locations[i];
                IInterpreterInstallType type = types[i];
                if (!this.isDuplicate(file)) {
                    String name;
                    added = true;
                    InterpreterStandin interpreter = new InterpreterStandin(type, this.createUniqueId(type));
                    String nameCopy = name = file.getName();
                    int j = 1;
                    while (this.isDuplicateName(nameCopy, null)) {
                        nameCopy = String.valueOf(name) + '(' + j++ + ')';
                    }
                    if (widths[0] < nameCopy.length()) {
                        widths[0] = nameCopy.length() + 2;
                    }
                    if (widths[1] < type.getName().length()) {
                        widths[1] = type.getName().length() + 2;
                    }
                    interpreter.setName(nameCopy);
                    interpreter.setInstallLocation(file);
                    this.interpreterAdded((IInterpreterInstall)interpreter);
                }
                ++i;
            }
            if (!added) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)InterpretersMessages.InstalledInterpretersBlock_12, (String)InterpretersMessages.InstalledInterpretersBlock_113);
            }
            this.fTable.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PixelConverter conv = new PixelConverter((Control)InterpretersBlock.this.fTable);
                    int i = 0;
                    while (i < 2) {
                        int nw1 = conv.convertWidthInCharsToPixels(widths[i]);
                        TableColumn cl0 = InterpretersBlock.this.fTable.getColumn(i);
                        if (cl0.getWidth() < nw1) {
                            cl0.setWidth(nw1);
                        }
                        ++i;
                    }
                    InterpretersBlock.this.fTable.layout();
                }
            });
        }
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public void setCheckedInterpreter(IInterpreterInstall interpreter) {
        if (interpreter == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            if (interpreter.getEnvironment().equals(this.getCurrentEnvironment())) {
                this.setSelection((ISelection)new StructuredSelection((Object)interpreter));
            }
            this.checkedInterpreters.put(interpreter.getEnvironment(), interpreter);
        }
    }

    public IInterpreterInstall[] getCheckedInterpreters() {
        Collection<IInterpreterInstall> values = this.checkedInterpreters.values();
        IInterpreterInstall[] installs = new IInterpreterInstall[values.size()];
        int i = 0;
        Iterator<IInterpreterInstall> iterator = values.iterator();
        while (iterator.hasNext()) {
            installs[i] = iterator.next();
            ++i;
        }
        return installs;
    }

    public void saveColumnSettings(IDialogSettings settings, String qualifier) {
        int columnCount = this.fTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            settings.put(String.valueOf(qualifier) + ".columnWidth" + i, this.fTable.getColumn(i).getWidth());
            ++i;
        }
        settings.put(String.valueOf(qualifier) + ".sortColumn", this.fSortColumn);
    }

    public void restoreColumnSettings(IDialogSettings settings, String qualifier) {
        this.fInterpreterList.getTable().layout(true);
        this.restoreColumnWidths(settings, qualifier);
        try {
            this.fSortColumn = settings.getInt(String.valueOf(qualifier) + ".sortColumn");
        }
        catch (NumberFormatException numberFormatException) {
            this.fSortColumn = 1;
        }
        switch (this.fSortColumn) {
            case 1: {
                this.sortByName();
                break;
            }
            case 2: {
                this.sortByLocation();
                break;
            }
            case 3: {
                this.sortByType();
            }
        }
    }

    private void restoreColumnWidths(IDialogSettings settings, String qualifier) {
        int columnCount = this.fTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            int width = -1;
            try {
                width = settings.getInt(String.valueOf(qualifier) + ".columnWidth" + i);
            }
            catch (NumberFormatException numberFormatException) {}
            if (width <= 0) {
                this.fTable.getColumn(i).pack();
            } else {
                this.fTable.getColumn(i).setWidth(width);
            }
            ++i;
        }
    }

    protected void fillWithWorkspaceInterpreters() {
        ArrayList<InterpreterStandin> standins = new ArrayList<InterpreterStandin>();
        IInterpreterInstallType[] types = ScriptRuntime.getInterpreterInstallTypes((String)this.getCurrentNature());
        int i = 0;
        while (i < types.length) {
            IInterpreterInstallType type = types[i];
            IInterpreterInstall[] installs = type.getInterpreterInstalls();
            if (installs != null) {
                int j = 0;
                while (j < installs.length) {
                    IInterpreterInstall install = installs[j];
                    standins.add(new InterpreterStandin(install));
                    ++j;
                }
            }
            ++i;
        }
        this.setInterpreters(standins.toArray(new IInterpreterInstall[standins.size()]));
    }

    public void interpreterAdded(IInterpreterInstall Interpreter) {
        this.fInterpreters.add(Interpreter);
        this.fInterpreterList.refresh();
        IInterpreterInstall[] installs = this.getCurrentInterprers();
        if (installs.length == 1) {
            this.setSelection((ISelection)new StructuredSelection((Object)installs[0]));
        }
        this.fireSelectionChanged();
        this.packColumns();
    }

    protected void packColumns() {
        int columnCount = this.fTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            this.fTable.getColumn(i).pack();
            ++i;
        }
    }

    protected String createUniqueId(IInterpreterInstallType InterpreterType) {
        String id = null;
        while (InterpreterType.findInterpreterInstall(id = String.valueOf(System.currentTimeMillis())) != null || id.equals(fgLastUsedID)) {
        }
        fgLastUsedID = id;
        return id;
    }

    protected String generateName(String name) {
        if (!this.isDuplicateName(name, null)) {
            return name;
        }
        if (name.matches(".*\\(\\d*\\)")) {
            int start = name.lastIndexOf(40);
            int end = name.lastIndexOf(41);
            String stringInt = name.substring(start + 1, end);
            int numericValue = Integer.parseInt(stringInt);
            String newName = String.valueOf(name.substring(0, start + 1)) + (numericValue + 1) + ")";
            return this.generateName(newName);
        }
        return this.generateName(String.valueOf(name) + " (1)");
    }

    protected abstract String getCurrentNature();

    protected IScriptInterpreterDialog createInterpreterDialog(IEnvironment environment, IInterpreterInstall standin) {
        AddScriptInterpreterDialog dialog = this.createInterpreterDialog(standin);
        if (dialog != null) {
            dialog.setEnvironment(environment);
        }
        return dialog;
    }

    protected AddScriptInterpreterDialog createInterpreterDialog(IInterpreterInstall standin) {
        return null;
    }

    protected void copyInterpreter() {
        IStructuredSelection selection = (IStructuredSelection)this.fInterpreterList.getSelection();
        Iterator it = selection.iterator();
        ArrayList<InterpreterStandin> newEntries = new ArrayList<InterpreterStandin>();
        while (it.hasNext()) {
            IInterpreterInstall selectedInterpreter = (IInterpreterInstall)it.next();
            InterpreterStandin standin = new InterpreterStandin(selectedInterpreter, this.createUniqueId(selectedInterpreter.getInterpreterInstallType()));
            standin.setName(this.generateName(selectedInterpreter.getName()));
            IScriptInterpreterDialog dialog = this.createInterpreterDialog(this.getCurrentEnvironment(), (IInterpreterInstall)standin);
            if (dialog == null) {
                return;
            }
            dialog.setTitle(InterpretersMessages.InstalledInterpretersBlock_18);
            if (!dialog.execute()) {
                return;
            }
            newEntries.add(standin);
            this.fInterpreters.add((IInterpreterInstall)standin);
        }
        this.fInterpreterList.refresh();
        this.fInterpreterList.setSelection((ISelection)new StructuredSelection(newEntries.toArray()));
    }

    protected void addInterpreter() {
        IScriptInterpreterDialog dialog = this.createInterpreterDialog(this.getCurrentEnvironment(), null);
        if (dialog == null) {
            return;
        }
        dialog.setTitle(InterpretersMessages.InstalledInterpretersBlock_7);
        if (!dialog.execute()) {
            return;
        }
        this.fInterpreterList.refresh();
    }

    protected void editInterpreter() {
        IStructuredSelection selection = (IStructuredSelection)this.fInterpreterList.getSelection();
        IInterpreterInstall install = (IInterpreterInstall)selection.getFirstElement();
        if (install == null) {
            return;
        }
        IScriptInterpreterDialog dialog = this.createInterpreterDialog(this.getCurrentEnvironment(), install);
        if (dialog == null) {
            return;
        }
        dialog.setTitle(InterpretersMessages.InstalledInterpretersBlock_8);
        if (!dialog.execute()) {
            return;
        }
        this.fInterpreterList.refresh((Object)install);
    }

    public IEnvironment getCurrentEnvironment() {
        if (this.fEnvironments == null) {
            return EnvironmentManager.getLocalEnvironment();
        }
        return this.environments[this.fEnvironments.getSelectionIndex()];
    }

    public int getEnvironmentsCount() {
        return this.environments.length;
    }

    class InterpreterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        InterpreterLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IInterpreterInstall) {
                IInterpreterInstall interp = (IInterpreterInstall)element;
                switch (columnIndex) {
                    case 0: {
                        return interp.getName();
                    }
                    case 1: {
                        return interp.getInterpreterInstallType().getName();
                    }
                    case 2: {
                        return interp.getRawInstallLocation().toOSString();
                    }
                }
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    class InterpretersContentProvider
    implements IStructuredContentProvider {
        InterpretersContentProvider() {
        }

        public Object[] getElements(Object input) {
            return InterpretersBlock.this.getCurrentInterprers();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

