/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.formatter.AbstractFormatterNodeBuilder;
import org.eclipse.dltk.formatter.FormatterBlockNode;
import org.eclipse.dltk.formatter.FormatterEmptyNode;
import org.eclipse.dltk.formatter.FormatterIndentedBlockNode;
import org.eclipse.dltk.formatter.FormatterUtils;
import org.eclipse.dltk.formatter.IFormatterContainerNode;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterNode;
import org.eclipse.dltk.formatter.IFormatterTextNode;
import org.eclipse.dltk.javascript.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.ArrayInitializer;
import org.eclipse.dltk.javascript.ast.AsteriskExpression;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BooleanLiteral;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.CaseClause;
import org.eclipse.dltk.javascript.ast.CatchClause;
import org.eclipse.dltk.javascript.ast.CommaExpression;
import org.eclipse.dltk.javascript.ast.ConditionalOperator;
import org.eclipse.dltk.javascript.ast.ConstStatement;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.DefaultClause;
import org.eclipse.dltk.javascript.ast.DefaultXmlNamespaceStatement;
import org.eclipse.dltk.javascript.ast.DeleteStatement;
import org.eclipse.dltk.javascript.ast.DoWhileStatement;
import org.eclipse.dltk.javascript.ast.EmptyExpression;
import org.eclipse.dltk.javascript.ast.EmptyStatement;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FinallyClause;
import org.eclipse.dltk.javascript.ast.ForEachInStatement;
import org.eclipse.dltk.javascript.ast.ForInStatement;
import org.eclipse.dltk.javascript.ast.ForStatement;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetAllChildrenExpression;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.GetLocalNameExpression;
import org.eclipse.dltk.javascript.ast.GetMethod;
import org.eclipse.dltk.javascript.ast.ISemicolonStatement;
import org.eclipse.dltk.javascript.ast.IVariableStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.Method;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.NullExpression;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ParenthesizedExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SetMethod;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.SwitchComponent;
import org.eclipse.dltk.javascript.ast.SwitchStatement;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.TryStatement;
import org.eclipse.dltk.javascript.ast.TypeOfExpression;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.ast.VoidExpression;
import org.eclipse.dltk.javascript.ast.VoidOperator;
import org.eclipse.dltk.javascript.ast.WhileStatement;
import org.eclipse.dltk.javascript.ast.WithStatement;
import org.eclipse.dltk.javascript.ast.XmlAttributeIdentifier;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.YieldOperator;
import org.eclipse.dltk.javascript.formatter.internal.nodes.AbstractBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.AbstractElseBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.AbstractParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ArrayBracketsConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.BinaryOperationPinctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.BlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.BracesNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.BracketsNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.CallExpressionPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.CallParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.CaseBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.CatchBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.CatchParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ColonNodeWrapper;
import org.eclipse.dltk.javascript.formatter.internal.nodes.CommaPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ConditionalOperatorPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.DoLoopWhileWrapper;
import org.eclipse.dltk.javascript.formatter.internal.nodes.DoWhileBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ElseBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ElseIfBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ElseIfElseBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.EmptyArrayBracketsConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.EmptyObjectInitializerBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ExpressionParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FinallyBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ForEmptySemicolonPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ForParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ForSemicolonPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterBinaryOperationNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterBreakNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterCaseNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterCatchClauseNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterContinueNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterDeleteStatementNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterElseIfNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterElseKeywordNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterElseNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterFinallyClauseNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterForInStatementNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterForStatementNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterFunctionNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterLabelledStatementNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterObjectInitializerNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterRootNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterScriptNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterStringNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterSwitchNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterThrowNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterTypeofNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterVariableDeclarationNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterVoidExpressionNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterVoidOperatorNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterYieldOperatorNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FunctionArgumentsParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FunctionArgumentsPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FunctionBodyBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FunctionExpressionBodyBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FunctionNoArgumentsParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.GetItemArrayBracketsConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IBracketsConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IfConditionParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.LineBreakFormatterNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.MultiLineObjectInitializerBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.OperationOrPunctuationNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ParensNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.PropertyExpressionPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.PropertyInitializerPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.SemicolonNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.SingleLineObjectInitializerBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.SpaceAfterKeyword;
import org.eclipse.dltk.javascript.formatter.internal.nodes.StatementBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.SwitchBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.SwitchConditionParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ThenBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.TryBodyConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.WhileBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.WhileConditionParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.WithBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.WithConditionParensConfiguration;
import org.eclipse.dltk.utils.IntList;

public class FormatterNodeBuilder
extends AbstractFormatterNodeBuilder {
    protected final IFormatterDocument document;
    private Stack<ASTNode> nodes = new Stack();
    private final Map<ASTNode, Boolean> processed = new IdentityHashMap<ASTNode, Boolean>();

    public FormatterNodeBuilder(IFormatterDocument document) {
        this.document = document;
    }

    protected void start(IFormatterContainerNode root) {
        super.start(root);
        this.nodes.clear();
        this.processed.clear();
    }

    private boolean isBlock(IFormatterContainerNode node) {
        return node instanceof FormatterBlockNode && !(node instanceof BracesNode) && !(node instanceof ParensNode);
    }

    private boolean isStatement(ASTNode node) {
        if (this.isMultiLineObjectInitializerComponent(node)) {
            return true;
        }
        if (node instanceof SwitchComponent) {
            return true;
        }
        if (!(node instanceof Statement)) {
            return false;
        }
        JSNode statement = (JSNode)node;
        ASTNode parent = statement.getParent();
        return !(parent instanceof ForStatement) && !(parent instanceof IfStatement) && !(parent instanceof WhileStatement);
    }

    private boolean isMultiLineObjectInitializerComponent(ASTNode node) {
        PropertyInitializer initializer;
        if (node instanceof PropertyInitializer && (initializer = (PropertyInitializer)node).getValue() instanceof FunctionStatement) {
            return true;
        }
        return node instanceof Method;
    }

    private boolean isMultiLineObjectInitializer(ObjectInitializer initializer) {
        for (ASTNode component : initializer.getInitializers()) {
            if (!this.isMultiLineObjectInitializerComponent(component)) continue;
            return true;
        }
        return false;
    }

    protected void push(IFormatterContainerNode node) {
        ASTNode astNode;
        if (this.document.getBoolean("formatter.statement.new.line") && this.isBlock(node) && this.isStatement(astNode = this.nodes.peek()) && this.processed.put(astNode, Boolean.TRUE) == null) {
            super.push((IFormatterContainerNode)new LineBreakFormatterNode(node));
            return;
        }
        super.push(node);
    }

    public IFormatterContainerNode build(Script astRoot) {
        FormatterRootNode root = new FormatterRootNode(this.document);
        this.start((IFormatterContainerNode)root);
        astRoot.visitAll((ASTVisitor)new ASTVisitor<IFormatterNode>(){

            public IFormatterNode visit(ASTNode node) {
                if (node instanceof Keyword) {
                    return FormatterNodeBuilder.this.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, node));
                }
                if (node instanceof PropertyInitializer) {
                    FormatterNodeBuilder.this.nodes.push(node);
                    IFormatterNode result = this.formatPropertyInitializer((PropertyInitializer)node);
                    FormatterNodeBuilder.this.nodes.pop();
                    return result;
                }
                if (node instanceof GetMethod) {
                    FormatterNodeBuilder.this.nodes.push(node);
                    IFormatterNode result = this.formatGetMethod((GetMethod)node);
                    FormatterNodeBuilder.this.nodes.pop();
                    return result;
                }
                if (node instanceof SetMethod) {
                    FormatterNodeBuilder.this.nodes.push(node);
                    IFormatterNode result = this.formatSetMethod((SetMethod)node);
                    FormatterNodeBuilder.this.nodes.pop();
                    return result;
                }
                FormatterNodeBuilder.this.nodes.push(node);
                IFormatterNode result = (IFormatterNode)super.visit(node);
                FormatterNodeBuilder.this.nodes.pop();
                return result;
            }

            public IFormatterNode visitArrayInitializer(ArrayInitializer node) {
                ArrayBracketsConfiguration configuration = node.getItems().size() > 0 ? new ArrayBracketsConfiguration(FormatterNodeBuilder.this.document, (JSNode)node) : new EmptyArrayBracketsConfiguration(FormatterNodeBuilder.this.document, (JSNode)node);
                return this.processBrackets(node.getLB(), node.getRB(), node.getItems(), node.getCommas(), configuration);
            }

            public IFormatterNode visitBinaryOperation(BinaryOperation node) {
                FormatterBinaryOperationNode formatterNode = new FormatterBinaryOperationNode(FormatterNodeBuilder.this.document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getLeftExpression());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getOperationPosition());
                this.processPunctuation(node.getOperationPosition(), node.getOperationText().length(), new BinaryOperationPinctuationConfiguration());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getRightExpression().sourceStart());
                this.visit((ASTNode)node.getRightExpression());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitBooleanLiteral(BooleanLiteral node) {
                return FormatterNodeBuilder.this.addChild((IFormatterNode)new FormatterStringNode(FormatterNodeBuilder.this.document, (ASTNode)node));
            }

            public IFormatterNode visitBreakStatement(BreakStatement node) {
                FormatterBreakNode formatterNode = new FormatterBreakNode(FormatterNodeBuilder.this.document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getBreakKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                if (node.getLabel() != null) {
                    FormatterNodeBuilder.this.addChild((IFormatterNode)new FormatterStringNode(FormatterNodeBuilder.this.document, (ASTNode)node.getLabel()));
                }
                return this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, (ISemicolonStatement)node);
            }

            public IFormatterNode visitCallExpression(CallExpression node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getExpression());
                this.processParens(node.getLP(), node.getRP(), node.getArguments(), new CallParensConfiguration(FormatterNodeBuilder.this.document), node.getCommas(), new CallExpressionPunctuationConfiguration(), node.getArguments().size() > 1);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            private IFormatterNode processSwitchComponent(FormatterCaseNode caseNode, SwitchComponent node) {
                if (node.getStatements().size() == 1 && node.getStatements().get(0) instanceof StatementBlock) {
                    CaseBracesConfiguration configuration = new CaseBracesConfiguration(FormatterNodeBuilder.this.document);
                    caseNode.setIndenting(false);
                    this.processBraces((ASTNode)node.getStatements().get(0), configuration);
                } else {
                    this.visit(node.getStatements());
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)caseNode, node.sourceEnd());
                return caseNode;
            }

            private IFormatterNode visitCombinedNodeList(List<? extends ASTNode> nodes, IntList punctuations, List<IPunctuationConfiguration> configurations) {
                if (nodes.isEmpty()) {
                    return null;
                }
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, nodes.get(0).sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                int i = 0;
                while (i < nodes.size()) {
                    this.visit(nodes.get(i));
                    if (i < punctuations.size() && i + 1 < nodes.size()) {
                        int position = punctuations.get(i);
                        this.skipSpacesOnly((IFormatterContainerNode)formatterNode, position);
                        this.processPunctuation(position, 1, configurations.get(i));
                        this.skipSpacesOnly((IFormatterContainerNode)formatterNode, nodes.get(i + 1).sourceStart());
                    }
                    ++i;
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, nodes.get(nodes.size() - 1).sourceEnd());
                return formatterNode;
            }

            private IFormatterNode visitCombinedNodeList(List<? extends ASTNode> nodes, IntList punctuations, IPunctuationConfiguration configuration) {
                return this.visitCombinedNodeList(nodes, punctuations, Collections.nCopies(punctuations.size(), configuration));
            }

            public IFormatterNode visitCommaExpression(CommaExpression node) {
                return this.visitCombinedNodeList((List<? extends ASTNode>)node.getItems(), node.getCommas(), new CommaPunctuationConfiguration());
            }

            public IFormatterNode visitConditionalOperator(ConditionalOperator node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getCondition());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getQuestionPosition());
                this.processPunctuation(node.getQuestionPosition(), 1, new ConditionalOperatorPunctuationConfiguration());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getTrueValue().sourceStart());
                this.visit((ASTNode)node.getTrueValue());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getColonPosition());
                this.processPunctuation(node.getColonPosition(), 1, new ConditionalOperatorPunctuationConfiguration());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getFalseValue().sourceStart());
                this.visit((ASTNode)node.getFalseValue());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitConstDeclaration(ConstStatement node) {
                FormatterVariableDeclarationNode formatterNode = new FormatterVariableDeclarationNode(FormatterNodeBuilder.this.document, this.isIndentVariableStatement((IVariableStatement)node));
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getConstKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processVariableDeclarations((IVariableStatement)node);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitContinueStatement(ContinueStatement node) {
                FormatterContinueNode formatterNode = new FormatterContinueNode(FormatterNodeBuilder.this.document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getContinueKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                if (node.getLabel() != null) {
                    FormatterNodeBuilder.this.addChild((IFormatterNode)new FormatterStringNode(FormatterNodeBuilder.this.document, (ASTNode)node.getLabel()));
                }
                return this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, (ISemicolonStatement)node);
            }

            private IFormatterNode processOptionalSemicolon(IFormatterContainerNode formatterNode, ISemicolonStatement node) {
                int semicolonPosition = node.getSemicolonPosition();
                if (semicolonPosition > -1) {
                    FormatterNodeBuilder.this.checkedPop(formatterNode, semicolonPosition);
                    if (semicolonPosition >= formatterNode.getEndOffset()) {
                        FormatterNodeBuilder.this.addChild((IFormatterNode)FormatterNodeBuilder.this.createSemicolonNode(FormatterNodeBuilder.this.document, semicolonPosition));
                    }
                } else {
                    FormatterNodeBuilder.this.checkedPop(formatterNode, node.sourceEnd());
                }
                return formatterNode;
            }

            public IFormatterNode visitDecimalLiteral(DecimalLiteral node) {
                return FormatterNodeBuilder.this.addChild((IFormatterNode)new FormatterStringNode(FormatterNodeBuilder.this.document, (ASTNode)node));
            }

            public IFormatterNode visitDeleteStatement(DeleteStatement node) {
                FormatterDeleteStatementNode formatterNode = new FormatterDeleteStatementNode(FormatterNodeBuilder.this.document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getDeleteKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getExpression());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.getExpression().sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitDoWhileStatement(DoWhileStatement node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getDoKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processBraces((ASTNode)node.getBody(), new DoWhileBlockBracesConfiguration(FormatterNodeBuilder.this.document));
                formatterNode.addChild((IFormatterNode)new DoLoopWhileWrapper(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getWhileKeyword())));
                this.processParens(node.getLP(), node.getRP(), (ASTNode)node.getCondition(), (IParensConfiguration)new WhileConditionParensConfiguration(FormatterNodeBuilder.this.document));
                return this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, (ISemicolonStatement)node);
            }

            public IFormatterNode visitEmptyExpression(EmptyExpression node) {
                return null;
            }

            public IFormatterNode visitForEachInStatement(ForEachInStatement node) {
                FormatterForInStatementNode formatterNode = new FormatterForInStatementNode(FormatterNodeBuilder.this.document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getForKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
                nodes.add((ASTNode)node.getItem());
                nodes.add((ASTNode)node.getInKeyword());
                nodes.add((ASTNode)node.getIterator());
                this.processParens(node.getLP(), node.getRP(), nodes, (IParensConfiguration)new ForParensConfiguration(FormatterNodeBuilder.this.document));
                if (node.getBody() != null) {
                    this.processBraces((ASTNode)node.getBody(), new BlockBracesConfiguration(FormatterNodeBuilder.this.document));
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitForInStatement(ForInStatement node) {
                FormatterForInStatementNode formatterNode = new FormatterForInStatementNode(FormatterNodeBuilder.this.document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getForKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
                nodes.add((ASTNode)node.getItem());
                nodes.add((ASTNode)node.getInKeyword());
                nodes.add((ASTNode)node.getIterator());
                this.processParens(node.getLP(), node.getRP(), nodes, (IParensConfiguration)new ForParensConfiguration(FormatterNodeBuilder.this.document));
                if (node.getBody() != null) {
                    this.processBraces((ASTNode)node.getBody(), new BlockBracesConfiguration(FormatterNodeBuilder.this.document));
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitForStatement(ForStatement node) {
                FormatterForStatementNode formatterNode = new FormatterForStatementNode(FormatterNodeBuilder.this.document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getForKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
                nodes.add((ASTNode)node.getInitial());
                nodes.add((ASTNode)node.getCondition());
                nodes.add((ASTNode)node.getStep());
                IntList semicolons = new IntList();
                semicolons.add(node.getInitialSemicolonPosition());
                semicolons.add(node.getConditionalSemicolonPosition());
                ArrayList<IPunctuationConfiguration> semicolonConfigurations = new ArrayList<IPunctuationConfiguration>();
                if (node.getCondition() instanceof EmptyExpression) {
                    semicolonConfigurations.add(new ForEmptySemicolonPunctuationConfiguration());
                } else {
                    semicolonConfigurations.add(new ForSemicolonPunctuationConfiguration());
                }
                if (node.getStep() instanceof EmptyExpression) {
                    semicolonConfigurations.add(new ForEmptySemicolonPunctuationConfiguration());
                } else {
                    semicolonConfigurations.add(new ForSemicolonPunctuationConfiguration());
                }
                this.processParens(node.getLP(), node.getRP(), nodes, new ForParensConfiguration(FormatterNodeBuilder.this.document), semicolons, semicolonConfigurations);
                if (node.getBody() != null) {
                    this.processBraces((ASTNode)node.getBody(), new BlockBracesConfiguration(FormatterNodeBuilder.this.document));
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitFunctionStatement(FunctionStatement node) {
                FormatterFunctionNode formatterNode = new FormatterFunctionNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getFunctionKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                if (node.getName() != null) {
                    this.visit((ASTNode)node.getName());
                }
                AbstractParensConfiguration parensConf = node.getArguments().isEmpty() ? new FunctionNoArgumentsParensConfiguration(FormatterNodeBuilder.this.document) : new FunctionArgumentsParensConfiguration(FormatterNodeBuilder.this.document);
                ParensNode parens = new ParensNode(FormatterNodeBuilder.this.document, parensConf);
                parens.setBegin(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, node.getLP()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)parens);
                if (!node.getArguments().isEmpty()) {
                    Argument arg0 = (Argument)node.getArguments().get(0);
                    this.skipSpaces((IFormatterContainerNode)parens, arg0.sourceStart());
                }
                for (Argument argument : node.getArguments()) {
                    this.visit((ASTNode)argument.getIdentifier());
                    if (argument.getCommaPosition() == -1) continue;
                    int position = argument.getCommaPosition();
                    this.skipSpacesOnly((IFormatterContainerNode)parens, position);
                    this.processPunctuation(position, 1, new FunctionArgumentsPunctuationConfiguration());
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parens, node.getRP());
                parens.setEnd(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, node.getRP()));
                boolean emptyBody = node.getBody() == null || this.isEmptyBody(node.getBody());
                FunctionBodyBracesConfiguration bodyConfiguration = node.getName() != null ? new FunctionBodyBracesConfiguration(FormatterNodeBuilder.this.document, emptyBody) : new FunctionExpressionBodyBracesConfiguration(FormatterNodeBuilder.this.document, emptyBody);
                this.processBraces((ASTNode)node.getBody(), bodyConfiguration);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            private boolean isEmptyBody(StatementBlock block) {
                if (block.getStatements().isEmpty()) {
                    int i = block.getLC() + 1;
                    while (i < block.getRC()) {
                        if (!Character.isWhitespace(FormatterNodeBuilder.this.document.charAt(i))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                return false;
            }

            private boolean isEmpty(ObjectInitializer initializer) {
                if (initializer.getInitializers().isEmpty()) {
                    int i = initializer.getLC() + 1;
                    while (i < initializer.getRC()) {
                        if (!Character.isWhitespace(FormatterNodeBuilder.this.document.charAt(i))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                return false;
            }

            public IFormatterNode visitGetArrayItemExpression(GetArrayItemExpression node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getArray());
                this.processBrackets(node.getLB(), node.getRB(), Collections.singletonList(node.getIndex()), IntList.EMPTY_LIST, new GetItemArrayBracketsConfiguration(FormatterNodeBuilder.this.document));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            private IFormatterNode formatGetMethod(GetMethod node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getGetKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getName());
                this.processParens(node.getLP(), node.getRP(), (ASTNode)null, (IParensConfiguration)new FunctionNoArgumentsParensConfiguration(FormatterNodeBuilder.this.document));
                boolean emptyBody = node.getBody() == null || this.isEmptyBody(node.getBody());
                this.processBraces((ASTNode)node.getBody(), new FunctionBodyBracesConfiguration(FormatterNodeBuilder.this.document, emptyBody));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitIdentifier(Identifier node) {
                return FormatterNodeBuilder.this.addChild((IFormatterNode)new FormatterStringNode(FormatterNodeBuilder.this.document, (ASTNode)node));
            }

            private IFormatterNode processParens(int leftParen, int rightParen, ASTNode expression, IParensConfiguration configuration) {
                ParensNode parens = new ParensNode(FormatterNodeBuilder.this.document, configuration);
                parens.setBegin(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, leftParen));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)parens);
                if (expression != null) {
                    this.skipSpaces((IFormatterContainerNode)parens, expression.sourceStart());
                    this.visit(expression);
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parens, rightParen);
                parens.setEnd(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, rightParen));
                return parens;
            }

            private void processParens(int leftParen, int rightParen, List<? extends ASTNode> expressions, IParensConfiguration configuration, IntList punctuations, IPunctuationConfiguration punctuationConfiguration, boolean indenting) {
                ParensNode parens = new ParensNode(FormatterNodeBuilder.this.document, configuration, indenting);
                parens.setBegin(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, leftParen));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)parens);
                if (!expressions.isEmpty()) {
                    ASTNode expression0 = expressions.get(0);
                    this.skipSpaces((IFormatterContainerNode)parens, expression0.sourceStart());
                }
                this.visitCombinedNodeList(expressions, punctuations, punctuationConfiguration);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parens, rightParen);
                parens.setEnd(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, rightParen));
            }

            private void processParens(int leftParen, int rightParen, List<ASTNode> expressions, IParensConfiguration configuration, IntList punctuations, List<IPunctuationConfiguration> punctuationConfigurations) {
                ParensNode parens = new ParensNode(FormatterNodeBuilder.this.document, configuration);
                parens.setBegin(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, leftParen));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)parens);
                if (!expressions.isEmpty()) {
                    ASTNode expression0 = expressions.get(0);
                    this.skipSpaces((IFormatterContainerNode)parens, expression0.sourceStart());
                }
                this.visitCombinedNodeList(expressions, punctuations, punctuationConfigurations);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parens, rightParen);
                parens.setEnd(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, rightParen));
            }

            private void processParens(int leftParen, int rightParen, List<ASTNode> expressions, IParensConfiguration configuration) {
                ParensNode parens = new ParensNode(FormatterNodeBuilder.this.document, configuration);
                parens.setBegin(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, leftParen));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)parens);
                if (!expressions.isEmpty()) {
                    ASTNode expression0 = expressions.get(0);
                    this.skipSpaces((IFormatterContainerNode)parens, expression0.sourceStart());
                }
                this.visitNodeList(expressions);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parens, rightParen);
                parens.setEnd(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, rightParen));
            }

            private void skipSpacesOnly(IFormatterContainerNode formatterNode, int end) {
                int prev;
                int pos = prev = formatterNode.getEndOffset();
                while (pos < end && FormatterUtils.isSpace((char)FormatterNodeBuilder.this.document.charAt(pos))) {
                    ++pos;
                }
                if (pos > prev) {
                    formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, pos));
                }
            }

            private void skipSpaces(IFormatterContainerNode formatterNode, int end) {
                int prev;
                int pos = prev = formatterNode.getEndOffset();
                while (pos < end && Character.isWhitespace(FormatterNodeBuilder.this.document.charAt(pos))) {
                    ++pos;
                }
                if (pos > prev) {
                    formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, pos));
                }
            }

            private void processPunctuation(int position, int length, IPunctuationConfiguration configuration) {
                FormatterNodeBuilder.this.addChild((IFormatterNode)new OperationOrPunctuationNode(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, position, position + length), configuration));
            }

            private IFormatterNode processBraces(ASTNode node, IBracesConfiguration configuration) {
                if (node instanceof StatementBlock) {
                    StatementBlock block = (StatementBlock)node;
                    if (block.getLC() > -1 && block.getRC() > -1) {
                        BracesNode braces = new BracesNode(FormatterNodeBuilder.this.document, configuration);
                        braces.setBegin(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, block.getLC()));
                        FormatterNodeBuilder.this.push((IFormatterContainerNode)braces);
                        this.skipSpacesOnly((IFormatterContainerNode)braces, block.getRC());
                        this.visitNodeList(block.getStatements());
                        FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)braces, block.getRC());
                        braces.setEnd(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, block.getRC()));
                        return braces;
                    }
                    FormatterIndentedBlockNode formatter = new FormatterIndentedBlockNode(FormatterNodeBuilder.this.document, configuration.isIndenting());
                    formatter.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, node.sourceStart()));
                    FormatterNodeBuilder.this.push((IFormatterContainerNode)formatter);
                    this.visitNodeList(block.getStatements());
                    FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatter, node.sourceEnd());
                    return formatter;
                }
                FormatterIndentedBlockNode block = new FormatterIndentedBlockNode(FormatterNodeBuilder.this.document, configuration.isIndenting());
                block.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)block);
                this.visit(node);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)block, node.sourceEnd());
                return block;
            }

            private IFormatterNode processBrackets(int leftBracket, int rightBracket, List<Expression> nodes, IntList commas, IBracketsConfiguration configuration) {
                BracketsNode brackets = new BracketsNode(FormatterNodeBuilder.this.document, configuration);
                brackets.setBegin(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, leftBracket));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)brackets);
                if (!nodes.isEmpty()) {
                    this.skipSpaces((IFormatterContainerNode)brackets, nodes.get(0).sourceStart());
                }
                if (!commas.isEmpty()) {
                    this.visitCombinedNodeList(nodes, commas, Collections.nCopies(commas.size(), (IPunctuationConfiguration)((Object)configuration)));
                } else {
                    this.visitCombinedNodeList(nodes, commas, Collections.<IPunctuationConfiguration>emptyList());
                }
                if (!nodes.isEmpty()) {
                    this.skipSpaces((IFormatterContainerNode)brackets, rightBracket);
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)brackets, rightBracket);
                brackets.setEnd(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, rightBracket));
                return brackets;
            }

            private void processElseIf(ASTNode node, IBracesConfiguration configuration) {
                BracesNode braces = new BracesNode(FormatterNodeBuilder.this.document, configuration);
                braces.setBegin(FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)braces);
                this.visit(node);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)braces, node.sourceEnd());
            }

            public IFormatterNode visitIfStatement(IfStatement node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getIfKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processParens(node.getLP(), node.getRP(), (ASTNode)node.getCondition(), (IParensConfiguration)new IfConditionParensConfiguration(FormatterNodeBuilder.this.document));
                if (node.getThenStatement() != null) {
                    AbstractBracesConfiguration thenConf = node.getElseStatement() != null ? new ThenBlockBracesConfiguration(FormatterNodeBuilder.this.document) : new BlockBracesConfiguration(FormatterNodeBuilder.this.document);
                    this.processBraces((ASTNode)node.getThenStatement(), thenConf);
                    FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.getThenStatement().sourceEnd());
                } else {
                    FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                }
                if (node.getElseStatement() != null) {
                    AbstractElseBracesConfiguration elseConfiguration;
                    boolean lineBreakBeforeElse = node.getThenStatement() == null || !(node.getThenStatement() instanceof StatementBlock);
                    FormatterElseNode elseNode = null;
                    if (node.getElseStatement() instanceof IfStatement) {
                        IfStatement elseStatement = (IfStatement)node.getElseStatement();
                        elseConfiguration = elseStatement.getElseStatement() == null ? new ElseIfBlockBracesConfiguration(FormatterNodeBuilder.this.document) : new ElseIfElseBlockBracesConfiguration(FormatterNodeBuilder.this.document);
                        elseNode = new FormatterElseIfNode(FormatterNodeBuilder.this.document, lineBreakBeforeElse);
                    } else {
                        elseConfiguration = new ElseBlockBracesConfiguration(FormatterNodeBuilder.this.document);
                        elseNode = new FormatterElseNode(FormatterNodeBuilder.this.document, lineBreakBeforeElse);
                    }
                    elseNode.addChild((IFormatterNode)new FormatterElseKeywordNode(FormatterNodeBuilder.this.document, node.getElseKeyword().sourceStart(), node.getElseKeyword().sourceEnd()));
                    FormatterNodeBuilder.this.push((IFormatterContainerNode)elseNode);
                    if (node.getElseStatement() instanceof IfStatement) {
                        this.processElseIf((ASTNode)node.getElseStatement(), elseConfiguration);
                    } else {
                        this.processBraces((ASTNode)node.getElseStatement(), elseConfiguration);
                    }
                    FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)elseNode, node.getElseStatement().sourceEnd());
                }
                return formatterNode;
            }

            public IFormatterNode visitLabelledStatement(LabelledStatement node) {
                FormatterLabelledStatementNode formatterNode = new FormatterLabelledStatementNode(FormatterNodeBuilder.this.document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getLabel()));
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, node.getColonPosition()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processBraces((ASTNode)node.getStatement(), new CaseBracesConfiguration(FormatterNodeBuilder.this.document));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitNewExpression(NewExpression node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getNewKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getObjectClass());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitNullExpression(NullExpression node) {
                return FormatterNodeBuilder.this.addChild((IFormatterNode)new FormatterStringNode(FormatterNodeBuilder.this.document, (ASTNode)node));
            }

            public IFormatterNode visitObjectInitializer(ObjectInitializer node) {
                AbstractBracesConfiguration configuration = this.isEmpty(node) ? new EmptyObjectInitializerBracesConfiguration(FormatterNodeBuilder.this.document) : (node.isMultiline() || FormatterNodeBuilder.this.document.getBoolean("formatter.statement.new.line") && FormatterNodeBuilder.this.isMultiLineObjectInitializer(node) ? new MultiLineObjectInitializerBracesConfiguration(FormatterNodeBuilder.this.document, (JSNode)node) : new SingleLineObjectInitializerBracesConfiguration(FormatterNodeBuilder.this.document));
                FormatterObjectInitializerNode formatterNode = new FormatterObjectInitializerNode(FormatterNodeBuilder.this.document, configuration);
                formatterNode.setBegin(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, node.getLC()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.skipSpacesOnly((IFormatterContainerNode)formatterNode, node.getRC());
                this.visitCombinedNodeList((List<? extends ASTNode>)node.getInitializers(), node.getCommas(), new PropertyInitializerPunctuationConfiguration());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd() - 1);
                formatterNode.setEnd(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, node.getRC()));
                return formatterNode;
            }

            public IFormatterNode visitParenthesizedExpression(ParenthesizedExpression node) {
                return this.processParens(node.getLP(), node.getRP(), (ASTNode)node.getExpression(), (IParensConfiguration)new ExpressionParensConfiguration(FormatterNodeBuilder.this.document));
            }

            public IFormatterNode visitPropertyExpression(PropertyExpression node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getObject());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getDotPosition());
                this.processPunctuation(node.getDotPosition(), 1, new PropertyExpressionPunctuationConfiguration());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getProperty().sourceStart());
                this.visit((ASTNode)node.getProperty());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            private IFormatterNode formatPropertyInitializer(PropertyInitializer node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getName());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getColon());
                this.processPunctuation(node.getColon(), 1, new PropertyInitializerPunctuationConfiguration());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getValue().sourceStart());
                this.visit((ASTNode)node.getValue());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.getValue().sourceStart());
                return formatterNode;
            }

            public IFormatterNode visitRegExpLiteral(RegExpLiteral node) {
                return FormatterNodeBuilder.this.addChild((IFormatterNode)new FormatterStringNode(FormatterNodeBuilder.this.document, (ASTNode)node));
            }

            public IFormatterNode visitReturnStatement(ReturnStatement node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                IFormatterTextNode keyword = FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getReturnKeyword());
                formatterNode.addChild((IFormatterNode)(node.getValue() != null ? new SpaceAfterKeyword(keyword) : keyword));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                if (node.getValue() != null) {
                    this.visit((ASTNode)node.getValue());
                }
                return this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, (ISemicolonStatement)node);
            }

            public IFormatterNode visitEmptyStatement(EmptyStatement node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                return this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, (ISemicolonStatement)node);
            }

            public IFormatterNode visitScript(Script node) {
                FormatterScriptNode scriptNode = new FormatterScriptNode(FormatterNodeBuilder.this.document);
                FormatterNodeBuilder.this.push((IFormatterContainerNode)scriptNode);
                this.visitNodeList(node.getStatements());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)scriptNode, node.sourceEnd());
                return scriptNode;
            }

            private IFormatterNode formatSetMethod(SetMethod node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getSetKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getName());
                this.processParens(node.getLP(), node.getRP(), (ASTNode)node.getArgument(), (IParensConfiguration)new FunctionArgumentsParensConfiguration(FormatterNodeBuilder.this.document));
                boolean emptyBody = node.getBody() == null || this.isEmptyBody(node.getBody());
                this.processBraces((ASTNode)node.getBody(), new FunctionBodyBracesConfiguration(FormatterNodeBuilder.this.document, emptyBody));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitStatementBlock(StatementBlock node) {
                return this.processBraces((ASTNode)node, new StatementBlockBracesConfiguration(FormatterNodeBuilder.this.document));
            }

            public IFormatterNode visitStringLiteral(StringLiteral node) {
                return FormatterNodeBuilder.this.addChild((IFormatterNode)new FormatterStringNode(FormatterNodeBuilder.this.document, (ASTNode)node));
            }

            public IFormatterNode visitSwitchStatement(SwitchStatement node) {
                FormatterSwitchNode switchNode = new FormatterSwitchNode(FormatterNodeBuilder.this.document);
                switchNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getSwitchKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)switchNode);
                this.processParens(node.getLP(), node.getRP(), (ASTNode)node.getCondition(), (IParensConfiguration)new SwitchConditionParensConfiguration(FormatterNodeBuilder.this.document));
                BracesNode braces = new BracesNode(FormatterNodeBuilder.this.document, new SwitchBracesConfiguration(FormatterNodeBuilder.this.document));
                braces.setBegin(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, node.getLC()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)braces);
                for (SwitchComponent component : node.getCaseClauses()) {
                    FormatterNodeBuilder.this.nodes.push(component);
                    if (component instanceof CaseClause) {
                        CaseClause caseClause = (CaseClause)component;
                        FormatterCaseNode caseNode = new FormatterCaseNode(FormatterNodeBuilder.this.document);
                        caseNode.setBegin((IFormatterTextNode)new SpaceAfterKeyword(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)caseClause.getKeyword())));
                        FormatterNodeBuilder.this.push((IFormatterContainerNode)caseNode);
                        this.visit((ASTNode)caseClause.getCondition());
                        caseNode.addChild((IFormatterNode)new ColonNodeWrapper(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, caseClause.getColonPosition())));
                        this.processSwitchComponent(caseNode, (SwitchComponent)caseClause);
                    } else {
                        DefaultClause defaultClause = (DefaultClause)component;
                        FormatterCaseNode defaultNode = new FormatterCaseNode(FormatterNodeBuilder.this.document);
                        defaultNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)defaultClause.getKeyword()));
                        FormatterNodeBuilder.this.push((IFormatterContainerNode)defaultNode);
                        defaultNode.addChild((IFormatterNode)new ColonNodeWrapper(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, defaultClause.getColonPosition())));
                        this.processSwitchComponent(defaultNode, (SwitchComponent)defaultClause);
                    }
                    FormatterNodeBuilder.this.nodes.pop();
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)braces, node.getRC());
                braces.setEnd(FormatterNodeBuilder.this.createCharNode(FormatterNodeBuilder.this.document, node.getRC()));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)switchNode, node.sourceEnd());
                return switchNode;
            }

            public IFormatterNode visitThisExpression(ThisExpression node) {
                return FormatterNodeBuilder.this.addChild((IFormatterNode)new FormatterStringNode(FormatterNodeBuilder.this.document, (ASTNode)node));
            }

            public IFormatterNode visitThrowStatement(ThrowStatement node) {
                FormatterThrowNode formatterNode = new FormatterThrowNode(FormatterNodeBuilder.this.document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getThrowKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                if (node.getException() != null) {
                    this.visit((ASTNode)node.getException());
                }
                return this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, (ISemicolonStatement)node);
            }

            public IFormatterNode visitTryStatement(TryStatement node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getTryKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processBraces((ASTNode)node.getBody(), new TryBodyConfiguration(FormatterNodeBuilder.this.document));
                for (CatchClause catchClause : node.getCatches()) {
                    this.processCatch(catchClause);
                }
                if (node.getFinally() != null) {
                    this.processFinally(node.getFinally());
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            private void processCatch(CatchClause catchClause) {
                FormatterCatchClauseNode formatterNode = new FormatterCatchClauseNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)catchClause.getCatchKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                ArrayList<ASTNode> exceptionNodes = new ArrayList<ASTNode>();
                exceptionNodes.add((ASTNode)catchClause.getException());
                if (catchClause.getIfKeyword() != null) {
                    exceptionNodes.add((ASTNode)catchClause.getIfKeyword());
                }
                if (catchClause.getFilterExpression() != null) {
                    exceptionNodes.add((ASTNode)catchClause.getFilterExpression());
                }
                this.processParens(catchClause.getLP(), catchClause.getRP(), exceptionNodes, (IParensConfiguration)new CatchParensConfiguration(FormatterNodeBuilder.this.document));
                this.processBraces((ASTNode)catchClause.getStatement(), new CatchBracesConfiguration(FormatterNodeBuilder.this.document));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, catchClause.sourceEnd());
            }

            private void processFinally(FinallyClause node) {
                FormatterFinallyClauseNode formatterNode = new FormatterFinallyClauseNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getFinallyKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processBraces((ASTNode)node.getStatement(), new FinallyBracesConfiguration(FormatterNodeBuilder.this.document));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
            }

            public IFormatterNode visitTypeOfExpression(TypeOfExpression node) {
                FormatterTypeofNode formatterNode = new FormatterTypeofNode(FormatterNodeBuilder.this.document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getTypeOfKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getExpression());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitUnaryOperation(UnaryOperation node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                if (!node.isPostfix()) {
                    FormatterNodeBuilder.this.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, node.getOperationPosition(), node.getOperationPosition() + node.getOperationText().length()));
                    this.skipSpaces((IFormatterContainerNode)formatterNode, node.getExpression().sourceStart());
                }
                this.visit((ASTNode)node.getExpression());
                if (node.isPostfix()) {
                    this.skipSpaces((IFormatterContainerNode)formatterNode, node.getOperationPosition());
                    FormatterNodeBuilder.this.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, node.getOperationPosition(), node.getOperationPosition() + node.getOperationText().length()));
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitVariableStatement(VariableStatement node) {
                FormatterVariableDeclarationNode formatterNode = new FormatterVariableDeclarationNode(FormatterNodeBuilder.this.document, this.isIndentVariableStatement((IVariableStatement)node));
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getVarKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processVariableDeclarations((IVariableStatement)node);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            private boolean isIndentVariableStatement(IVariableStatement node) {
                Expression expression;
                return node.getVariables().size() != 1 || !((expression = ((VariableDeclaration)node.getVariables().get(0)).getInitializer()) instanceof FunctionStatement) && !(expression instanceof ObjectInitializer) && (!(expression instanceof NewExpression) || !(((NewExpression)expression).getObjectClass() instanceof FunctionStatement)) && !(expression instanceof CallExpression);
            }

            private void processVariableDeclarations(IVariableStatement node) {
                List vars = node.getVariables();
                if (vars.isEmpty()) {
                    return;
                }
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, ((VariableDeclaration)vars.get(0)).sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                for (VariableDeclaration var : vars) {
                    int position;
                    this.visit((ASTNode)var.getIdentifier());
                    if (var.getInitializer() != null) {
                        position = var.getAssignPosition();
                        this.skipSpaces((IFormatterContainerNode)formatterNode, position);
                        this.processPunctuation(position, 1, new BinaryOperationPinctuationConfiguration());
                        this.visit((ASTNode)var.getInitializer());
                    }
                    if (var.getCommaPosition() == -1) continue;
                    position = var.getCommaPosition();
                    this.skipSpacesOnly((IFormatterContainerNode)formatterNode, position);
                    this.processPunctuation(position, 1, new CommaPunctuationConfiguration());
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, ((VariableDeclaration)vars.get(vars.size() - 1)).sourceEnd());
            }

            public IFormatterNode visitVoidExpression(VoidExpression node) {
                FormatterVoidExpressionNode formatterNode = new FormatterVoidExpressionNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getExpression());
                return this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, (ISemicolonStatement)node);
            }

            public IFormatterNode visitWhileStatement(WhileStatement node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getWhileKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processParens(node.getLP(), node.getRP(), (ASTNode)node.getCondition(), (IParensConfiguration)new WhileConditionParensConfiguration(FormatterNodeBuilder.this.document));
                if (node.getBody() != null) {
                    this.processBraces((ASTNode)node.getBody(), new WhileBlockBracesConfiguration(FormatterNodeBuilder.this.document));
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitWithStatement(WithStatement node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getWithKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processParens(node.getLP(), node.getRP(), (ASTNode)node.getExpression(), (IParensConfiguration)new WithConditionParensConfiguration(FormatterNodeBuilder.this.document));
                this.processBraces((ASTNode)node.getStatement(), new WithBlockBracesConfiguration(FormatterNodeBuilder.this.document));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            private void visitNodeList(List<? extends ASTNode> nodes) {
                int i = 0;
                while (i < nodes.size()) {
                    this.visit(nodes.get(i));
                    ++i;
                }
            }

            public IFormatterNode visitVoidOperator(VoidOperator node) {
                FormatterVoidOperatorNode formatterNode = new FormatterVoidOperatorNode(FormatterNodeBuilder.this.document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getVoidKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getExpression());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitYieldOperator(YieldOperator node) {
                FormatterYieldOperatorNode formatterNode = new FormatterYieldOperatorNode(FormatterNodeBuilder.this.document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getYieldKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getExpression());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitXmlLiteral(XmlLiteral node) {
                return FormatterNodeBuilder.this.addChild((IFormatterNode)new FormatterStringNode(FormatterNodeBuilder.this.document, (ASTNode)node));
            }

            public IFormatterNode visitDefaultXmlNamespace(DefaultXmlNamespaceStatement node) {
                FormatterBlockNode formatter = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatter.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getDefaultKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatter);
                FormatterNodeBuilder.this.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getXmlKeyword()));
                FormatterNodeBuilder.this.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(FormatterNodeBuilder.this.document, (ASTNode)node.getNamespaceKeyword()));
                this.visit((ASTNode)node.getValue());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatter, node.sourceEnd());
                return formatter;
            }

            public IFormatterNode visitXmlPropertyIdentifier(XmlAttributeIdentifier node) {
                return FormatterNodeBuilder.this.addChild((IFormatterNode)new FormatterStringNode(FormatterNodeBuilder.this.document, (ASTNode)node));
            }

            public IFormatterNode visitAsteriskExpression(AsteriskExpression node) {
                return FormatterNodeBuilder.this.addChild((IFormatterNode)new FormatterStringNode(FormatterNodeBuilder.this.document, (ASTNode)node));
            }

            public IFormatterNode visitGetLocalNameExpression(GetLocalNameExpression node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getNamespace());
                this.visit((ASTNode)node.getLocalName());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }

            public IFormatterNode visitGetAllChildrenExpression(GetAllChildrenExpression node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(FormatterNodeBuilder.this.document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(FormatterNodeBuilder.this.document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit((ASTNode)node.getObject());
                this.visit((ASTNode)node.getProperty());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return formatterNode;
            }
        });
        this.checkedPop((IFormatterContainerNode)root, this.document.getLength());
        return root;
    }

    private IFormatterTextNode createTextNode(IFormatterDocument document, ASTNode node) {
        return this.createTextNode(document, node.sourceStart(), node.sourceEnd());
    }

    private IFormatterTextNode createCharNode(IFormatterDocument document, int startPos) {
        return this.createTextNode(document, startPos, startPos + 1);
    }

    private IFormatterTextNode createEmptyTextNode(IFormatterDocument document, int pos) {
        return new FormatterEmptyNode(document, pos);
    }

    private IFormatterTextNode createSemicolonNode(IFormatterDocument document, int offset) {
        return new SemicolonNode(document, offset);
    }
}

