/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.javascript.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Script
extends ASTNode
implements ISourceable,
IModuleDeclaration {
    private final List<Comment> comments = new ArrayList<Comment>();
    private final List<Statement> statements = new ArrayList<Statement>();

    @Override
    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() == 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        for (Statement statement : this.statements) {
            buffer.append(statement.toSourceString(indentationString));
        }
        return buffer.toString();
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void addComment(Comment comment) {
        this.comments.add(comment);
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    public <E> void visitAll(ASTVisitor<E> visitor) {
        for (Statement statement : this.statements) {
            visitor.visit(statement);
        }
    }

    public String toString() {
        return this.toSourceString("");
    }

    public void traverse(org.eclipse.dltk.ast.ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            for (Statement statement : this.statements) {
                statement.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }
}

