/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.logconsole;

import org.eclipse.dltk.logconsole.ILogConsole;
import org.eclipse.dltk.logconsole.LogConsolePlugin;

public class LogConsoleType {
    private final String consoleType;

    public LogConsoleType(String consoleType) {
        this.consoleType = consoleType;
    }

    public String getType() {
        return this.consoleType;
    }

    public int hashCode() {
        return this.consoleType.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LogConsoleType) {
            LogConsoleType other = (LogConsoleType)obj;
            return this.consoleType.equals(other.consoleType);
        }
        return false;
    }

    public String computeTitle(Object identifier) {
        String type = this.getConsoleTypeName();
        if (identifier != null) {
            return String.valueOf(type) + " - " + identifier.toString();
        }
        return type;
    }

    protected String getConsoleTypeName() {
        String type = this.consoleType;
        int index = type.lastIndexOf(46);
        if (index > 0) {
            type = type.substring(index + 1);
        }
        return type;
    }

    public ILogConsole getConsole(Object identifier) {
        return LogConsolePlugin.getConsoleManager().getConsole(this, identifier);
    }
}

