/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.utils.IntList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallExpression
extends Expression {
    private Expression expression;
    private final List<ASTNode> arguments = new ArrayList<ASTNode>();
    private IntList commas;
    private int LP = -1;
    private int RP = -1;

    public CallExpression(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.expression != null) {
                this.expression.traverse(visitor);
            }
            if (this.arguments != null) {
                for (ASTNode node : this.arguments) {
                    node.traverse(visitor);
                }
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public List<ASTNode> getArguments() {
        return this.arguments;
    }

    public void addArgument(ASTNode argument) {
        this.arguments.add(argument);
    }

    public int getLP() {
        return this.LP;
    }

    public void setLP(int LP) {
        this.LP = LP;
    }

    public int getRP() {
        return this.RP;
    }

    public void setRP(int RP) {
        this.RP = RP;
    }

    public IntList getCommas() {
        return this.commas;
    }

    public void setCommas(IntList commas) {
        this.commas = commas;
    }

    @Override
    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.arguments.size() == 0 || this.commas.size() == this.arguments.size() - 1 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.expression.toSourceString(indentationString));
        buffer.append('(');
        int i = 0;
        while (i < this.arguments.size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            ISourceable item = (ISourceable)this.arguments.get(i);
            buffer.append(item.toSourceString(indentationString));
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }
}

