/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.documentation;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.ui.documentation.IDocumentationResponse;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationTitleAdapter;
import org.eclipse.dltk.ui.documentation.TextDocumentationResponse;
import org.eclipse.dltk.utils.AdaptUtils;

public class DocumentationUtils {
    public static Reader getReader(IDocumentationResponse response) {
        block3: {
            if (response != null) {
                try {
                    return response.getReader();
                }
                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String readAll(Reader rd) {
        StringBuilder buffer = new StringBuilder();
        char[] readBuffer = new char[2048];
        try {
            int n = rd.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer, 0, n);
                n = rd.read(readBuffer);
            }
            return buffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static IDocumentationResponse wrap(Object member, Object context, Reader reader) {
        if (reader != null) {
            IScriptDocumentationTitleAdapter titleAdapter = (IScriptDocumentationTitleAdapter)AdaptUtils.getAdapter((Object)context, IScriptDocumentationTitleAdapter.class);
            return new TextDocumentationResponse(member, titleAdapter != null ? titleAdapter.getTitle(member) : null, titleAdapter != null ? titleAdapter.getImage(member) : null, DocumentationUtils.readAll(reader));
        }
        return null;
    }
}

