/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.dltk.ui.text.HTMLUtils;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class HTMLPrinter {
    private static final String[] PROLOG_MARKS = new String[]{"<!DOCTYPE>", "<HTML>"};
    private static final String EPILOG_MARK = "</HTML>";

    private HTMLPrinter() {
    }

    public static String convertToHTMLContent(String content) {
        return TextUtils.escapeHTML((String)content);
    }

    public static String read(Reader rd) {
        StringBuffer buffer = new StringBuffer();
        if (HTMLPrinter.read(rd, buffer)) {
            return buffer.toString();
        }
        return null;
    }

    public static boolean read(Reader rd, StringBuffer buffer) {
        char[] readBuffer = new char[2048];
        try {
            int n;
            while ((n = rd.read(readBuffer)) > 0) {
                buffer.append(readBuffer, 0, n);
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static void insertPageProlog(StringBuffer buffer, int position, RGB bgRGB, RGB fgRGB, String styleSheet) {
        if (bgRGB == null) {
            HTMLPrinter.insertPageProlog(buffer, position, styleSheet);
        } else {
            StringBuffer pageProlog = new StringBuffer(300);
            pageProlog.append("<html>");
            HTMLPrinter.appendStyleSheet(pageProlog, styleSheet);
            pageProlog.append("<body text=\"");
            HTMLPrinter.appendColor(pageProlog, fgRGB);
            pageProlog.append("\" bgcolor=\"");
            HTMLPrinter.appendColor(pageProlog, bgRGB);
            pageProlog.append("\">");
            buffer.insert(position, pageProlog.toString());
        }
    }

    public static void insertStyles(StringBuffer buffer, String[] styles) {
        if (styles == null || styles.length == 0) {
            return;
        }
        StringBuffer styleBuf = new StringBuffer(10 * styles.length);
        int i = 0;
        while (i < styles.length) {
            styleBuf.append(" style=\"");
            styleBuf.append(styles[i]);
            styleBuf.append('\"');
            ++i;
        }
        int index = buffer.indexOf("<body ");
        if (index == -1) {
            return;
        }
        buffer.insert(index + 5, styleBuf);
    }

    public static void insertPageProlog(StringBuffer buffer, int position, RGB bgRGB) {
        if (bgRGB == null) {
            HTMLPrinter.insertPageProlog(buffer, position);
        } else {
            StringBuffer pageProlog = new StringBuffer(60);
            pageProlog.append("<html><body text=\"#000000\" bgcolor=\"");
            HTMLPrinter.appendColor(pageProlog, bgRGB);
            pageProlog.append("\">");
            buffer.insert(position, pageProlog.toString());
        }
    }

    private static void appendStyleSheet(StringBuffer buffer, String styleSheet) {
        if (styleSheet == null) {
            return;
        }
        buffer.append("<head><style CHARSET=\"ISO-8859-1\" TYPE=\"text/css\">");
        buffer.append(styleSheet);
        buffer.append("</style></head>");
    }

    private static void appendColor(StringBuffer buffer, RGB rgb) {
        buffer.append('#');
        buffer.append(Integer.toHexString(rgb.red));
        buffer.append(Integer.toHexString(rgb.green));
        buffer.append(Integer.toHexString(rgb.blue));
    }

    public static void insertPageProlog(StringBuffer buffer, int position) {
        HTMLPrinter.insertPageProlog(buffer, position, HTMLUtils.getBgColor());
    }

    public static void insertPageProlog(StringBuffer buffer, int position, String styleSheet) {
        HTMLPrinter.insertPageProlog(buffer, position, HTMLUtils.getBgColor(), HTMLUtils.getFgColor(), styleSheet);
    }

    public static void addPageProlog(StringBuffer buffer) {
        HTMLPrinter.insertPageProlog(buffer, buffer.length());
    }

    public static void addPageEpilog(StringBuffer buffer) {
        buffer.append("</font></body></html>");
    }

    public static void startBulletList(StringBuffer buffer) {
        buffer.append("<ul>");
    }

    public static void endBulletList(StringBuffer buffer) {
        buffer.append("</ul>");
    }

    public static void addBullet(StringBuffer buffer, String bullet) {
        if (bullet != null) {
            buffer.append("<li>");
            buffer.append(bullet);
            buffer.append("</li>");
        }
    }

    public static void addSmallHeader(StringBuffer buffer, String header) {
        if (header != null) {
            buffer.append("<h5>");
            buffer.append(header);
            buffer.append("</h5>");
        }
    }

    public static void addParagraph(StringBuffer buffer, String paragraph) {
        if (paragraph != null) {
            buffer.append("<p>");
            buffer.append(paragraph);
        }
    }

    public static void addParagraph(StringBuffer buffer, Reader paragraphReader) {
        if (paragraphReader != null) {
            int startPos = buffer.length();
            if (HTMLPrinter.read(paragraphReader, buffer) && (startPos != 0 || !HTMLPrinter.hasProlog(buffer, startPos))) {
                buffer.insert(startPos, "<p>");
            }
        }
    }

    private static boolean hasProlog(StringBuffer buffer, int pos) {
        while (pos < buffer.length() && Character.isWhitespace(buffer.charAt(pos))) {
            ++pos;
        }
        int i = 0;
        while (i < PROLOG_MARKS.length) {
            if (HTMLPrinter.startsWithIgnoreCase(buffer, pos, PROLOG_MARKS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasEpilog(StringBuffer buffer) {
        int pos = buffer.length();
        while (pos > 0 && Character.isWhitespace(buffer.charAt(pos - 1))) {
            --pos;
        }
        return pos >= EPILOG_MARK.length() && HTMLPrinter.startsWithIgnoreCase(buffer, pos - EPILOG_MARK.length(), EPILOG_MARK);
    }

    private static boolean startsWithIgnoreCase(StringBuffer buffer, int pos, String prefix) {
        int prefixLen = prefix.length();
        if (pos + prefixLen <= buffer.length()) {
            int i = 0;
            while (i < prefixLen) {
                if (Character.toUpperCase(buffer.charAt(pos + i)) != prefix.charAt(i)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static String convertTopLevelFont(String styles, FontData fontData) {
        return org.eclipse.jface.internal.text.html.HTMLPrinter.convertTopLevelFont((String)styles, (FontData)fontData);
    }
}

