/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.environment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.LazyEnvironment;
import org.eclipse.dltk.utils.PlatformFileUtils;

public class LazyFileHandle
implements IFileHandle {
    private final String environment;
    private final IPath path;
    private IFileHandle handle = null;

    public LazyFileHandle(String environment, IPath path) {
        this.environment = "".equals(environment) ? "org.eclipse.dltk.core.environment.localEnvironment" : environment;
        this.path = path;
    }

    private void initialize() {
        IEnvironment environment;
        if (this.handle == null && (environment = this.resolveEnvironment()) != null) {
            this.handle = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile(environment, this.path);
        }
    }

    private IEnvironment resolveEnvironment() {
        IEnvironment environment = EnvironmentManager.getEnvironmentById(this.environment);
        if (environment instanceof LazyEnvironment) {
            return null;
        }
        return environment;
    }

    public boolean exists() {
        if (this.handle != null) {
            return this.handle.exists();
        }
        IEnvironment environment = this.resolveEnvironment();
        if (environment == null || !environment.connect()) {
            return true;
        }
        this.initialize();
        if (this.handle != null) {
            return this.handle.exists();
        }
        return true;
    }

    public String getCanonicalPath() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.getCanonicalPath();
        }
        return null;
    }

    public IFileHandle getChild(String bundlePath) {
        this.initialize();
        if (this.handle != null) {
            return this.handle.getChild(bundlePath);
        }
        return null;
    }

    public IFileHandle[] getChildren() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.getChildren();
        }
        return null;
    }

    public IEnvironment getEnvironment() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.getEnvironment();
        }
        return EnvironmentManager.getEnvironmentById(this.environment);
    }

    public IPath getFullPath() {
        return EnvironmentPathUtils.getFullPath(this.environment, this.path);
    }

    public String getName() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.getName();
        }
        return this.path.lastSegment();
    }

    public IFileHandle getParent() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.getParent();
        }
        if (this.path.segmentCount() > 0) {
            return new LazyFileHandle(this.environment, this.path.removeLastSegments(1));
        }
        return null;
    }

    public IPath getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.isDirectory();
        }
        return false;
    }

    public boolean isFile() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.isFile();
        }
        return false;
    }

    public boolean isSymlink() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.isSymlink();
        }
        return false;
    }

    public long lastModified() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.lastModified();
        }
        return 0L;
    }

    public long length() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.length();
        }
        return 0L;
    }

    public InputStream openInputStream(IProgressMonitor monitor) throws IOException {
        this.initialize();
        if (this.handle != null) {
            return this.handle.openInputStream(monitor);
        }
        return null;
    }

    public OutputStream openOutputStream(IProgressMonitor monitor) throws IOException {
        this.initialize();
        if (this.handle != null) {
            return this.handle.openOutputStream(monitor);
        }
        throw new IOException("Error opening " + this.getFullPath());
    }

    public String toOSString() {
        IEnvironment environment = this.resolveEnvironment();
        if (environment != null) {
            IPath newPath = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile(environment, this.path).getPath();
            return environment.convertPathToString(newPath);
        }
        this.initialize();
        if (this.handle != null) {
            return this.handle.toOSString();
        }
        return "";
    }

    public URI toURI() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.toURI();
        }
        return null;
    }

    public String getEnvironmentId() {
        return this.environment;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.environment == null ? 0 : this.environment.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        IEnvironment otherEnvironment;
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof IFileHandle)) {
            return false;
        }
        IFileHandle other = (IFileHandle)obj;
        if (this.environment == null ? other.getEnvironment() != null : (otherEnvironment = other.getEnvironment()) == null || !this.environment.equals(otherEnvironment.getId())) {
            return false;
        }
        return !(this.path == null ? other.getPath() != null : !this.path.equals((Object)other.getPath()));
    }

    public String toString() {
        this.initialize();
        if (this.handle != null) {
            return this.handle.toString();
        }
        return "[UNRESOLVED]" + this.getFullPath();
    }

    public void move(IFileHandle destination) throws CoreException {
        this.initialize();
        if (this.handle == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.core", "Error resolving " + this.getFullPath()));
        }
        this.handle.move(destination);
    }
}

