/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.evaluation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModule;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.evaluation.types.ClassInstanceType;
import org.eclipse.dltk.evaluation.types.FunctionType;
import org.eclipse.dltk.evaluation.types.IClassType;
import org.eclipse.dltk.evaluation.types.ModelClassType;
import org.eclipse.dltk.evaluation.types.ModelFunctionType;
import org.eclipse.dltk.evaluation.types.ModelModuleType;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.evaluation.types.OldClassType;
import org.eclipse.dltk.evaluation.types.SimpleType;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.python.internal.core.evaluation.PythonASTFindVisitor;
import org.eclipse.dltk.python.internal.core.evaluation.PythonBinaryExpressionOperations;
import org.eclipse.dltk.python.internal.core.evaluation.PythonBuiltIns;
import org.eclipse.dltk.python.internal.core.evaluation.PythonTypeEvaluator;
import org.eclipse.dltk.python.internal.core.evaluation.PythonTypeEvaluatorUtils;
import org.eclipse.dltk.python.internal.core.evaluation.types.ImportedCallType;
import org.eclipse.dltk.python.internal.core.evaluation.types.ImportedType;
import org.eclipse.dltk.python.parser.ast.PythonImportFromStatement;
import org.eclipse.dltk.python.parser.ast.PythonImportStatement;
import org.eclipse.dltk.python.parser.ast.expressions.Assignment;
import org.eclipse.dltk.python.parser.ast.expressions.BinaryExpression;
import org.eclipse.dltk.python.parser.ast.expressions.CallHolder;
import org.eclipse.dltk.python.parser.ast.expressions.ExtendedVariableReference;
import org.eclipse.dltk.python.parser.ast.expressions.PythonDictExpression;
import org.eclipse.dltk.python.parser.ast.expressions.PythonImportAsExpression;
import org.eclipse.dltk.python.parser.ast.expressions.PythonImportExpression;
import org.eclipse.dltk.python.parser.ast.expressions.PythonListExpression;
import org.eclipse.dltk.python.parser.ast.expressions.PythonTestListExpression;
import org.eclipse.dltk.python.parser.ast.expressions.PythonTupleExpression;
import org.eclipse.dltk.python.parser.ast.statements.ReturnStatement;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.dltk.ti.types.RecursionTypeCall;

public class PythonASTTypeEvaluator {
    private static final String SELF_CONSTANT = "self";
    private ModuleDeclaration fModule = null;
    private Map fParents = null;
    private IModule fModelModule = null;
    private List fEvaluationList = new ArrayList();
    private Map fLocalIndex = null;
    public static long totalSimpleReferenceDetections = 0L;
    public static long unknownSimpleReferenceBecauseOfArgument = 0L;
    public static long unknownSimpleReferenceNotInAST = 0L;
    public static long unknownSimpleReferenceNotFoundAtEnd = 0L;
    public static long unknownReturnBecauseOfArgument = 0L;
    public static long unknownSimpleReferenceEmptyParent = 0L;
    public static long unknownSimpleReferenceNotFoundAtEndBuiltin = 0L;
    public static long unknownBinaryExpressionCount = 0L;
    public static long unknownBinaryExpressionUnDetected = 0L;
    public static long unknownBinaryExpressionNotSimpleTypes = 0L;
    public static long unknownExtendedCount = 0L;
    public static long unknownExtendedUnDetectedIndex = 0L;

    public PythonASTTypeEvaluator(IModule modelModule, ModuleDeclaration module, Map parents) {
        this.fModule = module;
        this.fParents = parents;
        this.fModelModule = modelModule;
        this.fLocalIndex = this.makeLocalIndex(this.fModelModule);
    }

    public IEvaluatedType evaluateASTBinaryExpression(ASTNode node) {
        BinaryExpression expression = (BinaryExpression)node;
        IEvaluatedType leftType = this.evaluateASTNode((ASTNode)expression.getLeft(), null);
        IEvaluatedType rightType = this.evaluateASTNode((ASTNode)expression.getRight(), null);
        ++unknownBinaryExpressionCount;
        if (leftType instanceof UnknownType || rightType instanceof UnknownType) {
            return UnknownType.INSTANCE;
        }
        if (!(leftType instanceof SimpleType) || !(rightType instanceof SimpleType)) {
            ++unknownBinaryExpressionNotSimpleTypes;
            return UnknownType.INSTANCE;
        }
        int left = ((SimpleType)leftType).getType();
        int right = ((SimpleType)rightType).getType();
        int kind = expression.getKind();
        IEvaluatedType type = PythonBinaryExpressionOperations.makeType(left, kind, right);
        if (type instanceof UnknownType) {
            ++unknownBinaryExpressionUnDetected;
        }
        return type;
    }

    public IEvaluatedType evaluateASTNode(ASTNode node, ASTNode scope) {
        if (this.fEvaluationList.contains(node)) {
            return RecursionTypeCall.INSTANCE;
        }
        this.fEvaluationList.add(node);
        if (node == null) {
            return UnknownType.INSTANCE;
        }
        if (node instanceof Assignment) {
            Assignment assign = (Assignment)node;
            return this.evaluateASTNode((ASTNode)assign.getRight(), scope);
        }
        if (node instanceof MethodDeclaration) {
            return new FunctionType(this.fModule, (MethodDeclaration)node);
        }
        if (node instanceof BinaryExpression) {
            return this.evaluateASTBinaryExpression(node);
        }
        if (node instanceof NumericLiteral) {
            return new SimpleType(1);
        }
        if (node instanceof StringLiteral) {
            return new SimpleType(0);
        }
        if (node instanceof PythonTupleExpression) {
            return new SimpleType(7);
        }
        if (node instanceof PythonListExpression) {
            return new SimpleType(3);
        }
        if (node instanceof PythonDictExpression) {
            return new SimpleType(4);
        }
        if (node instanceof SimpleReference) {
            return this.evaluateSimpleReferenceType((SimpleReference)node, scope);
        }
        if (node instanceof ExtendedVariableReference) {
            return this.evaluateExtendedReferenceType((ExtendedVariableReference)node, node);
        }
        if (node instanceof TypeDeclaration) {
            return new OldClassType(this.fModule, (TypeDeclaration)node);
        }
        return UnknownType.INSTANCE;
    }

    public IEvaluatedType evaluateCallASTNode(ASTNode node, CallHolder callHolder, boolean isMethod, ASTNode scope) {
        if (node == null) {
            return UnknownType.INSTANCE;
        }
        if (node instanceof SimpleReference) {
            IEvaluatedType type = this.evaluateSimpleReferenceType((SimpleReference)node, scope);
            if (type instanceof FunctionType) {
                ASTNode parent = (ASTNode)this.fParents.get(((FunctionType)type).getFunction());
                if (isMethod && parent instanceof TypeDeclaration) {
                    return type;
                }
                if (!isMethod && !(parent instanceof TypeDeclaration)) {
                    return type;
                }
                return UnknownType.INSTANCE;
            }
            if (type instanceof OldClassType) {
                return type;
            }
        } else if (node instanceof ExtendedVariableReference) {
            return this.evaluateExtendedReferenceType((ExtendedVariableReference)node, scope);
        }
        return UnknownType.INSTANCE;
    }

    private IEvaluatedType evaluateExtendedReferenceType(ExtendedVariableReference reference, ASTNode scope) {
        ++unknownExtendedCount;
        List expressions = reference.getExpressions();
        IEvaluatedType type = null;
        Expression expr = null;
        int index = 0;
        while (index < expressions.size()) {
            expr = (Expression)expressions.get(index);
            if (reference.isCall(index)) {
                CallHolder callHolder = (CallHolder)((Object)expressions.get(index + 1));
                if (type == null) {
                    type = this.evaluateFunctionCall(expr, callHolder, scope);
                } else if (type instanceof IClassType && expr instanceof SimpleReference) {
                    type = this.evaluateMethodCall(type, (SimpleReference)expr, callHolder, scope);
                }
                if (type == null) {
                    return UnknownType.INSTANCE;
                }
                index += 2;
            } else if (reference.isDot(index) || reference.isLast(index)) {
                if (type == null) {
                    type = this.checkDottedImports(expressions, expr, scope);
                    if (type == null) {
                        type = this.evaluateIdentifier(expr, scope);
                    }
                    if (type instanceof ImportedType) {
                        type = ((ImportedType)type).getType();
                    }
                } else {
                    if (type instanceof ModelModuleType) {
                        type = this.evaluateModuleSubIdentifier(((ModelModuleType)type).getModule(), expr);
                    } else if (type instanceof ClassInstanceType) {
                        type = this.evaluateASTClassSubIdentifier(((ClassInstanceType)type).getTypeDeclaration(), expr, false);
                    } else if (type instanceof OldClassType) {
                        type = this.evaluateASTClassSubIdentifier(((OldClassType)type).getTypeDeclaration(), expr, true);
                    } else if (type instanceof ModelClassType) {
                        type = this.evaluateModelClassSubIdentifier((ModelClassType)type, expr);
                    }
                    if (type instanceof ImportedType) {
                        type = ((ImportedType)type).getType();
                    }
                }
                if (type == null) {
                    return UnknownType.INSTANCE;
                }
                if (type instanceof ModelModuleType) {
                    ModelModuleType modelModuleType = (ModelModuleType)type;
                    index += modelModuleType.getStepCount() - 1;
                }
            } else if (reference.isIndex(index)) {
                ++unknownExtendedUnDetectedIndex;
                return UnknownType.INSTANCE;
            }
            ++index;
        }
        return type;
    }

    private IEvaluatedType evaluateASTClassSubIdentifier(TypeDeclaration typeDeclaration, Expression expr, boolean bStaticsOnly) {
        if (expr instanceof SimpleReference) {
            SimpleReference reference = (SimpleReference)expr;
            SimpleReference ref = (SimpleReference)expr;
            PythonASTFindVisitor visitor = new PythonASTFindVisitor(ref.getName(), bStaticsOnly);
            try {
                typeDeclaration.traverse((ASTVisitor)visitor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
            List nodes = visitor.getNodes();
            IEvaluatedType type = this.checkListForReference(reference.getName(), nodes, (ASTNode)typeDeclaration);
            if (type != null) {
                return type;
            }
            IEvaluatedType imported = this.checkReferenceImports(reference.getName(), nodes);
            if (imported != null) {
                return imported;
            }
            IEvaluatedType btype = this.evaluateReferenceInBaseClasses(typeDeclaration, (SimpleReference)expr, bStaticsOnly);
            if (btype != null) {
                return btype;
            }
        }
        return null;
    }

    private IEvaluatedType evaluateReferenceInBaseClasses(TypeDeclaration typeDeclaration, SimpleReference expr, boolean staticOnly) {
        List baseClasses = typeDeclaration.getSuperClassNames();
        Iterator i = baseClasses.iterator();
        while (i.hasNext()) {
            OldClassType ctype;
            IEvaluatedType subIdentifier;
            String className = (String)i.next();
            IEvaluatedType type = this.evaluateName(className, (ASTNode)typeDeclaration);
            if (type instanceof ImportedType) {
                type = ((ImportedType)type).getType();
            }
            if (!(type instanceof OldClassType ? (subIdentifier = this.evaluateASTClassSubIdentifier((ctype = (OldClassType)type).getTypeDeclaration(), (Expression)expr, staticOnly)) != null : type instanceof ModelClassType && (subIdentifier = this.evaluateModelClassSubIdentifier((ModelClassType)(ctype = (ModelClassType)type), (Expression)expr)) != null)) continue;
            return subIdentifier;
        }
        return null;
    }

    private IEvaluatedType evaluateName(String name, ASTNode scope) {
        VariableReference ref = new VariableReference(-2, -3, name);
        this.fParents.put(ref, scope);
        IEvaluatedType type = this.evaluateSimpleReferenceType((SimpleReference)ref, null);
        this.fParents.remove(ref);
        return type;
    }

    private IEvaluatedType evaluateModelClassSubIdentifier(ModelClassType modelType, Expression expr) {
        if (expr instanceof SimpleReference) {
            SimpleReference ref = (SimpleReference)expr;
            IType classElement = modelType.getTypeDeclaration();
            if (classElement != null) {
                IModelElement[] elements = null;
                try {
                    elements = classElement.getChildren();
                }
                catch (ModelException ex) {
                    ex.printStackTrace();
                    return null;
                }
                int i = 0;
                while (i < elements.length) {
                    IModelElement element = elements[i];
                    if (element instanceof IField) {
                        if (((IField)element).getElementName().equals(ref.getName())) {
                            IEvaluatedType type = PythonTypeEvaluator.evaluate(element);
                            if (type != null) {
                                return type;
                            }
                        } else if (element instanceof IMethod && ((IMethod)element).getElementName().equals(ref.getName())) {
                            return new ModelFunctionType((IMethod)element);
                        }
                    }
                    ++i;
                }
                try {
                    String[] superClassNames = classElement.getSuperClasses();
                    int i2 = 0;
                    while (i2 < superClassNames.length) {
                        IEvaluatedType type;
                        String superClass = superClassNames[i2];
                        IModelElement baseElement = this.findBaseClassForElement(classElement, superClass);
                        if (baseElement instanceof IType ? (type = this.evaluateModelClassSubIdentifier(new ModelClassType((IType)baseElement), expr)) != null : baseElement instanceof IModule && (type = this.evaluateModuleSubIdentifier((IModule)baseElement, expr)) != null) {
                            return type;
                        }
                        ++i2;
                    }
                }
                catch (ModelException ex) {
                    ex.printStackTrace();
                    return UnknownType.INSTANCE;
                }
            }
        }
        return null;
    }

    private IModelElement findBaseClassForElement(IType classElement, String baseClassName) {
        return null;
    }

    private IEvaluatedType evaluateModuleSubIdentifier(IModule module, Expression expr) {
        if (expr instanceof SimpleReference) {
            IModelElement[] childrens = null;
            try {
                childrens = module.getChildren();
            }
            catch (ModelException ex) {
                ex.printStackTrace();
            }
            if (childrens != null) {
                int i = 0;
                while (i < childrens.length) {
                    IModelElement element = childrens[i];
                    if (element instanceof IField) {
                        if (((IField)element).getElementName().equals(((SimpleReference)expr).getName())) {
                            return PythonTypeEvaluator.evaluate(element);
                        }
                    } else if (element instanceof IMethod) {
                        if (((IMethod)element).getElementName().equals(((SimpleReference)expr).getName())) {
                            return new ModelFunctionType((IMethod)element);
                        }
                    } else if (element instanceof IType && ((IType)element).getElementName().equals(((SimpleReference)expr).getName())) {
                        return new ModelClassType((IType)element);
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private IEvaluatedType checkDottedImports(List expressions, Expression expr, ASTNode scope) {
        String pName = "";
        boolean firstI = true;
        int index = 1;
        ModelModuleType lastType = null;
        Iterator i = expressions.iterator();
        while (i.hasNext()) {
            Expression exp = (Expression)i.next();
            if (!(exp instanceof SimpleReference)) continue;
            if (firstI) {
                pName = String.valueOf(pName) + ((SimpleReference)exp).getName();
                firstI = false;
                continue;
            }
            pName = String.valueOf(pName) + "." + ((SimpleReference)exp).getName();
            ++index;
            IEvaluatedType type = this.evaluateName(pName, scope);
            if (type == null) continue;
            if (type instanceof ModelModuleType) {
                lastType = new ModelModuleType(((ModelModuleType)type).getModule(), index);
                continue;
            }
            if (!(type instanceof UnknownType)) continue;
        }
        return lastType;
    }

    private IEvaluatedType evaluateIdentifier(Expression expr, ASTNode scope) {
        IEvaluatedType ctype = this.evaluateASTNode((ASTNode)expr, scope);
        if (ctype instanceof ModelClassType) {
            return ctype;
        }
        if (ctype instanceof OldClassType) {
            return ctype;
        }
        if (ctype instanceof ClassInstanceType) {
            return ctype;
        }
        if (ctype instanceof FunctionType) {
            return ctype;
        }
        if (ctype instanceof ModelFunctionType) {
            return ctype;
        }
        if (ctype instanceof ModelModuleType) {
            return ctype;
        }
        return null;
    }

    private IEvaluatedType evaluateMethodCall(IEvaluatedType type, SimpleReference reference, CallHolder callHolder, ASTNode scope) {
        if (type instanceof OldClassType) {
            IEvaluatedType ftype;
            OldClassType classType = (OldClassType)type;
            IEvaluatedType rtype = this.evaluateASTClassSubIdentifier(classType.getTypeDeclaration(), (Expression)reference, true);
            if (rtype instanceof ImportedType) {
                rtype = ((ImportedType)rtype).getType();
            }
            if (rtype instanceof FunctionType && (ftype = this.evaluateMethodReturnValue(((FunctionType)rtype).getFunction(), callHolder, scope)) != null) {
                return ftype;
            }
            return UnknownType.INSTANCE;
        }
        if (type instanceof ClassInstanceType) {
            IEvaluatedType ftype;
            IEvaluatedType rtype = this.evaluateASTClassSubIdentifier(((ClassInstanceType)type).getTypeDeclaration(), (Expression)reference, false);
            if (rtype instanceof FunctionType && (ftype = this.evaluateMethodReturnValue(((FunctionType)rtype).getFunction(), callHolder, scope)) != null) {
                return ftype;
            }
            return UnknownType.INSTANCE;
        }
        if (type instanceof ModelClassType) {
            IType iType = ((ModelClassType)type).getTypeDeclaration();
        }
        return null;
    }

    private IEvaluatedType evaluateFunctionCall(Expression expr, CallHolder callHolder, ASTNode scope) {
        ImportedCallType icType;
        IModelElement modelElement;
        IEvaluatedType ctype = this.evaluateCallASTNode((ASTNode)expr, callHolder, false, scope);
        if (ctype instanceof OldClassType) {
            return new ClassInstanceType(this.fModule, ((OldClassType)ctype).getTypeDeclaration());
        }
        if (ctype instanceof FunctionType) {
            return this.evaluateFunctionReturnValue(((FunctionType)ctype).getFunction(), callHolder, scope);
        }
        if (ctype instanceof ImportedCallType && (modelElement = (icType = (ImportedCallType)ctype).getElement()) != null) {
            if (modelElement instanceof IType) {
                return new ModelClassType((IType)modelElement);
            }
            if (modelElement instanceof IMethod) {
                return PythonTypeEvaluator.evaluateCall(modelElement, null);
            }
        }
        return null;
    }

    private List getUpperNodes(ASTNode parent, ASTNode nodeParent) {
        ArrayList<ASTNode> nodes = PythonTypeEvaluatorUtils.getAllASTLevelChilds(parent);
        if (nodes.contains(nodeParent)) {
            ArrayList<ASTNode> nnodes = new ArrayList<ASTNode>();
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                ASTNode nnde = (ASTNode)i.next();
                if (nnde.equals(nodeParent)) break;
                nnodes.add(nnde);
            }
            nodes = nnodes;
        }
        Collections.reverse(nodes);
        return nodes;
    }

    private List findReturns(ASTNode node) {
        List nodes = PythonTypeEvaluatorUtils.getAllASTLevelChilds(node);
        ArrayList<ASTNode> returns = new ArrayList<ASTNode>();
        if (nodes == null) {
            return returns;
        }
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            ASTNode nde = (ASTNode)i.next();
            if (!(nde instanceof ReturnStatement)) continue;
            returns.add(nde);
        }
        return returns;
    }

    private IEvaluatedType makeMultiType(List types) {
        int size = types.size();
        if (size == 1) {
            return (IEvaluatedType)types.get(0);
        }
        if (size > 1) {
            MultiTypeType multi = new MultiTypeType();
            Iterator i = types.iterator();
            while (i.hasNext()) {
                IEvaluatedType type = (IEvaluatedType)i.next();
                multi.addType(type);
            }
            if (multi.size() == 1) {
                return multi.get(0);
            }
            return multi;
        }
        return new SimpleType(6);
    }

    private IEvaluatedType evaluateFunctionReturnValue(ASTNode node, ASTNode scope) {
        List returns = this.findReturns(node);
        if (returns == null) {
            return new SimpleType(6);
        }
        ArrayList<Object> types = new ArrayList<Object>();
        Iterator i = returns.iterator();
        while (i.hasNext()) {
            ReturnStatement returnS = (ReturnStatement)((Object)i.next());
            if (returnS.getExpression() != null) {
                IEvaluatedType type = this.evaluateASTNode((ASTNode)returnS.getExpression(), scope);
                if (type instanceof RecursionTypeCall) continue;
                types.add(type);
                continue;
            }
            types.add(new SimpleType(6));
        }
        return this.makeMultiType(types);
    }

    private IEvaluatedType evaluateFunctionReturnValue(ASTNode node, CallHolder arguments, ASTNode scope) {
        MethodDeclaration method = (MethodDeclaration)node;
        List originalArgumetns = method.getArguments();
        List argValues = PythonTypeEvaluatorUtils.parseCallHolder(arguments);
        ArrayList<ASTNode> oldInitialValues = new ArrayList<ASTNode>();
        int index = 0;
        if (originalArgumetns.size() == argValues.size()) {
            Iterator i = originalArgumetns.iterator();
            while (i.hasNext()) {
                Argument arg = (Argument)i.next();
                oldInitialValues.add(arg.getInitialization());
                arg.setInitializationExpression((ASTNode)((Expression)argValues.get(index)));
                ++index;
            }
        } else {
            return this.evaluateFunctionReturnValue(node, scope);
        }
        IEvaluatedType type = this.evaluateFunctionReturnValue(node, scope);
        index = 0;
        Iterator i = originalArgumetns.iterator();
        while (i.hasNext()) {
            Argument arg = (Argument)i.next();
            arg.setInitializationExpression((ASTNode)((Expression)oldInitialValues.get(index)));
            ++index;
        }
        return type;
    }

    private IEvaluatedType evaluateMethodReturnValue(ASTNode node, CallHolder arguments, ASTNode scope) {
        MethodDeclaration method = (MethodDeclaration)node;
        List originalArgumetns = method.getArguments();
        List argValues = PythonTypeEvaluatorUtils.parseCallHolder(arguments);
        ArrayList<ASTNode> oldInitialValues = new ArrayList<ASTNode>();
        int index = 0;
        if (originalArgumetns.size() - 1 == argValues.size()) {
            boolean skipFirst = true;
            Iterator i = originalArgumetns.iterator();
            while (i.hasNext()) {
                Argument arg = (Argument)i.next();
                if (skipFirst) {
                    skipFirst = false;
                    continue;
                }
                oldInitialValues.add(arg.getInitialization());
                arg.setInitializationExpression((ASTNode)((Expression)argValues.get(index)));
                ++index;
            }
        } else {
            return this.evaluateFunctionReturnValue(node, scope);
        }
        IEvaluatedType type = this.evaluateFunctionReturnValue(node, scope);
        index = 0;
        boolean skipFirst = true;
        Iterator i = originalArgumetns.iterator();
        while (i.hasNext()) {
            Argument arg = (Argument)i.next();
            if (skipFirst) {
                skipFirst = false;
                continue;
            }
            arg.setInitializationExpression((ASTNode)((Expression)oldInitialValues.get(index)));
            ++index;
        }
        return type;
    }

    private IEvaluatedType checkArguments(MethodDeclaration method, String reference) {
        List arguments = method.getArguments();
        boolean first = true;
        Iterator i = arguments.iterator();
        while (i.hasNext()) {
            Argument arg = (Argument)i.next();
            if (arg.getName().equals(reference)) {
                ASTNode parent;
                ASTNode parentParent;
                if (first && (parentParent = PythonTypeEvaluatorUtils.getModelLikeNode(this.fParents, parent = (ASTNode)this.fParents.get(method))) instanceof TypeDeclaration) {
                    return new ClassInstanceType(this.fModule, (TypeDeclaration)parentParent);
                }
                if (arg.getInitialization() != null) {
                    IEvaluatedType type = this.evaluateASTNode(arg.getInitialization(), null);
                    if (type instanceof UnknownType) {
                        ++unknownSimpleReferenceBecauseOfArgument;
                    }
                    return type;
                }
                ++unknownSimpleReferenceBecauseOfArgument;
                return UnknownType.INSTANCE;
            }
            first = false;
        }
        return null;
    }

    private IEvaluatedType checkMethodNode(MethodDeclaration method, CallHolder callHolder, SimpleReference reference) {
        if (method.getName().equals(reference.getName())) {
            List arguments = method.getArguments();
            List callHolderArguments = PythonTypeEvaluatorUtils.parseCallHolder(callHolder);
            if (callHolderArguments.size() == arguments.size()) {
                return new FunctionType(this.fModule, method);
            }
            return new FunctionType(this.fModule, method, true);
        }
        return null;
    }

    private IModelElement filterCallType(List types, CallHolder callHolder) {
        ArrayList fTypes = new ArrayList();
        fTypes.addAll(types);
        Collections.reverse(fTypes);
        Iterator i = fTypes.iterator();
        while (i.hasNext()) {
            IModelElement element = (IModelElement)i.next();
            if (element instanceof IMethod) {
                IMethod method = (IMethod)element;
                String[] args = null;
                try {
                    args = method.getParameterNames();
                    List callHolderArgs = PythonTypeEvaluatorUtils.parseCallHolder(callHolder);
                    if (args.length != callHolderArgs.size()) continue;
                    return element;
                }
                catch (ModelException ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            if (!(element instanceof IType)) continue;
            return element;
        }
        return null;
    }

    private IEvaluatedType evaluateSimpleReferenceType(SimpleReference reference, ASTNode scope) {
        if (reference.getName().indexOf(".") == -1) {
            ++totalSimpleReferenceDetections;
        }
        ASTNode parent = null;
        if (!this.fParents.containsKey(reference)) {
            if (reference.getName().indexOf(".") == -1) {
                ++unknownSimpleReferenceNotInAST;
            }
            return UnknownType.INSTANCE;
        }
        parent = PythonTypeEvaluatorUtils.getParentNode(this.fParents, (ASTNode)reference);
        if (parent == null) {
            if (reference.getName().indexOf(".") == -1) {
                --totalSimpleReferenceDetections;
            }
            return UnknownType.INSTANCE;
        }
        ASTNode nodeParent = PythonTypeEvaluatorUtils.getNodeParentBeforeModel(this.fParents, (ASTNode)reference);
        if (nodeParent == null) {
            if (reference.getName().indexOf(".") == -1) {
                ++unknownSimpleReferenceEmptyParent;
            }
            return UnknownType.INSTANCE;
        }
        ASTNode pnode = nodeParent;
        boolean parentFromScope = false;
        while (parent != null) {
            List nodes = null;
            try {
                ASTNode par;
                if (parent instanceof ModuleDeclaration && scope != null && !parentFromScope) {
                    nodeParent = pnode = PythonTypeEvaluatorUtils.getNodeParentBeforeModel(this.fParents, scope);
                    parent = PythonTypeEvaluatorUtils.getParentNode(this.fParents, scope);
                    parentFromScope = true;
                }
                if (scope != null && parent instanceof ModuleDeclaration && (par = (ASTNode)this.fParents.get(nodeParent)) != null) {
                    while (!par.equals(parent) && par != null) {
                        nodeParent = par;
                        par = (ASTNode)this.fParents.get(nodeParent);
                    }
                }
                nodes = this.getUpperNodes(parent, pnode);
                if (parent instanceof Block) {
                    IEvaluatedType stype = this.checkListForReference(reference.getName(), nodes, scope);
                    if (stype != null) {
                        return stype;
                    }
                    IEvaluatedType imported = this.checkReferenceImports(reference.getName(), nodes);
                    if (imported != null) {
                        return imported;
                    }
                    if (!(parent instanceof ModuleDeclaration)) {
                        if (!this.fParents.containsKey(parent)) {
                            if (reference.getName().indexOf(".") == -1) {
                                ++unknownSimpleReferenceNotInAST;
                            }
                            return UnknownType.INSTANCE;
                        }
                    } else {
                        parent = null;
                    }
                } else if (parent instanceof MethodDeclaration) {
                    IEvaluatedType type = this.checkArguments((MethodDeclaration)parent, reference.getName());
                    if (type != null) {
                        return type;
                    }
                } else if (parent instanceof TypeDeclaration) {
                    Iterator i = nodes.iterator();
                    while (i.hasNext()) {
                        MethodDeclaration method;
                        ASTNode node = (ASTNode)i.next();
                        if (node instanceof MethodDeclaration && (method = (MethodDeclaration)node).getName().equals(reference.getName())) {
                            return new FunctionType(this.fModule, (MethodDeclaration)node);
                        }
                        if (!(node instanceof TypeDeclaration) || !(method = (TypeDeclaration)node).getName().equals(reference.getName())) continue;
                        return new OldClassType(this.fModule, (TypeDeclaration)node);
                    }
                }
                pnode = parent;
                parent = (ASTNode)this.fParents.get(parent);
            }
            catch (Exception e) {
                e.printStackTrace();
                return UnknownType.INSTANCE;
            }
        }
        IEvaluatedType buildinType = this.evaluateBuildin(reference.getName());
        if (buildinType != null) {
            return buildinType;
        }
        if (!PythonBuiltIns.isBuiltin(reference.getName()) && reference.getName().indexOf(".") == -1) {
            ++unknownSimpleReferenceNotFoundAtEnd;
        }
        return UnknownType.INSTANCE;
    }

    private IEvaluatedType checkReferenceImports(String reference, List nodes) {
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            ASTNode nde = (ASTNode)i.next();
            if (nde instanceof PythonImportFromStatement) {
                Object element = null;
                if (element == null) continue;
                continue;
            }
            if (!(nde instanceof PythonImportStatement)) continue;
            PythonImportStatement importStatement = (PythonImportStatement)nde;
            Expression expr = importStatement.getExpression();
            List<Object> imports = new ArrayList<Expression>();
            if (expr instanceof PythonTestListExpression) {
                PythonTestListExpression testList = (PythonTestListExpression)expr;
                imports = testList.getExpressions();
            } else {
                imports.add(expr);
            }
            Iterator j = imports.iterator();
            while (j.hasNext()) {
                Object module;
                Expression imp = (Expression)j.next();
                if (imp instanceof PythonImportExpression) {
                    Object module2;
                    PythonImportExpression impex = (PythonImportExpression)imp;
                    String impexName = impex.getName();
                    if (!impexName.equals(reference) || (module2 = null) != null) {
                        // empty if block
                    }
                    if (impexName.indexOf(".") == -1 || !impexName.startsWith(reference) || (module2 = null) == null) continue;
                    continue;
                }
                if (imp instanceof PythonImportAsExpression && (module = null) == null) continue;
            }
        }
        return null;
    }

    Map makeLocalIndex(IModule module) {
        HashMap index = new HashMap();
        ArrayList<Object> queue = new ArrayList<Object>();
        queue.add(module);
        while (queue.size() > 0) {
            List<IModelElement> list;
            IModelElement e = (IModelElement)queue.get(0);
            queue.remove(0);
            if (!index.containsKey(e.getElementName())) {
                list = new ArrayList<IModelElement>();
                list.add(e);
                index.put(e.getElementName(), list);
            } else {
                list = (List)index.get(e.getElementName());
                list.add(e);
            }
            IModelElement[] childs = null;
            try {
                if (e instanceof IParent) {
                    childs = ((IParent)e).getChildren();
                }
            }
            catch (ModelException ex) {
                ex.printStackTrace();
            }
            if (childs == null) continue;
            int i = 0;
            while (i < childs.length) {
                IModelElement element = childs[i];
                queue.add(element);
                ++i;
            }
        }
        return index;
    }

    private IModelElement filerElementForAST(List elements) {
        if (elements.size() == 1) {
            return (IModelElement)elements.get(0);
        }
        if (elements.size() > 0) {
            return (IModelElement)elements.get(0);
        }
        return null;
    }

    private IEvaluatedType evaluateBuildin(String reference) {
        if (PythonBuiltIns.isBuiltin(reference)) {
            ++unknownSimpleReferenceNotFoundAtEndBuiltin;
        }
        return null;
    }

    private IEvaluatedType checkListForReference(String reference, List nodes, ASTNode scope) {
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            MethodDeclaration method;
            ASTNode node = (ASTNode)i.next();
            if (node instanceof Assignment) {
                ExtendedVariableReference ref;
                Assignment assignment = (Assignment)node;
                Statement left = assignment.getLeft();
                Statement right = assignment.getRight();
                if (left instanceof SimpleReference) {
                    if (((SimpleReference)left).getName().equals(reference)) {
                        if (right != null) {
                            return this.evaluateASTNode((ASTNode)right, scope);
                        }
                        return new SimpleType(6);
                    }
                } else if (left instanceof ExtendedVariableReference && (ref = (ExtendedVariableReference)left).isDot(0) && ref.getExpressionCount() == 2) {
                    Expression first = ref.getExpression(0);
                    Expression second = ref.getExpression(1);
                    if (first instanceof VariableReference && ((VariableReference)first).getName().equals(SELF_CONSTANT) && second instanceof VariableReference && ((VariableReference)second).getName().equals(reference)) {
                        if (right != null) {
                            return this.evaluateASTNode((ASTNode)right, scope);
                        }
                        return new SimpleType(6);
                    }
                }
            }
            if (node instanceof MethodDeclaration && (method = (MethodDeclaration)node).getName().equals(reference)) {
                return new FunctionType(this.fModule, (MethodDeclaration)node);
            }
            if (!(node instanceof TypeDeclaration) || !(method = (TypeDeclaration)node).getName().equals(reference)) continue;
            return new OldClassType(this.fModule, (TypeDeclaration)node);
        }
        return null;
    }
}

