/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.javascript.ti.JSDocSupport;
import org.eclipse.dltk.internal.javascript.ti.JSElement;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.parser.PropertyExpressionUtils;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.ReferenceSource;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSMethod
extends ArrayList<IModelBuilder.IParameter>
implements IModelBuilder.IMethod {
    private String name;
    private JSType type;
    private boolean deprecated;
    private Visibility visibility;
    private boolean constructor;
    private ReferenceLocation location = ReferenceLocation.UNKNOWN;
    private ISourceRange docRange;
    private Set<IProblemCategory> suppressedWarnings = null;

    @Override
    public IModelBuilder.IParameter createParameter() {
        return new Parameter();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<IModelBuilder.IParameter> getParameters() {
        return this;
    }

    @Override
    public int getParameterCount() {
        return this.size();
    }

    @Override
    public IModelBuilder.IParameter getParameter(String name) {
        if (name != null) {
            for (IModelBuilder.IParameter parameter : this) {
                if (!name.equals(parameter.getName())) continue;
                return parameter;
            }
        }
        return null;
    }

    @Override
    public JSType getType() {
        return this.type;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setType(JSType type) {
        this.type = type;
    }

    @Override
    public ReferenceLocation getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(ReferenceLocation location) {
        this.location = location;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public boolean isPrivate() {
        return this.visibility == Visibility.PRIVATE;
    }

    @Override
    public boolean isProtected() {
        return this.visibility == Visibility.PROTECTED;
    }

    @Override
    public boolean isConstructor() {
        return this.constructor;
    }

    @Override
    public void setConstructor(boolean constructor) {
        this.constructor = constructor;
    }

    @Override
    public ISourceRange getDocRange() {
        return this.docRange;
    }

    @Override
    public void setDocRange(ISourceRange docRange) {
        this.docRange = docRange;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append('(');
        boolean first = true;
        for (IModelBuilder.IParameter parameter : this) {
            if (!first) {
                sb.append(',');
            }
            first = false;
            sb.append(parameter);
        }
        sb.append(')');
        if (this.type != null) {
            sb.append(':').append(this.type);
        }
        return sb.toString();
    }

    public JSMethod() {
    }

    public JSMethod(FunctionStatement node, ReferenceSource source) {
        this.initialize(node, source, (Expression)node.getName());
    }

    public JSMethod(FunctionStatement node, ReferenceSource source, Expression name) {
        this.initialize(node, source, name);
    }

    protected void initialize(FunctionStatement node, ReferenceSource source, Expression methodName) {
        if (methodName != null) {
            this.setName(PropertyExpressionUtils.nameOf((Expression)methodName));
            this.setLocation(ReferenceLocation.create(source, node.sourceStart(), node.sourceEnd(), methodName.sourceStart(), methodName.sourceEnd()));
        } else {
            Keyword kw = node.getFunctionKeyword();
            this.setLocation(ReferenceLocation.create(source, node.sourceStart(), node.sourceEnd(), kw.sourceStart(), kw.sourceEnd()));
            Object expression = null;
            if (node.getParent() instanceof BinaryOperation) {
                expression = ((BinaryOperation)node.getParent()).getLeftExpression();
                while (expression != null && !(expression instanceof Identifier)) {
                    expression = expression instanceof PropertyExpression ? ((PropertyExpression)expression).getProperty() : null;
                }
            } else if (node.getParent() instanceof PropertyInitializer) {
                expression = ((PropertyInitializer)node.getParent()).getName();
            } else if (node.getParent() instanceof VariableDeclaration) {
                expression = ((VariableDeclaration)node.getParent()).getIdentifier();
            }
            if (expression instanceof Identifier) {
                this.setName(((Identifier)expression).getName());
            } else {
                this.setName("<anonymous>");
            }
        }
        for (Argument argument : node.getArguments()) {
            IModelBuilder.IParameter parameter = this.createParameter();
            parameter.setName(argument.getIdentifier().getName());
            parameter.setLocation(ReferenceLocation.create(source, argument.sourceStart(), argument.sourceEnd()));
            this.getParameters().add(parameter);
        }
        Comment documentation = JSDocSupport.getComment((JSNode)node);
        if (documentation != null) {
            this.setDocRange(documentation.getRange());
        }
    }

    @Override
    public Set<IProblemCategory> getSuppressedWarnings() {
        return this.suppressedWarnings != null ? this.suppressedWarnings : Collections.emptySet();
    }

    @Override
    public void addSuppressedWarning(IProblemCategory warningCategoryId) {
        if (this.suppressedWarnings == null) {
            this.suppressedWarnings = new HashSet<IProblemCategory>();
        }
        this.suppressedWarnings.add(warningCategoryId);
    }

    public static class Parameter
    extends JSElement
    implements IModelBuilder.IParameter {
        private boolean optional;
        private boolean varargs;

        public void setOptional(boolean b) {
            this.optional = b;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public void setVarargs(boolean varargs) {
            this.varargs = varargs;
        }

        public boolean isVarargs() {
            return this.varargs;
        }

        public String toString() {
            return this.getType() != null ? String.valueOf(this.getName()) + ':' + this.getType().getName() : this.getName();
        }
    }
}

