/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.StringTokenizer;
import org.eclipse.dltk.internal.javascript.ti.AbstractReference;
import org.eclipse.dltk.internal.javascript.ti.ILazyValue;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.Value;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueParent;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;

public class LazyTypeReference
extends AbstractReference {
    private final LazyTypeValue value = new LazyTypeValue();
    final ITypeInferenceContext context;
    final String className;
    final IValueCollection collection;

    public LazyTypeReference(ITypeInferenceContext context, String className, IValueCollection collection) {
        this.context = context;
        this.className = className;
        this.collection = collection;
    }

    public IValueReference getChild(String name) {
        if (name.equals("()")) {
            return this;
        }
        return super.getChild(name);
    }

    public IValueReference getParent() {
        return null;
    }

    public String getName() {
        return this.className;
    }

    public void delete() {
    }

    public boolean isReference() {
        return true;
    }

    public IValue getValue() {
        this.value.resolve();
        return this.value;
    }

    public boolean exists() {
        this.value.resolve();
        return this.value.isResolved();
    }

    public IValue createValue() {
        return this.getValue();
    }

    final class LazyTypeValue
    extends Value
    implements ILazyValue {
        boolean resolved = false;
        private boolean finalResolve;
        private boolean doResolve = true;
        private boolean resolving;

        LazyTypeValue() {
        }

        public void resolve() {
            if (!this.resolved && this.doResolve && !this.resolving) {
                this.resolving = true;
                this.doResolve();
                this.resolving = false;
            }
        }

        private void doResolve() {
            IValueReference createChild = LazyTypeReference.this.collection.getChild(LazyTypeReference.this.className);
            if (createChild.exists() && createChild.getAttribute("RESOLVING") == null) {
                IValue src;
                Type target;
                IRType childType = JavaScriptValidations.typeOf(createChild);
                if (childType != null && childType instanceof IRClassType && (target = ((IRClassType)childType).getTarget()) != null) {
                    this.setDeclaredType(JSTypeSet.ref(target));
                    this.resolved = true;
                    return;
                }
                IValueCollection collection = (IValueCollection)createChild.getAttribute("FUNCTION_SCOPE");
                if (collection != null && collection.getThis() != null) {
                    createChild = collection.getThis();
                }
                if ((src = ((IValueProvider)((Object)createChild)).getValue()) != null) {
                    this.addValue(src);
                }
                this.setKind(ReferenceKind.TYPE);
                Type type = TypeInfoModelFactory.eINSTANCE.createType();
                type.setSuperType(LazyTypeReference.this.context.getKnownType("Object", null));
                type.setKind(TypeKind.JAVASCRIPT);
                type.setName(LazyTypeReference.this.className);
                this.setDeclaredType(JSTypeSet.ref(type));
                this.resolved = true;
            } else if (LazyTypeReference.this.className.indexOf(46) != -1) {
                StringTokenizer st = new StringTokenizer(LazyTypeReference.this.className, ".");
                IValueParent child = null;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if ((child = child == null ? LazyTypeReference.this.collection.getChild(token) : child.getChild(token)).exists()) continue;
                    child = null;
                    break;
                }
                if (child != null) {
                    IValue src = ((IValueProvider)((Object)child)).getValue();
                    if (src != null) {
                        IValueCollection collection = (IValueCollection)src.getAttribute("FUNCTION_SCOPE", true);
                        if (collection != null) {
                            this.addValue(((IValueProvider)((Object)collection.getThis())).getValue());
                        } else {
                            this.addValue(src);
                        }
                    }
                    this.setKind(ReferenceKind.TYPE);
                    this.resolved = true;
                }
            } else {
                this.doResolve = !this.finalResolve;
            }
        }

        public String getLazyName() {
            return LazyTypeReference.this.className;
        }

        public boolean isResolved() {
            return this.resolved;
        }

        public void setFinalResolve() {
            this.finalResolve = true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LazyTypeValue) {
                return ((LazyTypeValue)obj).getLazyName().equals(LazyTypeReference.this.className);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return LazyTypeReference.this.className.hashCode();
        }
    }
}

