/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.javascript.ti.ElementValue;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.IValueTypeFactory;
import org.eclipse.dltk.internal.javascript.ti.ImmutableValue;
import org.eclipse.dltk.internal.javascript.ti.PositionReachedException;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitor;
import org.eclipse.dltk.internal.javascript.ti.ValueTypeFactoryImpl;
import org.eclipse.dltk.internal.javascript.ti.ValueWithElementValue;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.parser.JSProblem;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinfo.AttributeKey;
import org.eclipse.dltk.javascript.typeinfo.IElementResolver;
import org.eclipse.dltk.javascript.typeinfo.IMemberEvaluator;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.ITypeProvider;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.OriginReference;
import org.eclipse.dltk.javascript.typeinfo.ReferenceSource;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.GenericType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.RType;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariable;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariableClassType;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariableReference;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInferencer2
implements ITypeInferenceContext {
    private TypeInferencerVisitor visitor;
    private ReferenceSource source;
    private static final boolean DEBUG = false;
    private final Map<String, Type> types = new ConcurrentHashMap<String, Type>();
    private final Map<String, Boolean> activeTypeRequests = new HashMap<String, Boolean>();
    private ITypeProvider[] typeProviders = null;
    private final TypeResourceSet typeRS = new TypeResourceSet(){

        protected Type resolveTypeProxy(String typeName) {
            return TypeInferencer2.this.getType(typeName, null, true, false, false, false);
        }
    };
    static final ConcurrentHashMap<String, InvariantTypeResourceSet> invariantContextRS = new ConcurrentHashMap();
    static final InvariantTypeResourceSet invariantRS = new InvariantTypeResourceSet(invariantContextRS);
    private IValueTypeFactory factory = new ValueTypeFactoryImpl(this);
    private boolean resolve = true;
    private Map<String, Member> elements = new HashMap<String, Member>();
    private IModelBuilder[] modelBuilders = null;
    private static final ThreadLocal<TypeInferencer2> CURRENT = new ThreadLocal();
    protected static final ITypeSystem DELEGATING_TYPE_SYSTEM = new DelagatingTypeSystem();
    private final Map<AttributeKey<?>, List<Object>> attributes = new HashMap();

    private void initializeVisitor() {
        if (this.visitor == null) {
            this.visitor = new TypeInferencerVisitor(this);
        }
        this.visitor.initialize();
    }

    public void setVisitor(TypeInferencerVisitor visitor) {
        this.visitor = visitor;
    }

    public void setModelElement(IModelElement modelElement) {
        this.setSource(new ReferenceSource(modelElement));
    }

    public void setSource(ReferenceSource source) {
        this.source = source;
    }

    public void doInferencing(Script script) {
        TypeInferencer2 saved = CURRENT.get();
        try {
            try {
                CURRENT.set(this);
                this.elements.clear();
                this.modelBuilders = null;
                this.typeProviders = null;
                this.initializeVisitor();
                this.visitor.visit((ASTNode)script);
                this.visitor.done();
            }
            catch (PositionReachedException e) {
                throw e;
            }
            catch (RuntimeException e) {
                this.log(e);
                CURRENT.set(saved);
            }
            catch (AssertionError e) {
                this.log((Throwable)((Object)e));
                CURRENT.set(saved);
            }
        }
        finally {
            CURRENT.set(saved);
        }
    }

    protected void log(Throwable e) {
        JSProblemReporter reporter = this.visitor.getProblemReporter();
        if (reporter != null) {
            reporter.reportProblem((IProblem)new JSProblem(e));
        }
        JavaScriptPlugin.error(e);
    }

    public IValueReference evaluate(ASTNode node) {
        this.initializeVisitor();
        return this.visitor.visit(node);
    }

    public IValueCollection getCollection() {
        return this.visitor.getCollection();
    }

    public IValueCollection currentCollection() {
        return this.visitor.peekContext();
    }

    @Override
    public Type getType(String typeName) {
        boolean queryProviders;
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        return this.getType(typeName, null, queryProviders, true, !(queryProviders = this.canQueryTypeProviders()), true);
    }

    @Override
    public SimpleType getTypeRef(String typeName) {
        return TypeUtil.ref(this.getType(typeName));
    }

    @Override
    public Type getKnownType(String typeName, TypeMode mode) {
        boolean queryProviders;
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        return this.getType(typeName, mode, queryProviders, true, !(queryProviders = this.canQueryTypeProviders()), false);
    }

    @Override
    public Type resolveType(Type type) {
        if (type != null && type.isProxy()) {
            return this.doResolveType(type);
        }
        return type;
    }

    protected Type doResolveType(Type type) {
        String typeName = URI.decode((String)((InternalEObject)type).eProxyURI().fragment());
        Type resolved = this.getType(typeName, null, true, true, false, true);
        if (resolved != null) {
            return resolved;
        }
        return type;
    }

    private String buildParameterizedTypeName(GenericType genericType, List<IRType> parameters) {
        StringBuilder parameterizedName = new StringBuilder();
        parameterizedName.append(genericType.getName());
        parameterizedName.append("<");
        int i = 0;
        while (i < genericType.getTypeParameters().size()) {
            if (i > 0) {
                parameterizedName.append(",");
            }
            if (i < parameters.size()) {
                parameterizedName.append(parameters.get(i).getName());
            } else {
                parameterizedName.append("*");
            }
            ++i;
        }
        parameterizedName.append(">");
        String name = parameterizedName.toString();
        return name;
    }

    @Override
    public Type parameterize(Type target, List<IRType> parameters) {
        if ((target = this.resolveType(target)) instanceof GenericType) {
            GenericType genericType = (GenericType)target;
            String name = this.buildParameterizedTypeName(genericType, parameters);
            Type type = this.types.get(name);
            if (type != null) {
                return type;
            }
            Parameterizer parameterizer = new Parameterizer(genericType, parameters);
            type = parameterizer.copy();
            parameterizer.copyReferences();
            type.setName(name);
            type.eAdapters().add((Object)new OriginReference(genericType, parameterizer.actualParameters));
            this.types.put(name, type);
            this.typeRS.addToResource(type);
            return type;
        }
        return target;
    }

    @Override
    public Set<String> listTypes(TypeMode mode, String prefix) {
        Set<String> typeNames;
        HashSet<String> result = new HashSet<String>();
        TypeInfoModelLoader loader = TypeInfoModelLoader.getInstance();
        Set<String> set = typeNames = mode == TypeMode.CODE ? loader.listTypeLiterals(prefix) : loader.listTypes(prefix);
        if (typeNames != null) {
            result.addAll(typeNames);
        }
        ITypeProvider[] iTypeProviderArray = this.getTypeProviders();
        int n = iTypeProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeProvider provider = iTypeProviderArray[n2];
            typeNames = provider.listTypes(this, mode, prefix);
            if (typeNames != null) {
                result.addAll(typeNames);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public ReferenceSource getSource() {
        return this.source;
    }

    @Override
    public IValueCollection getTopValueCollection() {
        if (this.resolve) {
            IMemberEvaluator[] iMemberEvaluatorArray = TypeInfoManager.getMemberEvaluators();
            int n = iMemberEvaluatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberEvaluator evaluator = iMemberEvaluatorArray[n2];
                IValueCollection collection = evaluator.getTopValueCollection(this);
                if (collection != null) {
                    return collection;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public IModelElement getModelElement() {
        return this.source != null ? this.source.getModelElement() : null;
    }

    @Override
    public String getContext() {
        return null;
    }

    private Type getType(String typeName, TypeMode mode, boolean queryProviders, boolean queryPredefined, boolean allowProxy, boolean allowUnknown) {
        Type type = this.types.get(typeName);
        if (type != null) {
            if (!allowUnknown && type.getKind() == TypeKind.UNKNOWN) {
                return null;
            }
            return type;
        }
        type = invariantRS.getCachedType(typeName);
        if (type != null) {
            this.types.put(typeName, type);
            return type;
        }
        type = this.loadType(typeName, mode, queryProviders, queryPredefined);
        if (type != null) {
            this.validateTypeInfo(type);
            this.types.put(typeName, type);
            this.typeRS.addToResource(type);
            return type;
        }
        if (allowProxy) {
            type = TypeUtil.createProxy(typeName);
            return type;
        }
        if (allowUnknown) {
            type = TypeInferencer2.createUnknown(typeName);
            this.typeRS.addToResource(type);
            this.types.put(typeName, type);
            return type;
        }
        return null;
    }

    private void validateTypeInfo(Type type) {
        ResourceSet resourceSet;
        Resource resource = type.eResource();
        if (resource != null && (resourceSet = resource.getResourceSet()) != null && !(resourceSet instanceof InvariantTypeResourceSet)) {
            Assert.isLegal((!(resourceSet instanceof TypeResourceSet) ? 1 : 0) != 0, (String)("Type " + type.getName() + " has invalid resource: " + resource + " (" + resourceSet.getClass() + ")"));
        }
    }

    @Override
    public void markInvariant(Type type) {
        if (type.eResource() != null) {
            return;
        }
        invariantRS.add(type);
    }

    @Override
    public void markInvariant(Type type, String context) {
        if (type.eResource() != null) {
            return;
        }
        if (context == null) {
            this.markInvariant(type);
        } else {
            InvariantTypeResourceSet set;
            Assert.isLegal((type.eContainer() == null ? 1 : 0) != 0);
            Assert.isLegal((type.eResource() == null ? 1 : 0) != 0);
            InvariantTypeResourceSet invariantTypeResourceSet = invariantContextRS.get(context);
            if (invariantTypeResourceSet == null && (set = invariantContextRS.putIfAbsent(context, invariantTypeResourceSet = new InvariantTypeResourceSet(context, invariantRS, invariantContextRS))) != null) {
                invariantTypeResourceSet = set;
            }
            invariantTypeResourceSet.add(type);
        }
    }

    @Override
    public Type getInvariantType(String typeName, String context) {
        if (context == null) {
            return invariantRS.getCachedType(typeName);
        }
        InvariantTypeResourceSet invariantTypeResourceSet = invariantContextRS.get(context);
        if (invariantTypeResourceSet != null) {
            return invariantTypeResourceSet.getCachedType(typeName);
        }
        return null;
    }

    protected static Type createUnknown(String typeName) {
        Type type = TypeInfoModelFactory.eINSTANCE.createType();
        type.setName(typeName);
        type.setKind(TypeKind.UNKNOWN);
        return type;
    }

    private boolean canQueryTypeProviders() {
        return this.activeTypeRequests.isEmpty();
    }

    private Type loadType(String typeName, TypeMode mode, boolean queryProviders, boolean queryPredefined) {
        if (queryProviders && this.activeTypeRequests.put(typeName, Boolean.FALSE) == null) {
            try {
                Type type = invariantRS.getCachedType(typeName);
                if (type != null) {
                    Type type2 = type;
                    return type2;
                }
                ITypeProvider[] iTypeProviderArray = this.getTypeProviders();
                int n = iTypeProviderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeProvider provider = iTypeProviderArray[n2];
                    type = provider.getType(this, mode, typeName);
                    if (type != null && !TypeInferencer2.isProxy(type)) {
                        Type type3 = type;
                        return type3;
                    }
                    ++n2;
                }
            }
            finally {
                this.activeTypeRequests.remove(typeName);
            }
        }
        if (queryPredefined) {
            TypeInfoModelLoader loader = TypeInfoModelLoader.getInstance();
            Type type = mode == TypeMode.CODE ? loader.getTypeLiteral(typeName) : loader.getType(typeName);
            if (type != null) {
                return type;
            }
        }
        return null;
    }

    @Override
    public ITypeProvider[] getTypeProviders() {
        if (this.typeProviders == null) {
            this.typeProviders = this.createTypeProviders();
        }
        return this.typeProviders;
    }

    protected ITypeProvider[] createTypeProviders() {
        return TypeInfoManager.createTypeProviders(this);
    }

    protected static boolean isProxy(Type type) {
        return type.eIsProxy();
    }

    @Override
    public IValueTypeFactory getFactory() {
        return this.factory;
    }

    @Override
    public Member resolve(String name) {
        if (name == null) {
            return null;
        }
        Member element = this.elements.get(name);
        if (element != null) {
            return element;
        }
        element = TypeInfoModelLoader.getInstance().getMember(name);
        if (element != null) {
            this.elements.put(name, element);
            return element;
        }
        if (this.resolve) {
            IElementResolver[] iElementResolverArray = TypeInfoManager.getElementResolvers();
            int n = iElementResolverArray.length;
            int n2 = 0;
            while (n2 < n) {
                IElementResolver resolver = iElementResolverArray[n2];
                element = resolver.resolveElement(this, name);
                if (element != null) {
                    this.elements.put(name, element);
                    return element;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public IValue valueOf(Member member) {
        IMemberEvaluator[] iMemberEvaluatorArray = TypeInfoManager.getMemberEvaluators();
        int n = iMemberEvaluatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberEvaluator evaluator = iMemberEvaluatorArray[n2];
            IValueCollection collection = evaluator.valueOf(this, member);
            if (collection != null) {
                if (!(collection instanceof IValueProvider)) break;
                IValue value = ((IValueProvider)((Object)collection)).getValue();
                if (member.getType() != null) {
                    value.setDeclaredType(JSTypeSet.normalize(this, member.getType()));
                }
                if (value.getKind() == ReferenceKind.UNKNOWN) {
                    if (member instanceof Property) {
                        value.setKind(ReferenceKind.PROPERTY);
                    } else {
                        value.setKind(ReferenceKind.METHOD);
                    }
                }
                if (value instanceof ImmutableValue) {
                    ElementValue elementValue = ElementValue.createFor(member, this);
                    return new ValueWithElementValue((ImmutableValue)value, elementValue);
                }
                return value;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Set<String> listGlobals(String prefix) {
        HashSet<String> result = new HashSet<String>();
        for (Member member : TypeInfoModelLoader.getInstance().listMembers(prefix)) {
            result.add(member.getName());
        }
        IElementResolver[] iElementResolverArray = TypeInfoManager.getElementResolvers();
        int n = iElementResolverArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElementResolver resolver = iElementResolverArray[n2];
            Set<String> globals = resolver.listGlobals(this, prefix);
            if (globals != null) {
                result.addAll(globals);
            }
            ++n2;
        }
        return result;
    }

    public void setDoResolve(boolean resolve) {
        this.resolve = resolve;
    }

    @Override
    public IModelBuilder[] getModelBuilders() {
        if (this.modelBuilders == null) {
            this.modelBuilders = TypeInfoManager.getModelBuilders(this);
        }
        return this.modelBuilders;
    }

    @Override
    public <T> T getAttribute(AttributeKey<T> key) {
        List<Object> values = this.attributes.get(key);
        return (T)(values != null && !values.isEmpty() ? values.get(values.size() - 1) : null);
    }

    @Override
    public <T> void pushAttribute(AttributeKey<T> key, T value) {
        List<Object> values = this.attributes.get(key);
        if (values == null) {
            values = new ArrayList<Object>(4);
            this.attributes.put(key, values);
        }
        values.add(value);
    }

    @Override
    public <T> T popAttribute(AttributeKey<T> key) {
        List<Object> values = this.attributes.get(key);
        if (values != null && !values.isEmpty()) {
            return (T)values.remove(values.size() - 1);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelagatingTypeSystem
    implements ITypeSystem {
        private DelagatingTypeSystem() {
        }

        private TypeInferencer2 current() {
            return (TypeInferencer2)CURRENT.get();
        }

        @Override
        public IValue valueOf(Member member) {
            TypeInferencer2 current = this.current();
            if (current != null) {
                return current.valueOf(member);
            }
            return null;
        }

        @Override
        public Type resolveType(Type type) {
            if (type != null && type.isProxy()) {
                TypeInferencer2 current = this.current();
                if (current != null) {
                    return current.doResolveType(type);
                }
                Type resolved = TypeInfoModelLoader.getInstance().getType(type.getName());
                if (resolved != null) {
                    return resolved;
                }
            }
            return type;
        }

        @Override
        public Type parameterize(Type target, List<IRType> parameters) {
            TypeInferencer2 current = this.current();
            if (current != null) {
                return current.parameterize(target, parameters);
            }
            return target;
        }

        @Override
        public <T> T getAttribute(AttributeKey<T> key) {
            TypeInferencer2 current = this.current();
            return current != null ? (T)current.getAttribute(key) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InvariantTypeResourceSet
    extends TypeResourceSet
    implements ITypeInfoContext {
        private final String context;
        private final InvariantTypeResourceSet staticInvariants;
        private final ConcurrentMap<String, InvariantTypeResourceSet> contextInvariants;
        private final Set<String> activeTypeRequests = new HashSet<String>();
        private final Map<String, Type> types = new ConcurrentHashMap<String, Type>();
        private ITypeProvider[] typeProviders = null;

        public InvariantTypeResourceSet(ConcurrentMap<String, InvariantTypeResourceSet> contextInvariants) {
            this(null, null, contextInvariants);
        }

        public InvariantTypeResourceSet(String context, InvariantTypeResourceSet staticInvariants, ConcurrentMap<String, InvariantTypeResourceSet> contextInvariants) {
            this.context = context;
            this.staticInvariants = staticInvariants;
            this.contextInvariants = contextInvariants;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean canQueryTypeProviders() {
            Set<String> set = this.activeTypeRequests;
            synchronized (set) {
                return this.activeTypeRequests.isEmpty();
            }
        }

        @Override
        public String getContext() {
            return this.context;
        }

        private Type getType(String typeName, TypeMode mode, boolean queryProviders, boolean queryPredefined, boolean allowProxy, boolean allowUnknown) {
            Type type = this.types.get(typeName);
            if (type != null) {
                return type;
            }
            type = this.loadType(typeName, mode, queryProviders, queryPredefined);
            if (type != null) {
                this.addToResource(type);
                return type;
            }
            if (allowProxy) {
                type = TypeUtil.createProxy(typeName);
                return type;
            }
            if (allowUnknown) {
                type = TypeInferencer2.createUnknown(typeName);
                this.addToResource(type);
                return type;
            }
            return null;
        }

        @Override
        public SimpleType getTypeRef(String typeName) {
            return TypeUtil.ref(this.getType(typeName));
        }

        public ITypeProvider[] getTypeProviders() {
            if (this.typeProviders == null) {
                this.typeProviders = TypeInfoManager.createTypeProviders(this);
            }
            return this.typeProviders;
        }

        /*
         * Exception decompiling
         */
        private Type loadType(String typeName, TypeMode mode, boolean queryProviders, boolean queryPredefined) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        protected Type resolveTypeProxy(String typeName) {
            Type cachedType;
            if (this.staticInvariants != null && (cachedType = this.staticInvariants.getCachedType(typeName)) != null) {
                return cachedType;
            }
            return this.getType(typeName, null, true, false, false, false);
        }

        @Override
        public Type getType(String typeName) {
            boolean queryProviders;
            if (typeName == null || typeName.length() == 0) {
                return null;
            }
            return this.getType(typeName, null, queryProviders, true, !(queryProviders = this.canQueryTypeProviders()), true);
        }

        @Override
        public Type getKnownType(String typeName, TypeMode mode) {
            boolean queryProviders;
            if (typeName == null || typeName.length() == 0) {
                return null;
            }
            return this.getType(typeName, null, queryProviders, true, !(queryProviders = this.canQueryTypeProviders()), false);
        }

        @Override
        public Type resolveType(Type type) {
            String typeName;
            Type resolved;
            if (type != null && type.isProxy() && (resolved = this.getType(typeName = URI.decode((String)((InternalEObject)type).eProxyURI().fragment()), null, true, true, false, true)) != null) {
                return resolved;
            }
            return type;
        }

        @Override
        public void markInvariant(Type type) {
            if (type.eResource() != null) {
                return;
            }
            if (this.staticInvariants == null) {
                this.add(type);
            } else {
                this.staticInvariants.add(type);
            }
        }

        @Override
        public void markInvariant(Type type, String context) {
            if (type.eResource() != null) {
                return;
            }
            if (context.equals(this.context)) {
                this.add(type);
            } else {
                InvariantTypeResourceSet set;
                InvariantTypeResourceSet invariantTypeResourceSet = (InvariantTypeResourceSet)this.contextInvariants.get(context);
                if (invariantTypeResourceSet == null && (set = invariantContextRS.putIfAbsent(context, invariantTypeResourceSet = new InvariantTypeResourceSet(context, invariantRS, invariantContextRS))) != null) {
                    invariantTypeResourceSet = set;
                }
                invariantTypeResourceSet.add(type);
            }
        }

        @Override
        public Type getInvariantType(String typeName, String context) {
            if (context == null) {
                if (this.staticInvariants == null) {
                    return this.getCachedType(typeName);
                }
                return this.staticInvariants.getCachedType(typeName);
            }
            if (context.equals(this.context)) {
                return this.getCachedType(typeName);
            }
            InvariantTypeResourceSet invariantTypeResourceSet = invariantContextRS.get(context);
            if (invariantTypeResourceSet != null) {
                return invariantTypeResourceSet.getCachedType(typeName);
            }
            return null;
        }

        @Override
        public IModelElement getModelElement() {
            return null;
        }

        @Override
        public ReferenceSource getSource() {
            return ReferenceSource.UNKNOWN;
        }

        @Override
        public void add(Type type) {
            super.add(type);
            this.types.put(type.getName(), type);
        }

        public Type getCachedType(String typeName) {
            return this.types.get(typeName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            this.types.clear();
            InvariantTypeResourceSet invariantTypeResourceSet = this;
            synchronized (invariantTypeResourceSet) {
                this.getResource().getContents().clear();
            }
        }

        @Override
        public IValue valueOf(Member member) {
            return null;
        }

        @Override
        public Type parameterize(Type target, List<IRType> parameters) {
            return target;
        }

        @Override
        public <T> T getAttribute(AttributeKey<T> key) {
            return null;
        }

        @Override
        public <T> void pushAttribute(AttributeKey<T> key, T value) {
        }

        @Override
        public <T> T popAttribute(AttributeKey<T> key) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Parameterizer
    extends EcoreUtil.Copier {
        final GenericType genericType;
        final Map<TypeVariable, IRType> parameters = new HashMap<TypeVariable, IRType>();
        final IRType[] actualParameters;

        public Parameterizer(GenericType genericType, List<IRType> parameters) {
            super(false);
            this.genericType = genericType;
            EList<TypeVariable> variables = genericType.getTypeParameters();
            this.actualParameters = new IRType[variables.size()];
            int i = 0;
            while (i < variables.size()) {
                TypeVariable variable = (TypeVariable)variables.get(i);
                IRType variableType = null;
                if (i < parameters.size()) {
                    variableType = parameters.get(i);
                }
                if (variableType == null) {
                    variableType = JSTypeSet.any();
                }
                this.actualParameters[i] = variableType;
                this.parameters.put(variable, variableType);
                ++i;
            }
        }

        public Type copy() {
            return (Type)this.copy(this.genericType);
        }

        public EObject copy(EObject eObject) {
            EClass eClass;
            EObject copyEObject;
            if (eObject == null) {
                return null;
            }
            if (eObject == this.genericType) {
                EClass genericClass = this.genericType.eClass();
                String parametererizedType = EcoreUtil.getAnnotation((EModelElement)genericClass, (String)"http://www.eclipse.org/dltk/javascript/typeinfo.ecore", (String)"parameterizedType");
                if (parametererizedType != null) {
                    EClass parametererizedClass = (EClass)genericClass.getEPackage().getEClassifier(parametererizedType);
                    copyEObject = EcoreUtil.create((EClass)parametererizedClass);
                } else {
                    copyEObject = TypeInfoModelFactory.eINSTANCE.createType();
                }
                eClass = copyEObject.eClass();
            } else {
                if (eObject instanceof TypeVariableReference) {
                    IRType source = this.parameters.get(((TypeVariableReference)eObject).getVariable());
                    RType result = TypeInfoModelFactory.eINSTANCE.createRType();
                    result.setRuntimeType(source);
                    return result;
                }
                if (eObject instanceof TypeVariableClassType) {
                    IRType source = this.parameters.get(((TypeVariableClassType)eObject).getVariable());
                    RType result = TypeInfoModelFactory.eINSTANCE.createRType();
                    result.setRuntimeType(JSTypeSet.classType(source instanceof IRSimpleType ? ((IRSimpleType)source).getTarget() : null));
                    return result;
                }
                copyEObject = this.createCopy(eObject);
                eClass = eObject.eClass();
            }
            this.put(eObject, copyEObject);
            int i = 0;
            int size = eClass.getFeatureCount();
            while (i < size) {
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
                if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived()) {
                    if (eStructuralFeature instanceof EAttribute) {
                        this.copyAttribute((EAttribute)eStructuralFeature, eObject, copyEObject);
                    } else {
                        EReference eReference = (EReference)eStructuralFeature;
                        if (eReference.isContainment()) {
                            this.copyContainment(eReference, eObject, copyEObject);
                        }
                    }
                }
                ++i;
            }
            this.copyProxyURI(eObject, copyEObject);
            return copyEObject;
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject instanceof TypeVariableReference || eObject instanceof TypeVariableClassType) {
                return;
            }
            super.copyReference(eReference, eObject, copyEObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TypeResolveMode {
        SIMPLE,
        PROXY,
        UNKNOWN;

    }

    static abstract class TypeResourceSet
    extends ResourceSetImpl {
        private Resource typesResource = null;

        public TypeResourceSet() {
            TypeInfoModelLoader.getInstance().initializeURIMap((ResourceSet)this);
        }

        public EObject getEObject(URI uri, boolean loadOnDemand) {
            if (TypeUtil.isTypeProxy(uri)) {
                String typeName = URI.decode((String)uri.fragment());
                Type type = this.resolveTypeProxy(typeName);
                if (type == null) {
                    return TypeInferencer2.createUnknown(typeName);
                }
                return type;
            }
            return super.getEObject(uri, loadOnDemand);
        }

        protected abstract Type resolveTypeProxy(String var1);

        public synchronized Resource getResource() {
            if (this.typesResource == null) {
                this.typesResource = new ResourceImpl(TypeUtil.createProxyResourceURI());
                this.getResources().add((Object)this.typesResource);
            }
            return this.typesResource;
        }

        public void addToResource(Type type) {
            Type object = type;
            if (object.eResource() == null) {
                this.add(type);
            }
        }

        protected synchronized void add(Type type) {
            this.getResource().getContents().add((Object)type);
        }
    }
}

