/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.compiler.util.SimpleSet;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.index.EntryResult;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.internal.core.search.IndexQueryRequestor;
import org.eclipse.dltk.internal.core.search.matching.DLTKSearchPattern;

public abstract class AndPattern
extends DLTKSearchPattern {
    public AndPattern(int patternKind, int matchRule, IDLTKLanguageToolkit toolkit) {
        super(patternKind, matchRule, toolkit);
    }

    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IDLTKSearchScope scope, IProgressMonitor progressMonitor) throws IOException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.resetQuery();
        SimpleSet intersectedNames = null;
        try {
            index.startQuery();
            do {
                SearchPattern pattern;
                EntryResult[] entries;
                if ((entries = (pattern = this.currentPattern()).queryIn(index)) == null) {
                    return;
                }
                SearchPattern decodedResult = pattern.getBlankPattern();
                SimpleSet newIntersectedNames = new SimpleSet(3);
                int i = 0;
                int l = entries.length;
                while (i < l) {
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    EntryResult entry = entries[i];
                    decodedResult.decodeIndexKey(entry.getWord());
                    if (pattern.matchesDecodedKey(decodedResult)) {
                        int n;
                        int j;
                        String[] names = entry.getDocumentNames(index);
                        if (intersectedNames != null) {
                            j = 0;
                            n = names.length;
                            while (j < n) {
                                if (intersectedNames.includes(names[j])) {
                                    newIntersectedNames.add(names[j]);
                                }
                                ++j;
                            }
                        } else {
                            j = 0;
                            n = names.length;
                            while (j < n) {
                                newIntersectedNames.add(names[j]);
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
                if (newIntersectedNames.elementSize == 0) {
                    return;
                }
                intersectedNames = newIntersectedNames;
            } while (this.hasNextQuery());
        }
        finally {
            index.stopQuery();
        }
        String containerPath = index.getContainerPath();
        char separator = index.separator;
        Object[] names = intersectedNames.values;
        int i = 0;
        int l = names.length;
        while (i < l) {
            if (names[i] != null) {
                this.acceptMatch((String)names[i], containerPath, separator, null, requestor, participant, scope);
            }
            ++i;
        }
    }

    public abstract boolean hasNextQuery();

    public abstract void resetQuery();
}

