/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.eclipse.dltk.console.IScriptConsoleIO;
import org.eclipse.dltk.console.InterpreterResponse;
import org.eclipse.dltk.console.ScriptConsoleIO;
import org.eclipse.dltk.console.ShellResponse;

public class SocketScriptConsoleIO
implements IScriptConsoleIO {
    private final Socket socket;
    private final IScriptConsoleIO io;

    public SocketScriptConsoleIO(Socket socket) throws IOException {
        this.socket = socket;
        BufferedOutputStream output = new BufferedOutputStream(socket.getOutputStream());
        this.io = new ScriptConsoleIO(socket.getInputStream(), output);
    }

    public String getId() {
        return this.io.getId();
    }

    public InterpreterResponse execInterpreter(String command) throws IOException {
        return this.io.execInterpreter(command);
    }

    public ShellResponse execShell(String command, String[] args) throws IOException {
        return this.io.execShell(command, args);
    }

    public void close() throws IOException {
        this.io.close();
        this.socket.close();
    }

    public InputStream getInitialResponseStream() {
        return this.io.getInitialResponseStream();
    }
}

