/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.codeassist.ICompletionEngine;
import org.eclipse.dltk.codeassist.ISelectionEngine;
import org.eclipse.dltk.codeassist.ISelectionRequestor;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.BufferChangedEvent;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IBufferChangedListener;
import org.eclipse.dltk.core.ICompletionRequestorExtension;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.BufferManager;
import org.eclipse.dltk.internal.core.Messages;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ScriptProject;

public abstract class Openable
extends ModelElement
implements IOpenable,
IBufferChangedListener {
    protected Openable(ModelElement parent) {
        super(parent);
    }

    public void bufferChanged(BufferChangedEvent event) {
        if (event.getBuffer().isClosed()) {
            ModelManager.getModelManager().getElementsOutOfSynchWithBuffers().remove(this);
            this.getBufferManager().removeBuffer(event.getBuffer());
        } else {
            ModelManager.getModelManager().getElementsOutOfSynchWithBuffers().add(this);
        }
    }

    protected abstract boolean buildStructure(OpenableElementInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws ModelException;

    public boolean canBeRemovedFromCache() {
        try {
            return !this.hasUnsavedChanges();
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public boolean canBufferBeRemovedFromCache(IBuffer buffer) {
        return !buffer.hasUnsavedChanges();
    }

    protected void closeBuffer() {
        if (!this.hasBuffer()) {
            return;
        }
        IBuffer buffer = this.getBufferManager().getBuffer(this);
        if (buffer != null) {
            buffer.close();
            buffer.removeBufferChangedListener(this);
        }
    }

    protected void closing(Object info) {
        this.closeBuffer();
    }

    public boolean exists() {
        ModelManager manager = ModelManager.getModelManager();
        if (manager.getInfo(this) != null) {
            return true;
        }
        if (!this.parentExists()) {
            return false;
        }
        IProjectFragment root = this.getProjectFragment();
        if (!(root == null || root != this && root.isArchive())) {
            return this.resourceExists();
        }
        return super.exists();
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor monitor) throws ModelException {
        if (ModelManager.VERBOSE) {
            String element;
            switch (this.getElementType()) {
                case 2: {
                    element = "project";
                    break;
                }
                case 3: {
                    element = "fragment";
                    break;
                }
                case 4: {
                    element = "folder";
                    break;
                }
                case 6: {
                    element = "binary module";
                    break;
                }
                case 5: {
                    element = "source module";
                    break;
                }
                default: {
                    element = "element";
                }
            }
            System.out.println(Thread.currentThread() + " OPENING " + element + " " + this.toStringWithAncestors());
        }
        this.openParent(info, newElements, monitor);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        newElements.put(this, info);
        try {
            OpenableElementInfo openableElementInfo = (OpenableElementInfo)info;
            boolean isStructureKnown = this.buildStructure(openableElementInfo, monitor, newElements, this.getResource());
            openableElementInfo.setIsStructureKnown(isStructureKnown);
        }
        catch (ModelException e) {
            newElements.remove(this);
            throw e;
        }
        ModelManager.getModelManager().getElementsOutOfSynchWithBuffers().remove(this);
        if (ModelManager.VERBOSE) {
            System.out.println(ModelManager.getModelManager().cache.toStringFillingRation("-> "));
        }
    }

    public IBuffer getBuffer() throws ModelException {
        if (this.hasBuffer()) {
            Object info = this.getElementInfo();
            IBuffer buffer = this.getBufferManager().getBuffer(this);
            if (buffer == null) {
                buffer = this.openBuffer(null, info);
            }
            return buffer;
        }
        return null;
    }

    public IBuffer getBufferNotOpen() throws ModelException {
        if (this.hasBuffer()) {
            return this.getBufferManager().getBuffer(this);
        }
        return null;
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    public IResource getCorrespondingResource() throws ModelException {
        return this.getUnderlyingResource();
    }

    public IOpenable getOpenable() {
        return this;
    }

    public IResource getUnderlyingResource() throws ModelException {
        IResource parentResource = this.parent.getUnderlyingResource();
        if (parentResource == null) {
            return null;
        }
        int type = parentResource.getType();
        if (type == 2 || type == 4) {
            IContainer folder = (IContainer)parentResource;
            IResource resource = folder.findMember(this.getElementName());
            if (resource == null) {
                throw this.newNotPresentException();
            }
            return resource;
        }
        return parentResource;
    }

    protected boolean hasBuffer() {
        return false;
    }

    public boolean hasUnsavedChanges() throws ModelException {
        IBuffer buf;
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        if (this.hasBuffer() && (buf = this.getBufferNotOpen()) != null && buf.hasUnsavedChanges()) {
            return true;
        }
        int elementType = this.getElementType();
        if (elementType == 4 || elementType == 3 || elementType == 2 || elementType == 1) {
            Enumeration openBuffers = this.getBufferManager().getOpenBuffers();
            while (openBuffers.hasMoreElements()) {
                IOpenable owner;
                IBuffer buffer = (IBuffer)openBuffers.nextElement();
                if (!buffer.hasUnsavedChanges() || !this.isAncestorOf(owner = buffer.getOwner())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConsistent() {
        return true;
    }

    public boolean isOpen() {
        return ModelManager.getModelManager().getInfo(this) != null;
    }

    protected boolean isSourceElement() {
        return false;
    }

    public boolean isStructureKnown() throws ModelException {
        return ((OpenableElementInfo)this.getElementInfo()).isStructureKnown();
    }

    public void makeConsistent(IProgressMonitor monitor) throws ModelException {
    }

    public void open(IProgressMonitor pm) throws ModelException {
        this.getElementInfo(pm);
    }

    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws ModelException {
        return null;
    }

    protected void openParent(Object childInfo, HashMap newElements, IProgressMonitor pm) throws ModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent != null && !openableParent.isOpen()) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    protected boolean parentExists() {
        IModelElement parentElement = this.getParent();
        if (parentElement == null) {
            return true;
        }
        return parentElement.exists();
    }

    protected boolean resourceExists() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return false;
        }
        return Model.getTarget((IContainer)workspace.getRoot(), this.getPath().makeRelative(), true) != null;
    }

    public void save(IProgressMonitor pm, boolean force) throws ModelException {
        if (this.isReadOnly()) {
            throw new ModelException(new ModelStatus(976, this));
        }
        IBuffer buf = this.getBuffer();
        if (buf != null) {
            buf.save(pm, force);
            this.makeConsistent(pm);
        }
    }

    public IProjectFragment getProjectFragment() {
        return (IProjectFragment)this.getAncestor(3);
    }

    protected void codeComplete(IModuleSource cu, int position, CompletionRequestor requestor, WorkingCopyOwner owner, long timeout) throws ModelException {
        if (requestor == null) {
            throw new IllegalArgumentException(Messages.Openable_completionRequesterCannotBeNull);
        }
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return;
        }
        if (position < -1 || position > buffer.getLength()) {
            if (DLTKCore.DEBUG) {
                throw new ModelException(new ModelStatus(980));
            }
            return;
        }
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this);
        if (toolkit == null) {
            return;
        }
        CompletionThread thread = new CompletionThread(toolkit, this.getScriptProject(), cu, position, requestor);
        if (!thread.execute(timeout)) {
            Thread.interrupted();
            requestor.completionFailure(new DefaultProblem("Computation of proposals takes too long. Please try again.", IProblemIdentifier.NULL, null, ProblemSeverity.WARNING, 0, 0, 0));
            if (requestor instanceof ICompletionRequestorExtension) {
                ((ICompletionRequestorExtension)((Object)requestor)).reset();
            }
        }
    }

    private void codeSelect(IModuleSource cu, int offset, int length, WorkingCopyOwner owner, ModelElementSelectionRequestor requestor) throws ModelException {
        IDLTKLanguageToolkit toolkit;
        ScriptProject project = (ScriptProject)this.getScriptProject();
        IBuffer buffer = this.getBuffer();
        int end = -1;
        if (buffer != null) {
            end = buffer.getLength();
        }
        if ((toolkit = DLTKLanguageManager.getLanguageToolkit(this)) == null) {
            return;
        }
        if (offset < 0 || length < 0 || end != -1 && offset + length > end) {
            throw new ModelException(new ModelStatus(980));
        }
        ISelectionEngine[] engines = DLTKLanguageManager.getSelectionEngines(toolkit.getNatureId());
        if (engines != null) {
            ISelectionEngine[] iSelectionEngineArray = engines;
            int n = engines.length;
            int n2 = 0;
            while (n2 < n) {
                ISelectionEngine engine = iSelectionEngineArray[n2];
                engine.setOptions(project.getOptions(true));
                engine.setRequestor(requestor);
                IModelElement[] result = engine.select(cu, offset, offset + length - 1);
                if (result != null) {
                    requestor.addModelElements(result);
                }
                if (!requestor.isEmpty()) {
                    return;
                }
                ++n2;
            }
        }
    }

    protected IModelElement[] codeSelect(IModuleSource cu, int offset, int length, WorkingCopyOwner owner) throws ModelException {
        ModelElementSelectionRequestor requestor = new ModelElementSelectionRequestor();
        this.codeSelect(cu, offset, length, owner, requestor);
        return requestor.toModelElementArray();
    }

    protected Object[] codeSelectAll(IModuleSource cu, int offset, int length, WorkingCopyOwner owner) throws ModelException {
        ModelElementSelectionRequestor requestor = new ModelElementSelectionRequestor();
        this.codeSelect(cu, offset, length, owner, requestor);
        return requestor.toArray();
    }

    static class CompletionThread
    extends Thread {
        final IDLTKLanguageToolkit toolkit;
        final IScriptProject project;
        final IModuleSource cu;
        final int position;
        final CompletionRequestor requestor;
        final NullProgressMonitor monitor = new NullProgressMonitor();
        private boolean done = false;

        public CompletionThread(IDLTKLanguageToolkit toolkit, IScriptProject project, IModuleSource cu, int position, CompletionRequestor requestor) {
            super("CompletionThread-" + toolkit.getLanguageName());
            this.toolkit = toolkit;
            this.project = project;
            this.cu = cu;
            this.position = position;
            this.requestor = requestor;
        }

        public void run() {
            ICompletionEngine[] engines = DLTKLanguageManager.getCompletionEngines(this.toolkit.getNatureId());
            if (engines != null) {
                ICompletionEngine[] iCompletionEngineArray = engines;
                int n = engines.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompletionEngine engine = iCompletionEngineArray[n2];
                    this.run(engine);
                    if (this.requestor.isIgnored(Integer.MIN_VALUE) || this.monitor.isCanceled()) break;
                    ++n2;
                }
            }
            this.done = true;
        }

        private void run(ICompletionEngine engine) {
            engine.setRequestor(this.requestor);
            engine.setOptions(this.project.getOptions(true));
            engine.setProject(this.project);
            engine.setProgressMonitor((IProgressMonitor)this.monitor);
            engine.complete(this.cu, this.position, 0);
        }

        boolean execute(long timeout) {
            this.start();
            try {
                this.join(timeout);
                if (!this.done) {
                    this.monitor.setCanceled(true);
                    this.interrupt();
                }
                return this.done;
            }
            catch (InterruptedException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                return false;
            }
        }
    }

    static class ModelElementSelectionRequestor
    implements ISelectionRequestor {
        final List<IModelElement> elements = new ArrayList<IModelElement>();
        final List<Object> foreignElements = new ArrayList<Object>();

        ModelElementSelectionRequestor() {
        }

        public void acceptForeignElement(Object object) {
            this.foreignElements.add(object);
        }

        public void acceptModelElement(IModelElement element) {
            this.elements.add(element);
        }

        void addModelElements(IModelElement[] elements) {
            Collections.addAll(this.elements, elements);
        }

        IModelElement[] toModelElementArray() {
            if (this.elements.isEmpty()) {
                return ScriptModelUtil.NO_ELEMENTS;
            }
            return this.elements.toArray(new IModelElement[this.elements.size()]);
        }

        boolean isEmpty() {
            return this.elements.isEmpty() && this.foreignElements.isEmpty();
        }

        Object[] toArray() {
            if (this.isEmpty()) {
                return ScriptModelUtil.NO_ELEMENTS;
            }
            ArrayList<Object> result = new ArrayList<Object>(this.elements.size() + this.foreignElements.size());
            result.addAll(this.elements);
            result.addAll(this.foreignElements);
            return result.toArray(new Object[result.size()]);
        }
    }
}

