/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core.dom.rewrite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.javascript.core.dom.BinaryExpression;
import org.eclipse.dltk.javascript.core.dom.BinaryOperator;
import org.eclipse.dltk.javascript.core.dom.CatchClause;
import org.eclipse.dltk.javascript.core.dom.DomPackage;
import org.eclipse.dltk.javascript.core.dom.FunctionExpression;
import org.eclipse.dltk.javascript.core.dom.Identifier;
import org.eclipse.dltk.javascript.core.dom.Label;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.Statement;
import org.eclipse.dltk.javascript.core.dom.TryStatement;
import org.eclipse.dltk.javascript.core.dom.UnaryExpression;
import org.eclipse.dltk.javascript.core.dom.UnaryOperator;
import org.eclipse.dltk.javascript.core.dom.VariableDeclaration;
import org.eclipse.dltk.javascript.core.dom.rewrite.Generator;
import org.eclipse.dltk.javascript.core.dom.util.DomSwitch;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.jface.text.Document;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewriteAnalyzer
extends DomSwitch<Boolean> {
    private final ChangeDescription cd;
    private final Set<Node> generated = new HashSet<Node>();
    private final String text;
    protected final String lineDelimiter;
    private final TextEdit edit;
    static NodeSeparator NEWLINE = new NodeSeparator(){

        public void appendTo(Generator gen) {
            gen.newLine();
        }
    };
    static NodeSeparator COMMA = new NodeSeparator(){

        public void appendTo(Generator gen) {
            gen.append(",");
        }
    };
    static NodeSeparator COMMA_NEWLINE = new NodeSeparator(){

        public void appendTo(Generator gen) {
            gen.append(",");
            gen.newLine();
        }
    };

    public RewriteAnalyzer(ChangeDescription cd, String text) {
        this.cd = cd;
        this.text = text;
        this.lineDelimiter = new Document(text).getDefaultLineDelimiter();
        this.edit = new MultiTextEdit();
    }

    public RewriteAnalyzer(ChangeDescription cd, String text, String lineDelimiter) {
        this.cd = cd;
        this.text = text;
        this.lineDelimiter = lineDelimiter;
        this.edit = new MultiTextEdit();
    }

    public void rewrite(Node node) {
        this.doSwitch(node);
        for (EObject obj : node.eContents()) {
            if (this.generated.contains(obj)) continue;
            this.rewrite((Node)obj);
        }
    }

    public TextEdit getEdit() {
        return this.edit;
    }

    protected void addEdit(TextEdit edit, Node node) {
        this.edit.addChild(edit);
    }

    private void processFeature(Node node, FeatureChange fc) {
        if (fc.getFeature() instanceof EAttribute) {
            return;
        }
        if (!fc.getFeature().isMany()) {
            int len;
            Node n = (Node)node.eGet(fc.getFeature());
            Node o = (Node)fc.getReferenceValue();
            int off = o == null ? this.calcOffset(node, fc.getFeature()) : o.getBegin();
            int n2 = len = o == null ? 0 : o.getEnd() - o.getBegin();
            String value = n == null ? "" : this.generate(n, node, o == null, off);
            this.addEdit((TextEdit)new ReplaceEdit(off, len, value), n);
            return;
        }
        EList dst = (EList)node.eGet(fc.getFeature());
        BasicEList src = new BasicEList();
        src.addAll((Collection)dst);
        HashSet<Node> deleted = new HashSet<Node>();
        HashSet<Node> generated = new HashSet<Node>();
        for (ListChange lc : fc.getListChanges()) {
            if (lc.getKind() != ChangeKind.ADD_LITERAL) {
                generated.add((Node)src.get(lc.getIndex()));
            }
            if (lc.getKind() == ChangeKind.MOVE_LITERAL) {
                deleted.add((Node)src.get(lc.getIndex()));
            }
            lc.apply((EList)src);
            if (lc.getKind() != ChangeKind.ADD_LITERAL) continue;
            deleted.add((Node)src.get(lc.getIndex()));
        }
        if (fc.getListChanges().isEmpty()) {
            src.clear();
            generated.addAll((Collection<Node>)dst);
        }
        ArrayList<Node> original = new ArrayList<Node>(src.size());
        for (Object obj : src) {
            original.add((Node)obj);
        }
        Node last = null;
        for (Node item : original) {
            if (deleted.contains(item)) continue;
            last = item;
        }
        boolean isLast = last == null;
        int i = 0;
        while (i < original.size()) {
            Node item = (Node)original.get(i);
            if (deleted.contains(item)) {
                int off = isLast && i != 0 ? ((Node)original.get(i - 1)).getEnd() : item.getBegin();
                int end = isLast ? item.getEnd() : ((Node)original.get(i + 1)).getBegin();
                this.addEdit((TextEdit)new DeleteEdit(off, end - off), item);
            } else {
                isLast = item == last;
            }
            ++i;
        }
        ArrayList<Integer> offs = new ArrayList<Integer>();
        int cur = original.isEmpty() ? this.calcOffset(node, fc.getFeature()) : ((Node)original.get(original.size() - 1)).getEnd();
        int i2 = dst.size() - 1;
        while (i2 >= 0) {
            Node item = (Node)dst.get(i2);
            if (!generated.contains(item)) {
                cur = item.getBegin();
            }
            offs.add(cur);
            --i2;
        }
        Collections.reverse(offs);
        isLast = last == null;
        i2 = 0;
        while (i2 < dst.size()) {
            Node item = (Node)dst.get(i2);
            if (generated.contains(item)) {
                int off = (Integer)offs.get(i2);
                this.addEdit((TextEdit)new InsertEdit(off, this.generateElement(item, i2 == 0, isLast, off)), item);
            } else {
                isLast = item == last;
            }
            ++i2;
        }
    }

    @Override
    public Boolean caseNode(Node node) {
        if (this.cd.getObjectChanges().get((Object)node) != null) {
            for (FeatureChange fc : (EList)this.cd.getObjectChanges().get((Object)node)) {
                this.processFeature(node, fc);
            }
        }
        return true;
    }

    @Override
    public Boolean caseUnaryExpression(UnaryExpression node) {
        if (this.cd.getObjectChanges().get((Object)node) != null) {
            for (FeatureChange fc : (EList)this.cd.getObjectChanges().get((Object)node)) {
                if (fc.getFeature() == DomPackage.eINSTANCE.getUnaryExpression_Operation()) {
                    UnaryOperator n = node.getOperation();
                    UnaryOperator o = (UnaryOperator)((Object)fc.getValue());
                    int len = o.toString().length();
                    if (RewriteAnalyzer.isPostfix((Object)o)) {
                        this.addEdit((TextEdit)new DeleteEdit(node.getEnd() - len, len), node);
                    } else {
                        this.addEdit((TextEdit)new DeleteEdit(node.getBegin(), len), node);
                    }
                    if (RewriteAnalyzer.isPostfix((Object)n)) {
                        this.addEdit((TextEdit)new InsertEdit(node.getEnd(), n.toString()), node);
                        continue;
                    }
                    String r = n.toString();
                    if (RewriteAnalyzer.isTextUnary((Object)n)) {
                        r = String.valueOf(r) + ' ';
                    }
                    this.addEdit((TextEdit)new InsertEdit(node.getBegin(), r), node);
                    continue;
                }
                this.processFeature(node, fc);
            }
        }
        return true;
    }

    private static boolean isPostfix(Object op) {
        return op == UnaryOperator.POSTFIX_INC || op == UnaryOperator.POSTFIX_DEC;
    }

    private static boolean isTextUnary(Object op) {
        return op == UnaryOperator.DELETE || op == UnaryOperator.VOID || op == UnaryOperator.TYPEOF || op == UnaryOperator.YIELD;
    }

    @Override
    public Boolean caseIdentifier(Identifier node) {
        if (this.cd.getObjectChanges().get((Object)node) != null) {
            for (FeatureChange fc : (EList)this.cd.getObjectChanges().get((Object)node)) {
                if (fc.getFeature() != DomPackage.eINSTANCE.getIdentifier_Name()) continue;
                this.addEdit((TextEdit)new ReplaceEdit(node.getBegin(), node.getEnd() - node.getBegin(), node.getName()), node);
            }
        }
        return true;
    }

    @Override
    public Boolean caseLabel(Label node) {
        if (this.cd.getObjectChanges().get((Object)node) != null) {
            for (FeatureChange fc : (EList)this.cd.getObjectChanges().get((Object)node)) {
                if (fc.getFeature() != DomPackage.eINSTANCE.getLabel_Name()) continue;
                this.addEdit((TextEdit)new ReplaceEdit(node.getBegin(), node.getEnd() - node.getBegin(), node.getName()), node);
            }
        }
        return true;
    }

    @Override
    public Boolean caseBinaryExpression(BinaryExpression node) {
        if (this.cd.getObjectChanges().get((Object)node) != null) {
            for (FeatureChange fc : (EList)this.cd.getObjectChanges().get((Object)node)) {
                if (fc.getFeature() == DomPackage.eINSTANCE.getBinaryExpression_Operation()) {
                    BinaryExpression be = node;
                    String r = be.getOperation().toString();
                    if (RewriteAnalyzer.isTextBinary(fc.getValue())) {
                        r = String.valueOf(' ') + r + ' ';
                    }
                    this.addEdit((TextEdit)new ReplaceEdit(be.getOperatorPosition(), fc.getValue().toString().length(), r), node);
                    continue;
                }
                this.processFeature(node, fc);
            }
        }
        return true;
    }

    private static boolean isTextBinary(Object op) {
        return op == BinaryOperator.IN || op == BinaryOperator.INSTANCEOF;
    }

    private int calcOffset(Node node, EStructuralFeature sf) {
        EReference ref = (EReference)sf;
        switch (ref.getEContainingClass().getClassifierID()) {
            case 58: {
                return node.getBegin();
            }
            case 31: {
                return node.getEnd() - 1;
            }
            case 32: {
                return node.getBegin() + 3;
            }
            case 59: {
                return node.getBegin() + 5;
            }
            case 33: 
            case 36: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 57: {
                return node.getEnd();
            }
            case 26: {
                return node.getEnd() - 1;
            }
            case 47: {
                throw new IllegalStateException("Empty switch statement");
            }
            case 54: {
                CatchClause cc = (CatchClause)node;
                return cc.getException().getEnd();
            }
            case 53: {
                TryStatement ts = (TryStatement)node;
                if (ts.getFinallyClause() != null) {
                    return ts.getFinallyClause().getBegin();
                }
                return node.getEnd();
            }
            case 56: {
                FunctionExpression expr = (FunctionExpression)node;
                if (ref == DomPackage.eINSTANCE.getFunctionExpression_Identifier()) {
                    return expr.getParametersPosition() - 1;
                }
                return expr.getParametersPosition();
            }
        }
        return -1;
    }

    public String generateElement(Node node, boolean first, boolean last, int pos) {
        Generator gen = new Generator(this.cd, this.text, pos, this.lineDelimiter);
        NodeSeparator separator = node instanceof Statement ? NEWLINE : (node instanceof VariableDeclaration && ((VariableDeclaration)node).getInitializer() != null ? COMMA_NEWLINE : COMMA);
        if (!first && last) {
            separator.appendTo(gen);
        }
        gen.generate(node);
        if (!last) {
            separator.appendTo(gen);
        }
        this.generated.add(node);
        return gen.toString();
    }

    public String generate(Node node, Node parent, boolean wasNull, int pos) {
        Generator gen = new Generator(this.cd, this.text, pos, this.lineDelimiter);
        if (wasNull && parent.eClass() == DomPackage.eINSTANCE.getVariableDeclaration()) {
            gen.append("=");
        }
        if (wasNull && parent.eClass() == DomPackage.eINSTANCE.getFunctionExpression()) {
            gen.append(" ");
        }
        if (wasNull && node.eContainmentFeature() == DomPackage.eINSTANCE.getCatchClause_Filter()) {
            gen.append(" if ");
        }
        gen.generate(node);
        this.generated.add(node);
        return gen.toString();
    }

    private static abstract class NodeSeparator {
        private NodeSeparator() {
        }

        public abstract void appendTo(Generator var1);
    }
}

