/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.javascript.corext.refactoring.ParameterInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.IntroduceParameterRefactoring;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.javascript.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.dltk.javascript.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class IntroduceParameterWizard
extends RefactoringWizard {
    public IntroduceParameterWizard(IntroduceParameterRefactoring ref) {
        super((Refactoring)ref, 36);
        this.setDefaultPageTitle(RefactoringMessages.IntroduceParameterWizard_defaultPageTitle);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new IntroduceParameterInputPage());
    }

    private static class IntroduceParameterInputPage
    extends UserInputWizardPage {
        private static final String DESCRIPTION = RefactoringMessages.IntroduceParameterInputPage_description;
        public static final String PAGE_NAME = "IntroduceParameterInputPage";
        private ScriptSourceViewer fSignaturePreview;
        private Document fSignaturePreviewDocument;

        public IntroduceParameterInputPage() {
            super(PAGE_NAME);
            this.setDescription(DESCRIPTION);
            this.fSignaturePreviewDocument = new Document();
        }

        private IntroduceParameterRefactoring getIntroduceParameterRefactoring() {
            return (IntroduceParameterRefactoring)this.getRefactoring();
        }

        public void createControl(Composite parent) {
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            GridLayout layout = new GridLayout();
            result.setLayout((Layout)layout);
            this.createParameterTableControl(result);
            Label sep = new Label(result, 258);
            sep.setLayoutData((Object)new GridData(768));
            this.createSignaturePreview(result);
            this.update(false);
            Dialog.applyDialogFont((Control)result);
        }

        private ChangeParametersControl createParameterTableControl(Composite composite) {
            String labelText = RefactoringMessages.IntroduceParameterWizard_parameters;
            ChangeParametersControl cp = new ChangeParametersControl(composite, 0, labelText, new IParameterListChangeListener(){

                public void parameterChanged(ParameterInfo parameter) {
                    IntroduceParameterInputPage.this.update(true);
                }

                public void parameterListChanged() {
                    IntroduceParameterInputPage.this.update(true);
                }

                public void parameterAdded(ParameterInfo parameter) {
                    IntroduceParameterInputPage.this.update(true);
                }
            }, ChangeParametersControl.Mode.INTRODUCE_PARAMETER);
            cp.setLayoutData(new GridData(1808));
            cp.setInput(this.getIntroduceParameterRefactoring().getParameterInfos());
            cp.editParameter(this.getIntroduceParameterRefactoring().getAddedParameterInfo());
            return cp;
        }

        private void createSignaturePreview(Composite composite) {
            Label previewLabel = new Label(composite, 0);
            previewLabel.setText(RefactoringMessages.ChangeSignatureInputPage_method_Signature_Preview);
            IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((String)"org.eclipse.dltk.javascript.core.nature");
            IPreferenceStore store = toolkit.getCombinedPreferenceStore();
            this.fSignaturePreview = new ScriptSourceViewer(composite, null, null, false, 584, store);
            this.fSignaturePreview.configure((SourceViewerConfiguration)new JavascriptSourceViewerConfiguration(toolkit.getTextTools().getColorManager(), store, null, null));
            this.fSignaturePreview.getTextWidget().setBackground(composite.getBackground());
            this.fSignaturePreview.setDocument((IDocument)this.fSignaturePreviewDocument);
            this.fSignaturePreview.setEditable(false);
            Control signaturePreviewControl = this.fSignaturePreview.getControl();
            PixelConverter pixelConverter = new PixelConverter(signaturePreviewControl);
            GridData gdata = new GridData(1808);
            gdata.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
            gdata.heightHint = pixelConverter.convertHeightInCharsToPixels(2);
            signaturePreviewControl.setLayoutData((Object)gdata);
        }

        private void update(boolean displayErrorMessage) {
            this.updateStatus(displayErrorMessage);
            this.updateSignaturePreview();
        }

        private void updateStatus(boolean displayErrorMessage) {
            RefactoringStatus nameCheck = this.getIntroduceParameterRefactoring().validateInput();
            if (displayErrorMessage) {
                this.setPageComplete(nameCheck);
            } else {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        }

        private void updateSignaturePreview() {
            try {
                int top = this.fSignaturePreview.getTextWidget().getTopPixel();
                this.fSignaturePreviewDocument.set(this.getIntroduceParameterRefactoring().getMethodSignaturePreview());
                this.fSignaturePreview.getTextWidget().setTopPixel(top);
            }
            catch (ModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), (String)RefactoringMessages.IntroduceParameterWizard_defaultPageTitle, (String)RefactoringMessages.ChangeSignatureInputPage_exception);
            }
        }
    }
}

