/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.validation.TypeInfoValidator;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.parser.ISuppressWarningsState;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingRequestor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptDeprecationHighlightVisitor
extends TypeInfoValidator.ValidationVisitor
implements JSProblemReporter {
    private final ISemanticHighlightingRequestor requestor;
    private static final Set<JavaScriptProblems> DEPRECATION = EnumSet.of(JavaScriptProblems.DEPRECATED_FUNCTION, JavaScriptProblems.DEPRECATED_METHOD, JavaScriptProblems.DEPRECATED_PROPERTY, JavaScriptProblems.DEPRECATED_TYPE, JavaScriptProblems.DEPRECATED_VARIABLE);

    public JavaScriptDeprecationHighlightVisitor(ITypeInferenceContext context, ISemanticHighlightingRequestor requestor) {
        super(context, null, null);
        this.reporter = this;
        this.requestor = requestor;
    }

    public void reportProblem(IProblem problem) {
    }

    public void reportProblem(IProblemIdentifier identifier, String message, int start, int end) {
        if (DEPRECATION.contains(identifier)) {
            this.requestor.addPosition(start, end, "JS_DEPRECATED");
        }
    }

    public void reportProblem(ProblemSeverity severity, IProblemIdentifier identifier, String message, int start, int end) {
        this.reportProblem(identifier, message, start, end);
    }

    public int getProblemCount() {
        return 0;
    }

    public void pushSuppressWarnings(Collection<IProblemIdentifier> suppressed) {
    }

    public void popSuppressWarnings() {
    }

    public ISuppressWarningsState getSuppressWarnings() {
        return null;
    }

    public void restoreSuppressWarnings(ISuppressWarningsState state) {
    }
}

