/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching.sourcelookup;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.IPathEquality;
import org.eclipse.dltk.internal.launching.PathEqualityUtils;
import org.eclipse.dltk.launching.sourcelookup.IProjectLookupResult;

public class ProjectSourceLookup {
    private final IProject project;
    private IEnvironment environment = null;
    private IScriptProject scriptProject = null;

    public ProjectSourceLookup(IProject project) {
        this.project = project;
    }

    private IEnvironment getEnvironment() {
        if (this.environment == null) {
            this.environment = EnvironmentManager.getEnvironment((IProject)this.project);
        }
        return this.environment;
    }

    public IScriptProject getScriptProject() {
        if (this.scriptProject == null) {
            this.scriptProject = DLTKCore.create((IProject)this.project);
        }
        return this.scriptProject;
    }

    public IProjectLookupResult find(IPath path) {
        IFileHandle file = this.getEnvironment().getFile(path);
        if (file.exists()) {
            IFile[] workspaceFiles = ProjectSourceLookup.getWorkspaceRoot().findFilesForLocationURI(file.toURI());
            if (workspaceFiles.length != 0 && workspaceFiles[0].exists()) {
                return new WorkspaceLookupResult(workspaceFiles);
            }
            try {
                ExternalSourceModuleFinder finder = new ExternalSourceModuleFinder(file.getFullPath());
                this.getScriptProject().accept((IModelElementVisitor)finder);
                if (finder.isFound()) {
                    return new SourceModuleLookupResult(finder.getResult());
                }
                LocalSourceModuleFinder finder2 = new LocalSourceModuleFinder(file.getPath());
                this.getScriptProject().accept((IModelElementVisitor)finder2);
                if (finder2.isFound()) {
                    return new WorkspaceLookupResult(finder2.getResult());
                }
            }
            catch (ModelException e) {
                DLTKLaunchingPlugin.log(e);
            }
        }
        return null;
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private static final class ExternalSourceModuleFinder
    implements IModelElementVisitor {
        private final IPath fileFullPath;
        private final IPathEquality pathEquality = PathEqualityUtils.getInstance();
        private final ISourceModule[] result = new ISourceModule[1];

        private ExternalSourceModuleFinder(IPath fileFullPath) {
            this.fileFullPath = fileFullPath;
        }

        public boolean visit(IModelElement element) {
            IProjectFragment fragment;
            if (element.getElementType() == 3 && !(fragment = (IProjectFragment)element).isExternal()) {
                return false;
            }
            if (element.getElementType() == 5) {
                ISourceModule module = (ISourceModule)element;
                IPath modulePath = module.getPath();
                if (module instanceof IExternalSourceModule) {
                    IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)element);
                    IExternalSourceModule mdl = (IExternalSourceModule)module;
                    modulePath = mdl.getFullPath();
                    if (!EnvironmentPathUtils.isFull((IPath)modulePath)) {
                        modulePath = EnvironmentPathUtils.getFullPath((IEnvironment)environment, (IPath)modulePath);
                    }
                }
                if (this.pathEquality.equals(this.fileFullPath, modulePath)) {
                    this.result[0] = module;
                }
                return false;
            }
            return true;
        }

        public boolean isFound() {
            return this.result[0] != null;
        }

        public ISourceModule[] getResult() {
            return this.result;
        }
    }

    private static final class LocalSourceModuleFinder
    implements IModelElementVisitor {
        private final IPath fileFullPath;
        private final IPathEquality pathEquality = PathEqualityUtils.getInstance();
        private final IFile[] result = new IFile[1];

        private LocalSourceModuleFinder(IPath fileFullPath) {
            this.fileFullPath = fileFullPath;
        }

        public boolean visit(IModelElement element) {
            IProjectFragment fragment;
            if (element.getElementType() == 3 && (fragment = (IProjectFragment)element).isExternal()) {
                return false;
            }
            if (element.getElementType() == 5) {
                IFileHandle file;
                ISourceModule module = (ISourceModule)element;
                IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)element.getScriptProject());
                IResource resource = module.getResource();
                if (resource != null && this.pathEquality.equals(this.fileFullPath, (file = environment.getFile(resource.getLocationURI())).getPath())) {
                    this.result[0] = (IFile)resource;
                }
                return false;
            }
            return true;
        }

        public boolean isFound() {
            return this.result[0] != null;
        }

        public IFile[] getResult() {
            return this.result;
        }
    }

    private static final class SourceModuleLookupResult
    implements IProjectLookupResult {
        private final ISourceModule[] modules;

        public SourceModuleLookupResult(ISourceModule[] modules) {
            this.modules = modules;
        }

        public Object[] toArray() {
            return this.modules;
        }

        public int size() {
            return this.modules.length;
        }
    }

    private static final class WorkspaceLookupResult
    implements IProjectLookupResult {
        private final IFile[] files;

        public WorkspaceLookupResult(IFile[] files) {
            this.files = files;
        }

        public Object[] toArray() {
            return this.files;
        }

        public int size() {
            return this.files.length;
        }
    }
}

