/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.ui.wizards.ProjectWizardInitializerManager;
import org.eclipse.dltk.internal.ui.wizards.ProjectWizardState;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.ui.wizards.ILocationGroup;
import org.eclipse.dltk.ui.wizards.IProjectWizard;
import org.eclipse.dltk.ui.wizards.IProjectWizardInitializer;
import org.eclipse.dltk.ui.wizards.IProjectWizardPage;
import org.eclipse.dltk.ui.wizards.NewElementWizard;
import org.eclipse.dltk.ui.wizards.ProjectCreator;
import org.eclipse.dltk.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.dltk.ui.wizards.ProjectWizardSecondPage;
import org.eclipse.dltk.utils.ResourceUtil;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class ProjectWizard
extends NewElementWizard
implements INewWizard,
IExecutableExtension,
IProjectWizard {
    private IConfigurationElement fConfigElement;
    private ProjectCreator fCreator;
    private IProjectWizardInitializer.IProjectWizardState projectWizardState = null;

    public void createPageControls(Composite pageContainer) {
        this.initProjectWizard();
        super.createPageControls(pageContainer);
    }

    protected void initProjectWizard() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof IProjectWizardPage) {
                ((IProjectWizardPage)page).initProjectWizardPage();
            }
            ++n2;
        }
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.getProjectCreator().performFinish(monitor);
    }

    public boolean performFinish() {
        this.updateSteps(null);
        boolean res = super.performFinish();
        if (res) {
            IScriptProject newElement = this.getCreatedElement();
            IWorkingSet[] workingSets = ((ProjectWizardFirstPage)this.getFirstPage()).getWorkingSets();
            if (workingSets.length > 0) {
                this.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)newElement, workingSets);
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)newElement.getProject());
        }
        return res;
    }

    protected ILocationGroup getFirstPage() {
        IWizardPage page = this.getPage("ProjectWizardFirstPage");
        Assert.isNotNull((Object)page);
        return (ILocationGroup)page;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.getProjectCreator().removeProject();
        return super.performCancel();
    }

    public IScriptProject getCreatedElement() {
        IWizardPage page = this.getPage("ProjectWizardSecondPage");
        Assert.isNotNull((Object)page);
        return ((ProjectWizardSecondPage)page).getScriptProject();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        while (nextPage != null && !this.isEnabledPage(nextPage)) {
            nextPage = super.getNextPage(nextPage);
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage prevPage = super.getPreviousPage(page);
        while (prevPage != null && !this.isEnabledPage(prevPage)) {
            prevPage = super.getPreviousPage(prevPage);
        }
        return prevPage;
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            IWizardPage page = pages[i];
            if (this.isEnabledPage(page) && !page.isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabledPage(IWizardPage page) {
        return true;
    }

    public IEnvironment getEnvironment() {
        return this.getFirstPage().getEnvironment();
    }

    public IInterpreterInstall getInterpreter() {
        return this.getFirstPage().getInterpreter();
    }

    public IProject getProject() {
        return this.getFirstPage().getProjectHandle();
    }

    public void createProject() {
        this.updateSteps(this.getContainer().getCurrentPage());
        this.getProjectCreator().changeToNewProject();
    }

    public void removeProject() {
        this.getProjectCreator().removeProject();
    }

    public ProjectCreator getProjectCreator() {
        if (this.fCreator == null) {
            this.fCreator = this.createProjectCreator();
        }
        return this.fCreator;
    }

    protected ProjectCreator createProjectCreator() {
        return new ProjectCreator(this, this.getFirstPage());
    }

    protected void updateSteps(IWizardPage currentPage) {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page == currentPage) break;
            if (page instanceof IProjectWizardPage) {
                ((IProjectWizardPage)page).updateProjectWizardPage();
            }
            ++n2;
        }
    }

    public abstract String getScriptNature();

    public IProjectWizardInitializer.IProjectWizardState getWizardState() {
        if (this.projectWizardState == null) {
            this.projectWizardState = new ProjectWizardState(this.getScriptNature());
            Iterator iterator = new ProjectWizardInitializerManager(this.getScriptNature()).iterator();
            while (iterator.hasNext()) {
                IProjectWizardInitializer initializer = (IProjectWizardInitializer)iterator.next();
                initializer.initialize(this.projectWizardState);
            }
        }
        return this.projectWizardState;
    }

    protected void configureNatures(IProject project, IProgressMonitor monitor) throws CoreException {
        ResourceUtil.addNature((IProject)project, (IProgressMonitor)monitor, (String)this.getScriptNature());
    }

    protected void configureProject(IProject project, IProgressMonitor monitor) throws CoreException {
    }
}

