/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.heredoc;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ui.text.heredoc.HereDocPartitionRule;
import org.eclipse.dltk.ui.text.heredoc.HereDocUtils;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HereDocEnabledPartitionScanner
extends RuleBasedPartitionScanner {
    private List<TokenContainer> buffer = new ArrayList<TokenContainer>();
    private HereDocPartitionRule hereDocRule;

    public HereDocEnabledPartitionScanner(List<IPredicateRule> rules, HereDocPartitionRule hereDocRule) {
        this.hereDocRule = hereDocRule;
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        this.setPredicateRules(rules.toArray(result));
    }

    public IToken nextToken() {
        if (HereDocUtils.isHereDocContent(this.fContentType)) {
            return this.handleHereDoc();
        }
        if (!this.buffer.isEmpty()) {
            return this.buffer.remove(0).getToken();
        }
        return this.getNextToken(false);
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.buffer.clear();
        super.setPartialRange(document, offset, length, contentType, partitionOffset);
    }

    private IToken evalPossibleHereDoc(boolean inScan) {
        int c;
        this.fTokenOffset = this.fOffset;
        IToken token = this.hereDocRule.evaluate(this);
        if (token.isUndefined() || inScan) {
            return token;
        }
        this.buffer.add(new TokenContainer(token));
        while ((c = this.read()) != -1) {
            this.unread();
            IToken next = this.getNextToken(true);
            this.buffer.add(new TokenContainer(next));
            if (c == 10) break;
        }
        if (c != -1) {
            this.consumeHereDoc();
        }
        return this.buffer.remove(0).getToken();
    }

    private void consumeHereDoc() {
        for (TokenContainer container : new ArrayList<TokenContainer>(this.buffer)) {
            if (!HereDocUtils.isHereDocContent(container.getContentType())) continue;
            this.fTokenOffset = this.fOffset;
            this.fColumn = -1;
            IToken body = this.hereDocRule.evaluate(this, container.getContentType());
            this.buffer.add(new TokenContainer(body));
        }
    }

    private IToken getNextToken(boolean inScan) {
        IToken token = this.evalPossibleHereDoc(inScan);
        if (token.isUndefined()) {
            token = super.nextToken();
        }
        return token;
    }

    private IToken handleHereDoc() {
        this.fTokenOffset = this.fPartitionOffset;
        IToken token = this.hereDocRule.evaluate(this, this.fContentType);
        this.fContentType = null;
        return token;
    }

    private class TokenContainer {
        private int offset;
        private IToken token;
        private int tokenOffset;

        TokenContainer(IToken token) {
            this.offset = HereDocEnabledPartitionScanner.this.fOffset;
            this.tokenOffset = HereDocEnabledPartitionScanner.this.fTokenOffset;
            this.token = token;
        }

        String getContentType() {
            return (String)this.token.getData();
        }

        IToken getToken() {
            HereDocEnabledPartitionScanner.this.fOffset = this.offset;
            HereDocEnabledPartitionScanner.this.fTokenOffset = this.tokenOffset;
            return this.token;
        }
    }
}

