/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.builder.IBuildState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBuildState
implements IBuildState {
    private final String projectName;
    private final Set<IPath> structuralChanges = new HashSet<IPath>();

    public AbstractBuildState(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public void recordStructuralChange(IPath path) {
        Assert.isLegal((boolean)this.projectName.equals(path.segment(0)));
        this.structuralChanges.add(path);
    }

    public void recordStructuralChanges(Collection<IPath> paths) {
        for (IPath path : paths) {
            this.recordStructuralChange(path);
        }
    }

    @Override
    public Set<IPath> getStructuralChanges() {
        return Collections.unmodifiableSet(this.structuralChanges);
    }

    public void resetStructuralChanges() {
        this.structuralChanges.clear();
    }

    @Override
    public final void recordDependency(IPath path, IPath dependency) {
        this.recordDependency(path, dependency, 1);
    }
}

