/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser.structure;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.structure.IDeclaration;
import org.eclipse.dltk.javascript.structure.IStructureRequestor;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.ClassType;
import org.eclipse.dltk.javascript.typeinfo.model.FunctionType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureRequestor
implements IStructureRequestor {
    private final ISourceElementRequestor requestor;
    private final Stack<ElementType> elementTypes = new Stack();

    public StructureRequestor(ISourceElementRequestor requestor) {
        this.requestor = requestor;
    }

    @Override
    public void acceptImport(IElementRequestor.ImportInfo importInfo) {
        this.requestor.acceptImport(importInfo);
    }

    @Override
    public void acceptTypeReference(ASTNode node, String typeName) {
        this.requestor.acceptTypeReference(typeName, node.sourceStart());
    }

    @Override
    public void acceptLocalReference(Identifier node, IDeclaration target) {
    }

    @Override
    public void enterLocal(Identifier identifer, JSType type) {
        this.acceptTypeReference(identifer.start(), type);
    }

    @Override
    public void exitLocal(int sourceEnd) {
    }

    @Override
    public void acceptFieldReference(Identifier node) {
        this.requestor.acceptFieldReference(node.getName(), node.sourceStart());
    }

    @Override
    public void acceptMethodReference(Identifier node, int argCount) {
        this.requestor.acceptMethodReference(node.getName(), argCount, node.sourceStart(), node.sourceEnd() - 1);
    }

    @Override
    public void enterNamespace(String[] namespace) {
        this.requestor.enterModuleRoot();
        this.requestor.enterNamespace(namespace);
    }

    @Override
    public void exitNamespace() {
        this.requestor.exitNamespace();
        this.requestor.exitModuleRoot();
    }

    @Override
    public void enterType(IElementRequestor.TypeInfo typeInfo) {
        this.requestor.enterType(typeInfo);
    }

    @Override
    public void exitType(int sourceEnd) {
        this.requestor.exitType(sourceEnd);
    }

    @Override
    public void enterMethod(IElementRequestor.MethodInfo methodInfo, Expression identifier, FunctionStatement function, IModelBuilder.IMethod method) {
        this.requestor.enterMethod(methodInfo);
        this.reportTypeRef(method.getType(), methodInfo.declarationStart, methodInfo.returnType != null);
        this.reportTypeRef(method.getThisType(), methodInfo.declarationStart, false);
        for (IModelBuilder.IParameter parameter : method.getParameters()) {
            this.reportTypeRef(parameter.getType(), methodInfo.declarationStart, methodInfo.parameterTypes != null);
        }
    }

    @Override
    public void exitMethod(int sourceEnd) {
        this.requestor.exitMethod(sourceEnd);
    }

    @Override
    public void exitField(int sourceEnd) {
        if (this.elementTypes.pop() == ElementType.FIELD) {
            this.requestor.exitField(sourceEnd);
        }
    }

    @Override
    public void enterField(IElementRequestor.FieldInfo fieldInfo, Expression identifer, JSType type, boolean local) {
        this.elementTypes.push(local ? ElementType.FIELD_LOCAL : ElementType.FIELD);
        if (!local) {
            this.requestor.enterField(fieldInfo);
            this.reportTypeRef(type, fieldInfo.declarationStart, fieldInfo.type != null);
        } else {
            this.requestor.acceptFieldReference(fieldInfo.name, identifer.sourceStart());
        }
    }

    @Override
    public void acceptTypeReference(int position, JSType type) {
        this.reportTypeRef(type, position, false);
    }

    private void reportTypeRef(JSType type, int position, boolean skipSimple) {
        if (type == null || skipSimple && type instanceof SimpleType) {
            return;
        }
        for (String typeName : StructureRequestor.collectContainedTypeNames(type)) {
            this.requestor.acceptTypeReference(StructureRequestor.toShortName(typeName), position);
        }
    }

    public static Collection<String> collectContainedTypeNames(JSType type) {
        HashSet<String> result = null;
        String typeName = StructureRequestor.reportSimpleTypeRef(type);
        if (typeName != null) {
            if (result == null) {
                result = new HashSet<String>();
            }
            result.add(typeName);
        }
        TreeIterator i = type.eAllContents();
        while (i.hasNext()) {
            String typeName2;
            EObject child = (EObject)i.next();
            if (!(child instanceof JSType) || (typeName2 = StructureRequestor.reportSimpleTypeRef((JSType)child)) == null) continue;
            if (result == null) {
                result = new HashSet();
            }
            result.add(typeName2);
        }
        return result != null ? result : Collections.emptyList();
    }

    private static String reportSimpleTypeRef(JSType type) {
        if (type instanceof MapType) {
            return "Object";
        }
        if (type instanceof ArrayType) {
            return "Array";
        }
        if (type instanceof FunctionType) {
            return "Function";
        }
        if (type instanceof SimpleType) {
            Type t = ((SimpleType)type).getTarget();
            return t != null ? t.getName() : null;
        }
        if (type instanceof ClassType) {
            Type t = ((ClassType)type).getTarget();
            return t != null ? t.getName() : null;
        }
        return null;
    }

    private static String toShortName(String name) {
        int slash = name.lastIndexOf(47);
        if (slash >= 0) {
            return name.substring(slash + 1);
        }
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            return name.substring(dot + 1);
        }
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ElementType {
        FIELD,
        FIELD_LOCAL;

    }
}

