/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.javascript.internal.core.RConstructor;
import org.eclipse.dltk.javascript.internal.core.RMethod;
import org.eclipse.dltk.javascript.internal.core.RParameter;
import org.eclipse.dltk.javascript.internal.core.RParameterizedTypeDeclaration;
import org.eclipse.dltk.javascript.internal.core.RProperty;
import org.eclipse.dltk.javascript.internal.core.RTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.IRArrayType;
import org.eclipse.dltk.javascript.typeinfo.IRConstructor;
import org.eclipse.dltk.javascript.typeinfo.IRContextualizableType;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRProperty;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.IRTypeTransformer;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.model.Constructor;
import org.eclipse.dltk.javascript.typeinfo.model.GenericType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterizedType;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSystemImpl
implements ITypeSystem {
    private final Object lock = new Object();
    private final Map<Type, RTypeDeclaration> declarations = new HashMap<Type, RTypeDeclaration>();
    private final Map<ParameterizedTypeKey, RTypeDeclaration> parameterized = new HashMap<ParameterizedTypeKey, RTypeDeclaration>();
    private final List<RParameterizedTypeDeclaration> typeVariables = new ArrayList<RParameterizedTypeDeclaration>();
    private final Map<ContextualizeKey, IRMember> contextualized = new HashMap<ContextualizeKey, IRMember>();
    private Map<Object, Object> values;
    private static final boolean TRACE = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.javascript.core/traceTypeSystem"));

    @Override
    public Type getKnownType(String typeName) {
        return TypeInfoModelLoader.getInstance().getType(typeName);
    }

    @Override
    public Type resolveType(Type type) {
        if (type != null && type.isProxy()) {
            return this.doResolveType(type);
        }
        return type;
    }

    protected Type doResolveType(Type type) {
        String typeName = URI.decode((String)((InternalEObject)type).eProxyURI().fragment());
        Type resolved = TypeInfoModelLoader.getInstance().getType(typeName);
        if (resolved != null) {
            return resolved;
        }
        return type;
    }

    @Override
    public IValue valueOf(IRMember member) {
        return null;
    }

    @Override
    public IRTypeDeclaration convert(Type type) {
        return this.convert0(this.resolveType(type));
    }

    final IRTypeDeclaration convert0(Type type) {
        ITypeSystem preferred = type.getMetaType().getPreferredTypeSystem(type);
        if (preferred != null && preferred != this) {
            return this.convertInPreferred(preferred, type);
        }
        return this.convert1(type);
    }

    private IRTypeDeclaration convertInPreferred(ITypeSystem typeSystem, Type type) {
        if (typeSystem instanceof TypeSystemImpl) {
            return ((TypeSystemImpl)typeSystem).convert1(type);
        }
        return typeSystem.convert(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final IRTypeDeclaration convert1(Type type) {
        Object object = this.lock;
        synchronized (object) {
            return this.convertType(type, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.declarations.clear();
            this.parameterized.clear();
            this.contextualized.clear();
            if (this.values != null) {
                this.values.clear();
            }
        }
    }

    private RTypeDeclaration convertType(Type type, Set<Type> processedTypes) {
        RTypeDeclaration declaration = this.declarations.get(type);
        if (declaration != null) {
            return declaration;
        }
        if (processedTypes == null) {
            processedTypes = new HashSet<Type>();
        } else {
            ITypeSystem preferred = type.getMetaType().getPreferredTypeSystem(type);
            if (preferred != null && preferred != this) {
                return (RTypeDeclaration)this.convertInPreferred(preferred, type);
            }
        }
        if (!processedTypes.add(type)) {
            return null;
        }
        declaration = new RTypeDeclaration(this, type);
        this.declarations.put(type, declaration);
        if (TRACE) {
            this.log("Creating", declaration, "declarations.size=", this.declarations.size());
        }
        this.buildType(declaration, type, type.getAdditionalMembers(null), processedTypes);
        return declaration;
    }

    private void buildType(RTypeDeclaration declaration, Type type, @Nullable Member[] additionalMembers, Set<Type> processedTypes) {
        SimpleType superType = type.getSuperTypeExpr();
        if (superType != null && superType.getTarget() != null) {
            if (superType.getTarget() instanceof GenericType) {
                GenericType generic = (GenericType)superType.getTarget();
                if (superType instanceof ParameterizedType) {
                    declaration.setSuperType(this.parameterizeType(generic, RTypes.convert(this, ((ParameterizedType)superType).getActualTypeArguments())));
                } else if (declaration.isParameterized()) {
                    declaration.setSuperType(this.parameterizeType(generic, declaration.getActualTypeArguments()));
                } else {
                    declaration.setSuperType(this.convertType(generic, processedTypes));
                }
            } else {
                declaration.setSuperType(this.convertType(superType.getTarget(), processedTypes));
            }
        }
        ArrayList<RTypeDeclaration> traits = new ArrayList<RTypeDeclaration>(type.getTraits().size());
        for (Type trait : type.getTraits()) {
            RTypeDeclaration t = this.convertType(trait, processedTypes);
            if (t == null) continue;
            traits.add(t);
        }
        declaration.setTraits(TypeSystemImpl.toImmutableList(traits));
        ArrayList<IRMember> members = new ArrayList<IRMember>(type.getMembers().size() + (additionalMembers != null ? additionalMembers.length : 0));
        for (Member member : type.getMembers()) {
            members.add(this.convertMember(member, declaration));
        }
        if (additionalMembers != null && additionalMembers.length != 0) {
            Member[] memberArray = additionalMembers;
            int n = additionalMembers.length;
            int t = 0;
            while (t < n) {
                Member member;
                member = memberArray[t];
                members.add(this.convertMember(member, declaration));
                ++t;
            }
        }
        declaration.setMembers(TypeSystemImpl.toImmutableList(members));
        ArrayList<IRConstructor> constructors = new ArrayList<IRConstructor>(type.getConstructors().size());
        for (Constructor constructor : type.getConstructors()) {
            constructors.add(this.convertConstructor(constructor, declaration));
        }
        declaration.setConstructors(TypeSystemImpl.toImmutableList(constructors));
        Constructor staticConstructor = type.getStaticConstructor();
        if (staticConstructor != null) {
            declaration.setStaticConstructor(this.convertConstructor(staticConstructor, declaration));
        }
    }

    private static <E> List<E> toImmutableList(List<E> list) {
        return list.isEmpty() ? Collections.emptyList() : list;
    }

    private void log(Object ... args) {
        if (!TRACE) {
            return;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append('[').append(Thread.currentThread().getName()).append("] ");
        sb.append(this.toString());
        sb.append(":");
        boolean space = true;
        int i = 0;
        while (i < args.length) {
            if (space) {
                sb.append(' ');
            }
            Object arg = args[i];
            sb.append(arg);
            space = !(arg instanceof String) || !((String)arg).endsWith("=");
            ++i;
        }
        System.out.println(sb);
    }

    private IRType convert(JSType type) {
        return RTypes.create(this, type);
    }

    @Override
    public IRType getTypeVariable(TypeVariable variable) {
        int i = this.typeVariables.size();
        while (--i >= 0) {
            IRType type = this.typeVariables.get(i).getTypeVariable(variable);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    protected IRMember convertMember(Member member, IRTypeDeclaration declaration) {
        if (member instanceof Method) {
            return this.convertMethod((Method)member, declaration);
        }
        assert (member instanceof Property);
        return this.convertProperty((Property)member, declaration);
    }

    private IRMember convertProperty(Property property, IRTypeDeclaration declaration) {
        if (declaration != null && this.isLazy()) {
            return new RProperty(property, declaration);
        }
        return new RProperty(property, this.convert(property.getType()), declaration);
    }

    private IRMember convertMethod(Method method, IRTypeDeclaration declaration) {
        if (declaration != null && this.isLazy()) {
            return new RMethod(method, declaration);
        }
        return new RMethod(method, this.convert(method.getType()), TypeSystemImpl.convertParameters(this, method.getParameters()), declaration);
    }

    private IRConstructor convertConstructor(Constructor constructor, RTypeDeclaration declaration) {
        return new RConstructor(constructor, (IRTypeDeclaration)declaration);
    }

    public static List<IRParameter> convertParameters(ITypeSystem typeSystem, List<Parameter> parameters) {
        if (parameters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RParameter> result = new ArrayList<RParameter>(parameters.size());
        for (Parameter param : parameters) {
            IRType type = param.getType() != null ? RTypes.create(typeSystem, param.getType()) : RTypes.any();
            result.add(new RParameter(param.getName(), type, param.getKind()));
        }
        return TypeSystemImpl.toImmutableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRTypeDeclaration parameterize(Type target, List<? extends IRType> parameters) {
        if (!((target = this.resolveType(target)) instanceof GenericType)) {
            return this.convert0(target);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.parameterizeType((GenericType)target, parameters);
        }
    }

    private RTypeDeclaration parameterizeType(GenericType genericType, List<? extends IRType> parameters) {
        ParameterizedTypeKey key = new ParameterizedTypeKey(genericType, parameters);
        RTypeDeclaration declaration = this.parameterized.get(key);
        if (declaration != null) {
            return declaration;
        }
        if (TRACE) {
            this.log("Creating", key, "parameterized.size=", this.parameterized.size());
        }
        declaration = new RParameterizedTypeDeclaration(this, genericType, Arrays.asList(key.parameters));
        this.parameterized.put(key, declaration);
        this.typeVariables.add((RParameterizedTypeDeclaration)declaration);
        try {
            this.buildType(declaration, genericType, genericType.getAdditionalMembers(((RParameterizedTypeDeclaration)declaration).getActualTypeArguments()), new HashSet<Type>());
        }
        finally {
            this.typeVariables.remove(this.typeVariables.size() - 1);
        }
        return declaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends IRMember> E contextualize(E member, IRTypeDeclaration declaration) {
        if (!this.isContextualizable(member)) {
            return member;
        }
        ContextualizeKey key = new ContextualizeKey(member, declaration);
        Map<ContextualizeKey, IRMember> map = this.contextualized;
        synchronized (map) {
            IRMember cached = this.contextualized.get(key);
            if (cached != null) {
                return (E)cached;
            }
            E result = this.contextualizeMember(member, declaration);
            this.contextualized.put(key, result);
            if (TRACE) {
                this.log("Contextualized", result, "with", declaration, "contextualized.size=", this.contextualized.size());
            }
            return result;
        }
    }

    private <E extends IRMember> E contextualizeMember(E member, IRTypeDeclaration declaration) {
        IRTypeTransformer transformer = this.newTypeContextualizer(declaration);
        if (member instanceof IRMethod) {
            IRMethod method = (IRMethod)member;
            List<IRParameter> parameters = TypeSystemImpl.transformParameters(method, transformer);
            if (member instanceof IRConstructor) {
                return (E)new RConstructor((Method)member.getSource(), transformer.transform(member.getType()), parameters, member.getDeclaringType());
            }
            return (E)new RMethod((Method)member.getSource(), transformer.transform(member.getType()), parameters, member.getDeclaringType());
        }
        assert (member instanceof IRProperty);
        return (E)new RProperty((Property)member.getSource(), transformer.transform(member.getType()), member.getDeclaringType());
    }

    protected IRTypeTransformer newTypeContextualizer(IRTypeDeclaration declaration) {
        return new TypeContextualizer(declaration);
    }

    private static List<IRParameter> transformParameters(IRMethod method, IRTypeTransformer transformer) {
        if (method.getParameterCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<IRParameter> parameters = new ArrayList<IRParameter>(method.getParameterCount());
        for (IRParameter parameter : method.getParameters()) {
            IRType newType = transformer.transform(parameter.getType());
            if (newType != parameter.getType()) {
                parameters.add(new RParameter(parameter.getName(), newType, parameter.getKind()));
                continue;
            }
            parameters.add(parameter);
        }
        return TypeSystemImpl.toImmutableList(parameters);
    }

    @Override
    public Object getValue(Object key) {
        assert (key != null);
        return this.values != null ? this.values.get(key) : null;
    }

    @Override
    public void setValue(Object key, Object value) {
        assert (key != null);
        if (this.values == null) {
            this.values = new HashMap<Object, Object>();
        }
        this.values.put(key, value);
    }

    protected boolean isContextualizable(IRMember member) {
        if (TypeSystemImpl.isContextualizable(member.getType())) {
            return true;
        }
        if (member instanceof IRMethod) {
            for (IRParameter parameter : ((IRMethod)member).getParameters()) {
                if (!TypeSystemImpl.isContextualizable(parameter.getType())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isContextualizable(IRType type) {
        IRTypeDeclaration declaration;
        if (type == null) {
            return false;
        }
        if (type instanceof IRContextualizableType) {
            return ((IRContextualizableType)((Object)type)).isContextualizable();
        }
        if (type instanceof IRArrayType) {
            return TypeSystemImpl.isContextualizable(((IRArrayType)type).getItemType());
        }
        if (type instanceof IRSimpleType && (declaration = ((IRSimpleType)type).getDeclaration()).isParameterized()) {
            for (IRType typeArgument : declaration.getActualTypeArguments()) {
                if (!TypeSystemImpl.isContextualizable(typeArgument)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ITypeSystem getPrimary() {
        return this;
    }

    protected final boolean isLazy() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeSystemStats stats() {
        Object object = this.lock;
        synchronized (object) {
            return new TypeSystemStats(this.declarations.size(), this.parameterized.size(), this.contextualized.size());
        }
    }

    private static class ContextualizeKey {
        @NonNull
        final IRMember member;
        @NonNull
        final IRTypeDeclaration declaration;

        public ContextualizeKey(@NonNull IRMember member, @NonNull IRTypeDeclaration declaration) {
            this.member = member;
            this.declaration = declaration;
        }

        public int hashCode() {
            return this.member.hashCode() ^ this.declaration.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContextualizeKey) {
                ContextualizeKey other = (ContextualizeKey)obj;
                return this.member.equals(other.member) && this.declaration.equals(other.declaration);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterizedTypeKey {
        final GenericType type;
        final IRType[] parameters;

        public ParameterizedTypeKey(GenericType type, List<? extends IRType> params) {
            this.type = type;
            int expectedParamCount = type.getTypeParameters().size();
            this.parameters = new IRType[expectedParamCount];
            int i = 0;
            while (i < expectedParamCount) {
                IRType t;
                if (i < params.size()) {
                    t = params.get(i);
                    if (t == null) {
                        t = RTypes.none();
                    }
                } else {
                    t = RTypes.none();
                }
                this.parameters[i] = t;
                ++i;
            }
        }

        public int hashCode() {
            return this.type.hashCode() ^ Arrays.hashCode(this.parameters);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ParameterizedTypeKey) {
                ParameterizedTypeKey other = (ParameterizedTypeKey)obj;
                return this.type == other.type && Arrays.equals(this.parameters, other.parameters);
            }
            return false;
        }

        public String toString() {
            StringBuilder parameterizedName = new StringBuilder(this.type.getName().length() + this.parameters.length * 16);
            parameterizedName.append(this.type.getName());
            parameterizedName.append("<");
            int i = 0;
            while (i < this.parameters.length) {
                if (i > 0) {
                    parameterizedName.append(",");
                }
                parameterizedName.append(this.parameters[i].getName());
                ++i;
            }
            parameterizedName.append(">");
            return parameterizedName.toString();
        }
    }

    private class TypeContextualizer
    implements IRTypeTransformer {
        private final IRTypeDeclaration contextType;

        public TypeContextualizer(IRTypeDeclaration declaration) {
            this.contextType = declaration;
        }

        public IRType transform(IRType type) {
            IRContextualizableType c;
            if (type instanceof IRContextualizableType && (c = (IRContextualizableType)((Object)type)).isContextualizable()) {
                return c.contextualize(this.contextType);
            }
            return type != null ? type.transform(this) : null;
        }

        public IRTypeDeclaration transform(IRTypeDeclaration declaration) {
            if (declaration.isParameterized()) {
                boolean createNew = false;
                ArrayList<IRType> typeParams = new ArrayList<IRType>(declaration.getActualTypeArguments());
                ListIterator<IRType> i = typeParams.listIterator();
                while (i.hasNext()) {
                    IRType newType;
                    IRContextualizableType c;
                    IRType type = (IRType)i.next();
                    if (!(type instanceof IRContextualizableType) || !(c = (IRContextualizableType)((Object)type)).isContextualizable() || (newType = c.contextualize(this.contextType)) == type) continue;
                    i.set(newType);
                    createNew = true;
                }
                if (createNew) {
                    return TypeSystemImpl.this.parameterize(declaration.getSource(), typeParams);
                }
            }
            return declaration;
        }
    }

    public static class TypeSystemStats {
        private final int declarationCount;
        private final int parameterizedCount;
        private final int contextualizedCount;

        public TypeSystemStats(int declarationCount, int parameterizedCount, int contextualizedCount) {
            this.declarationCount = declarationCount;
            this.parameterizedCount = parameterizedCount;
            this.contextualizedCount = contextualizedCount;
        }

        public int declarationCount() {
            return this.declarationCount;
        }

        public int parameterizedCount() {
            return this.parameterizedCount;
        }

        public int contextualizedCount() {
            return this.contextualizedCount;
        }

        public boolean isEmpty() {
            return this.declarationCount == 0 && this.parameterizedCount == 0 && this.contextualizedCount == 0;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "[declarationCount=" + this.declarationCount + ",parameterizedCount=" + this.parameterizedCount + ",contextualizedCount=" + this.contextualizedCount + "]";
        }
    }
}

