/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeAlias;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelResourceSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfoModelLoader {
    private static TypeInfoModelLoader instance = null;
    private final TypeInfoModelResourceSet resourceSet = TypeInfoManager.loadModelResources();

    public static synchronized TypeInfoModelLoader getInstance() {
        if (instance == null) {
            instance = new TypeInfoModelLoader();
        }
        return instance;
    }

    private TypeInfoModelLoader() {
    }

    private Resource[] getResources() {
        return this.resourceSet.resources();
    }

    public Type getType(String typeName) {
        return this.getType(typeName, false);
    }

    public Type getType(String typeName, boolean all) {
        return this.resourceSet.getType(typeName, all);
    }

    public String translateTypeName(String typeName) {
        Resource[] resourceArray = this.getResources();
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            for (EObject object : resource.getContents()) {
                TypeAlias alias;
                if (!(object instanceof TypeAlias) || !typeName.equals((alias = (TypeAlias)object).getSource())) continue;
                if (alias.getTarget() == null) break;
                return alias.getTarget().getName();
            }
            ++n2;
        }
        return typeName;
    }

    public Set<String> listTypes(String prefix) {
        return this.resourceSet.listTypes(prefix);
    }

    public Set<String> listTypeLiterals(String prefix) {
        return this.resourceSet.listTypeLiterals(prefix);
    }

    public Member getMember(String memberName) {
        Resource[] resourceArray = this.getResources();
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            for (EObject object : resource.getContents()) {
                Member member;
                if (!(object instanceof Member) || !memberName.equals((member = (Member)object).getName())) continue;
                return member;
            }
            ++n2;
        }
        return null;
    }

    public Type getTypeLiteral(String name) {
        return this.resourceSet.getTypeLiteral(name);
    }

    public Set<Member> listMembers(String prefix) {
        HashSet<Member> result = new HashSet<Member>();
        Resource[] resourceArray = this.getResources();
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            for (EObject object : resource.getContents()) {
                Member member;
                if (!(object instanceof Member) || !CharOperation.prefixEquals((String)prefix, (String)(member = (Member)object).getName())) continue;
                result.add(member);
            }
            ++n2;
        }
        return result;
    }

    public boolean hasResource(Resource resource) {
        return this.resourceSet.getResources().contains((Object)resource);
    }

    public Resource getResource(URI uri) {
        return this.resourceSet.getResource(uri, false);
    }

    public void initializeURIMap(ResourceSet resourceSet) {
        resourceSet.getURIConverter().getURIMap().putAll(this.resourceSet.getURIConverter().getURIMap());
    }

    public EObject getEObject(URI uri) {
        return this.resourceSet.getEObject(uri, false);
    }
}

