/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core;

import java.util.List;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.javascript.internal.core.RTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.model.GenericType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariable;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RParameterizedTypeDeclaration
extends RTypeDeclaration
implements ITypeSystem {
    private final List<IRType> typeArguments;

    public RParameterizedTypeDeclaration(ITypeSystem typeSystem, GenericType type, List<IRType> typeArguments) {
        super(typeSystem, type);
        this.typeArguments = typeArguments;
    }

    @Override
    protected ITypeSystem getEffectiveTypeSystem() {
        return this;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public boolean isParameterized() {
        return true;
    }

    @Override
    public List<IRType> getActualTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSource().getName());
        sb.append('<');
        for (IRType type : this.getActualTypeArguments()) {
            sb.append(type.getName());
        }
        sb.append('>');
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RParameterizedTypeDeclaration other = (RParameterizedTypeDeclaration)obj;
        return this.type.equals(other.type) && this.typeArguments.equals(other.typeArguments);
    }

    @Override
    public TypeCompatibility isAssignableFrom(IRTypeDeclaration declaration) {
        if (declaration instanceof RParameterizedTypeDeclaration) {
            RParameterizedTypeDeclaration other = (RParameterizedTypeDeclaration)declaration;
            if (this.type.equals(other.type)) {
                return RParameterizedTypeDeclaration.isAssignableFrom(this.typeArguments, other.typeArguments) ? TypeCompatibility.TRUE : TypeCompatibility.UNPARAMETERIZED;
            }
        }
        return super.isAssignableFrom(declaration);
    }

    @Override
    protected boolean _equals(RTypeDeclaration other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.type.equals(other.type)) {
            if (other instanceof RParameterizedTypeDeclaration) {
                return RParameterizedTypeDeclaration.isAssignableFrom(this.typeArguments, ((RParameterizedTypeDeclaration)other).typeArguments);
            }
            return true;
        }
        return false;
    }

    private static boolean isAssignableFrom(List<IRType> dest, List<IRType> src) {
        if (dest.size() == src.size()) {
            int i = 0;
            while (i < dest.size()) {
                if (dest.get(i).isAssignableFrom(src.get(i)) != TypeCompatibility.TRUE) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public Type getKnownType(String typeName) {
        return this.typeSystem.getKnownType(typeName);
    }

    @Override
    public Type resolveType(Type type) {
        return this.typeSystem.resolveType(type);
    }

    @Override
    public IValue valueOf(IRMember member) {
        return this.typeSystem.valueOf(member);
    }

    @Override
    public IRTypeDeclaration convert(Type type) {
        return this.typeSystem.convert(type);
    }

    @Override
    public <E extends IRMember> E contextualize(E member, IRTypeDeclaration type) {
        return this.typeSystem.contextualize(member, type);
    }

    @Override
    public IRTypeDeclaration parameterize(Type target, List<? extends IRType> parameters) {
        return this.typeSystem.parameterize(target, parameters);
    }

    @Override
    public IRType getTypeVariable(TypeVariable variable) {
        EList<TypeVariable> vars = ((GenericType)this.getSource()).getTypeParameters();
        int i = 0;
        int size = vars.size();
        while (i < size) {
            if (vars.get(i) == variable) {
                return this.typeArguments.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public Object getValue(Object key) {
        return this.typeSystem.getValue(key);
    }

    @Override
    public void setValue(Object key, Object value) {
        this.typeSystem.setValue(key, value);
    }

    @Override
    public ITypeSystem getPrimary() {
        return this.typeSystem;
    }
}

