/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IProjectChange;
import org.eclipse.dltk.internal.core.builder.Messages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildChange
implements IProjectChange {
    protected final IProgressMonitor monitor;
    protected final IProject project;
    private IScriptProject scriptProject = null;
    private static final int ADD_OR_CHANGE = 3;
    private int checkCounter = 0;
    protected static final IProjectChange[] NO_PROJECT_CHANGES = new IProjectChange[0];

    public AbstractBuildChange(IProject project, IProgressMonitor monitor) {
        this.project = project;
        this.monitor = monitor;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IScriptProject getScriptProject() {
        if (this.scriptProject == null) {
            this.scriptProject = DLTKCore.create(this.project);
        }
        return this.scriptProject;
    }

    protected static int validateFlags(int options, int allowedOptions) {
        if ((options | allowedOptions) != allowedOptions) {
            throw new IllegalArgumentException("Wrong options 0x" + Integer.toHexString(options) + ", allowed options 0x" + Integer.toHexString(allowedOptions));
        }
        if ((allowedOptions & 3) == 3 && (options & 3) == 0) {
            options |= 3;
        }
        return options;
    }

    protected static boolean checkFlag(int options, int mask) {
        return (options & mask) != 0;
    }

    protected static boolean wantRenames(int options) {
        return !AbstractBuildChange.checkFlag(options, 8);
    }

    protected void locateSourceModules(Collection<IFile> resources, Collection<ISourceModule> sourceModules, Collection<IFile> realResources) {
        this.getScriptProject();
        int remainingWork = resources.size();
        for (IFile file : resources) {
            this.checkCanceled();
            this.monitor.subTask(NLS.bind((String)Messages.ScriptBuilder_Locating_source_modules, (Object)String.valueOf(remainingWork), (Object)file.getName()));
            IModelElement element = DLTKCore.create(file);
            if (element != null && element.getElementType() == 5 && element.exists() && this.scriptProject.isOnBuildpath(element)) {
                sourceModules.add((ISourceModule)element);
            } else {
                realResources.add(file);
            }
            --remainingWork;
        }
    }

    protected final void checkCanceled() {
        if ((this.checkCounter++ & 0xFF) == 0 && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected static <T> List<T> unmodifiableList(List<T> input) {
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(input);
    }

    protected static <T> Set<T> unmodifiableSet(Set<T> input) {
        if (input.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(input);
    }

    public boolean isOnBuildpath(IResource resource) {
        return this.getScriptProject().isOnBuildpath(resource);
    }
}

