/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.codeassist.ICompletionEngine;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.keyword.IKeywordCategory;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.javascript.core.JSKeywordCategory;
import org.eclipse.dltk.javascript.core.JSKeywordManager;
import org.eclipse.dltk.javascript.internal.core.codeassist.JSCompletionEngine;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.templates.JSDocTemplateCompletionProcessor;
import org.eclipse.dltk.javascript.internal.ui.text.JSDocTextUtils;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptCompletionProposalCollector;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.templates.ScriptTemplateProposal;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposalComputer;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDocCompletionProposalComputer
implements IScriptCompletionProposalComputer {
    private static final char JSDOC_MEMBER_SEPARATOR = '#';

    public void sessionStarted() {
    }

    public void sessionEnded() {
    }

    /*
     * Unable to fully structure code
     */
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        document = context.getDocument();
        try {
            block19: {
                block18: {
                    region = JSDocTextUtils.getLineRegion(document, context.getInvocationOffset());
                    line = document.get(region.getOffset(), region.getLength()).toCharArray();
                    offsetInLine = context.getInvocationOffset() - region.getOffset();
                    tagName = JSDocTextUtils.getTag(line, 0, offsetInLine);
                    if (tagName == null) {
                        return Collections.emptyList();
                    }
                    if (tagName.end == offsetInLine) {
                        return this.completionOnTag(context, tagName.value());
                    }
                    index = tagName.end;
                    while (index < offsetInLine && Character.isWhitespace(line[index])) {
                        ++index;
                    }
                    if ("@see".equals(tagName.value())) {
                        valueStart = index;
                        while (index < offsetInLine) {
                            if (Character.isWhitespace(line[index])) {
                                return Collections.emptyList();
                            }
                            ++index;
                        }
                        return this.completionAfterSee(context, new String(line, valueStart, index - valueStart));
                    }
                    depth = 0;
                    nameStart = index;
                    breakOnSpace = false;
                    if (index >= offsetInLine || line[index] != '{') break block18;
                    depth = 1;
                    nameStart = ++index;
                    ** GOTO lbl50
                }
                if (!"@type".equals(tagName.value())) break block19;
                breakOnSpace = true;
                if (true) ** GOTO lbl50
            }
            return Collections.emptyList();
            do {
                if (line[index] == '}') {
                    if (--depth <= 0) {
                        return Collections.emptyList();
                    }
                } else if (line[index] == '{') {
                    ++depth;
                } else if (line[index] == '<' || line[index] == '>' || line[index] == '(' || line[index] == ':' || line[index] == ',' || line[index] == '|') {
                    nameStart = index + 1;
                } else if (breakOnSpace && Character.isWhitespace(line[index])) {
                    return Collections.emptyList();
                }
                ++index;
lbl50:
                // 3 sources

            } while (index < offsetInLine);
            if (index == offsetInLine) {
                return this.completionOnType(context, new String(line, nameStart, index - nameStart));
            }
        }
        catch (BadLocationException e) {
            JavaScriptUI.log(e);
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> completionAfterSee(ContentAssistInvocationContext context, String prefix) {
        if (!(context instanceof ScriptContentAssistInvocationContext)) {
            return Collections.emptyList();
        }
        int pos = prefix.indexOf(35);
        if (pos < 0) {
            return this.completionOnType(context, prefix);
        }
        JSCompletionEngine engine = this.getCompletionEngine();
        if (engine == null) {
            return Collections.emptyList();
        }
        ISourceModule module = ((ScriptContentAssistInvocationContext)context).getSourceModule();
        JavaScriptCompletionProposalCollector collector = new JavaScriptCompletionProposalCollector(module);
        collector.setInvocationContext((ScriptContentAssistInvocationContext)context);
        engine.setRequestor((CompletionRequestor)collector);
        collector.setAttribute(TypeMode.JSDOC, Boolean.TRUE);
        String typeName = prefix.substring(0, pos);
        if (typeName.length() != 0) {
            TypeInferencer2 inferencer2 = new TypeInferencer2();
            inferencer2.setModelElement((IModelElement)module);
            Type type = inferencer2.getType(typeName);
            if (type == null || type.getKind() == TypeKind.UNKNOWN) {
                return Collections.emptyList();
            }
            engine.completeMembers(module, prefix.substring(pos + 1), context.getInvocationOffset(), true, (Iterable)inferencer2.convert(type).getMembers());
            return Arrays.asList(collector.getScriptCompletionProposals());
        }
        collector.setIgnored(2, true);
        collector.setIgnored(7, true);
        engine.setGlobalOptions(0);
        engine.completeGlobals(module, prefix.substring(1), context.getInvocationOffset(), true);
        return Arrays.asList(collector.getScriptCompletionProposals());
    }

    private List<ICompletionProposal> completionOnTag(ContentAssistInvocationContext context, String tag) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        JSDocTemplateCompletionProcessor processor = new JSDocTemplateCompletionProcessor((ScriptContentAssistInvocationContext)context);
        Collections.addAll(proposals, processor.computeCompletionProposals(context.getViewer(), context.getInvocationOffset()));
        HashSet tags = new HashSet();
        Collections.addAll(tags, JSDocTag.getTags());
        ISourceModule module = context instanceof ScriptContentAssistInvocationContext ? ((ScriptContentAssistInvocationContext)context).getSourceModule() : null;
        Collections.addAll(tags, JSKeywordManager.getInstance().getKeywords((IKeywordCategory)JSKeywordCategory.JS_DOC_TAG, module));
        tags.remove("@returns");
        HashSet<String> usedTags = new HashSet<String>();
        for (ICompletionProposal proposal : proposals) {
            if (!(proposal instanceof ScriptTemplateProposal)) continue;
            usedTags.add(((ScriptTemplateProposal)proposal).getTemplateName());
        }
        for (String jsdocTag : tags) {
            if (!CharOperation.prefixEquals((String)tag, (String)jsdocTag) || usedTags.contains(jsdocTag)) continue;
            proposals.add((ICompletionProposal)new ScriptCompletionProposal(String.valueOf(jsdocTag) + ' ', context.getInvocationOffset() - tag.length(), tag.length(), DLTKPluginImages.get((String)"org.eclipse.dltk.ui.jdoc_tag_obj.gif"), jsdocTag, 90, true));
        }
        return proposals;
    }

    private List<ICompletionProposal> completionOnType(ContentAssistInvocationContext context, String prefix) {
        JSCompletionEngine engine;
        if (context instanceof ScriptContentAssistInvocationContext && (engine = this.getCompletionEngine()) != null) {
            ISourceModule module = ((ScriptContentAssistInvocationContext)context).getSourceModule();
            JavaScriptCompletionProposalCollector collector = new JavaScriptCompletionProposalCollector(module);
            collector.setAttribute(TypeMode.JSDOC, Boolean.TRUE);
            collector.setInvocationContext((ScriptContentAssistInvocationContext)context);
            engine.setRequestor((CompletionRequestor)collector);
            engine.completeTypes(module, TypeMode.JSDOC, prefix.trim(), context.getInvocationOffset());
            return Arrays.asList(collector.getScriptCompletionProposals());
        }
        return Collections.emptyList();
    }

    private JSCompletionEngine getCompletionEngine() {
        ICompletionEngine[] engines = DLTKLanguageManager.getCompletionEngines((String)"org.eclipse.dltk.javascript.core.nature");
        if (engines != null) {
            ICompletionEngine[] iCompletionEngineArray = engines;
            int n = engines.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionEngine engine = iCompletionEngineArray[n2];
                if (engine instanceof JSCompletionEngine) {
                    return (JSCompletionEngine)engine;
                }
                ++n2;
            }
        }
        return null;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }
}

