/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentChangedListener;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IEnvironmentChangedListener;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.dialogs.ControlStatus;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.dltk.ui.viewsupport.BasicElementLabels;
import org.eclipse.dltk.ui.wizards.ControlDecorationManager;
import org.eclipse.dltk.ui.wizards.IControlDecorationManager;
import org.eclipse.dltk.ui.wizards.ILocationGroup;
import org.eclipse.dltk.ui.wizards.IProjectWizard;
import org.eclipse.dltk.ui.wizards.IProjectWizardInitializer;
import org.eclipse.dltk.ui.wizards.IProjectWizardPage;
import org.eclipse.dltk.ui.wizards.ProjectWizard;
import org.eclipse.dltk.ui.wizards.WorkingSetDetector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WorkingSetConfigurationBlock;

public abstract class ProjectWizardFirstPage
extends WizardPage
implements ILocationGroup,
IProjectWizardPage {
    public static final String ATTR_EXTERNAL_BROWSE_LOCATION = "org.eclipse.dltk.ui.external.browse.location.";
    private ControlDecorationManager fDecorationManager;
    protected NameGroup fNameGroup;
    protected LocationGroup fLocationGroup;
    protected DetectGroup fDetectGroup;
    private Validator fValidator;
    protected String fInitialName;
    private IWorkingSetGroup fWorkingSetGroup;
    public static final String PAGE_NAME = "ProjectWizardFirstPage";
    private IInterpreterGroup fInterpreterGroup;

    protected IStatus validateProject() {
        String name = this.fNameGroup.getName();
        if (name.length() == 0) {
            return new StatusInfo(0, NewWizardMessages.ScriptProjectWizardFirstPage_Message_enterProjectName);
        }
        IWorkspace workspace = DLTKUIPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(name, 4);
        if (!nameStatus.isOK()) {
            return nameStatus;
        }
        IProject handle = this.getProjectHandle();
        if (handle.exists()) {
            return new StatusInfo(4, NewWizardMessages.ScriptProjectWizardFirstPage_Message_projectAlreadyExists);
        }
        IPath projectLocation = workspace.getRoot().getLocation().append(name);
        if (projectLocation.toFile().exists()) {
            try {
                String canonicalPath = projectLocation.toFile().getCanonicalPath();
                projectLocation = new Path(canonicalPath);
            }
            catch (IOException e) {
                DLTKUIPlugin.log(e);
            }
            String existingName = projectLocation.lastSegment();
            if (!existingName.equals(this.fNameGroup.getName())) {
                return new StatusInfo(4, NLS.bind((String)NewWizardMessages.ScriptProjectWizardFirstPage_Message_invalidProjectNameForWorkspaceRoot, (Object)BasicElementLabels.getResourceName(existingName)));
            }
        }
        return null;
    }

    protected boolean isValidProject() {
        return this.validateProject() == null;
    }

    public ProjectWizardFirstPage() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewWizardMessages.ScriptProjectWizardFirstPage_page_title);
        this.setDescription(NewWizardMessages.ScriptProjectWizardFirstPage_page_description);
        this.fInitialName = "";
    }

    public void setName(String name) {
        this.fInitialName = name;
        if (this.fNameGroup != null) {
            this.fNameGroup.setName(name);
        }
    }

    public boolean isInterpretersPresent() {
        return this.fInterpreterGroup.isInterpreterPresent();
    }

    public final String getScriptNature() {
        return ((ProjectWizard)this.getWizard()).getScriptNature();
    }

    protected boolean interpeterRequired() {
        return true;
    }

    protected boolean supportInterpreter() {
        return true;
    }

    protected IInterpreterGroup createInterpreterGroup(Composite parent) {
        return new DefaultInterpreterGroup(parent, new DefaultInterpreterGroupOption[0]);
    }

    protected IInterpreterGroup getInterpreterGroup() {
        return this.fInterpreterGroup;
    }

    protected void handlePossibleInterpreterChange() {
        if (this.fInterpreterGroup != null) {
            this.fInterpreterGroup.handlePossibleInterpreterChange();
        }
    }

    protected Observable getInterpreterGroupObservable() {
        if (this.fInterpreterGroup instanceof Observable) {
            return (Observable)((Object)this.fInterpreterGroup);
        }
        return null;
    }

    public IInterpreterInstall getInterpreter() {
        return this.fInterpreterGroup != null ? this.fInterpreterGroup.getSelectedInterpreter() : null;
    }

    public void createControl(Composite parent) {
        IProjectWizardInitializer.IProjectWizardState state;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        this.fNameGroup = new NameGroup(composite, this.fInitialName);
        this.fLocationGroup = this.createLocationGroup();
        this.fLocationGroup.createControls(composite);
        this.fLocationGroup.initialize();
        this.fLocationGroup.refreshControls();
        this.fInterpreterGroup = this.supportInterpreter() ? this.createInterpreterGroup(composite) : null;
        this.createCustomGroups(composite);
        this.getWorkingSetGroup().createControl(composite);
        this.fDetectGroup = new DetectGroup(composite);
        this.fNameGroup.addObserver(this.fLocationGroup);
        this.fLocationGroup.addObserver(this.fDetectGroup);
        this.fNameGroup.notifyObservers();
        this.fValidator = new Validator();
        this.fDecorationManager = new ControlDecorationManager();
        Observable interpreterGroupObservable = this.getInterpreterGroupObservable();
        if (this.supportInterpreter() && interpreterGroupObservable != null) {
            interpreterGroupObservable.addObserver(this.fValidator);
            this.handlePossibleInterpreterChange();
        }
        this.fNameGroup.addObserver(this.fValidator);
        this.fLocationGroup.addObserver(this.fValidator);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
        if ((state = this.getWizardState()).getProjectName() != null) {
            this.setName(state.getProjectName());
        }
    }

    protected final IWorkingSetGroup getWorkingSetGroup() {
        if (this.fWorkingSetGroup == null) {
            this.fWorkingSetGroup = this.createWorkingSetGroup();
        }
        return this.fWorkingSetGroup;
    }

    protected IWorkingSetGroup createWorkingSetGroup() {
        return new WorkingSetGroup();
    }

    protected WorkingSetDetector createWorkingSetDetector() {
        return new WorkingSetDetector();
    }

    protected LocationGroup createLocationGroup() {
        return new LocationGroup();
    }

    protected void createCustomGroups(Composite composite) {
    }

    public URI getLocationURI() {
        IEnvironment environment = this.getEnvironment();
        return environment.getURI(this.fLocationGroup.getLocation());
    }

    public IEnvironment getEnvironment() {
        return this.fLocationGroup.getEnvironment();
    }

    public IPath getLocation() {
        return this.fLocationGroup.getLocation();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNameGroup.getName());
    }

    public boolean isInWorkspace() {
        return this.fLocationGroup.isInWorkspace();
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public boolean getDetect() {
        return this.isExistingLocation();
    }

    public boolean isExistingLocation() {
        return this.fDetectGroup.mustDetect();
    }

    public boolean isSrc() {
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fNameGroup.postSetFocus();
        }
    }

    public void dispose() {
        this.fDecorationManager.dispose();
        this.fLocationGroup.dispose();
        super.dispose();
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    public IWorkingSet[] getWorkingSets() {
        return this.getWorkingSetGroup().getSelectedWorkingSets();
    }

    public void setWorkingSets(IWorkingSet[] workingSets) {
        Assert.isLegal((workingSets != null ? 1 : 0) != 0);
        this.getWorkingSetGroup().setWorkingSets(workingSets);
    }

    public void initProjectWizardPage() {
        IProjectWizard wizard = (IProjectWizard)this.getWizard();
        this.setWorkingSets(this.createWorkingSetDetector().detect(wizard.getSelection(), wizard.getWorkbench()));
    }

    public void updateProjectWizardPage() {
    }

    public void resetProjectWizardPage() {
    }

    protected final IProjectWizardInitializer.IProjectWizardState getWizardState() {
        return ((ProjectWizard)this.getWizard()).getWizardState();
    }

    protected abstract class AbstractInterpreterGroup
    extends Observable
    implements Observer,
    SelectionListener,
    IDialogFieldListener,
    IInterpreterGroup {
        protected final SelectionButtonDialogField fUseDefaultInterpreter;
        protected final SelectionButtonDialogField fUseProjectInterpreter;
        protected final ComboDialogField fInterpreterCombo;
        private final Group fGroup;
        private String[] fComplianceLabels;
        private final Link fPreferenceLink;
        private IInterpreterInstall[] fInstalledInterpreters;
        private boolean interpretersPresent;

        public AbstractInterpreterGroup(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            GridLayout groupLayout = ProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true);
            groupLayout.marginHeight /= 2;
            this.fGroup.setLayout((Layout)groupLayout);
            this.fGroup.setText(NewWizardMessages.ScriptProjectWizardFirstPage_InterpreterEnvironmentGroup_title);
            this.fUseDefaultInterpreter = new SelectionButtonDialogField(16);
            this.fUseDefaultInterpreter.setLabelText(this.getDefaultInterpreterLabel());
            this.fUseDefaultInterpreter.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fUseDefaultInterpreter.setDialogFieldListener(this);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setFont(this.fGroup.getFont());
            this.fPreferenceLink.setText(NewWizardMessages.ScriptProjectWizardFirstPage_InterpreterEnvironmentGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 2, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            this.fUseProjectInterpreter = new SelectionButtonDialogField(16);
            this.fUseProjectInterpreter.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_InterpreterEnvironmentGroup_specific_compliance);
            this.fUseProjectInterpreter.doFillIntoGrid((Composite)this.fGroup, 1);
            this.fUseProjectInterpreter.setDialogFieldListener(this);
            this.fInterpreterCombo = new ComboDialogField(8);
            this.fillInstalledInterpreters(this.fInterpreterCombo);
            this.fInterpreterCombo.setDialogFieldListener(this);
            Combo comboControl = this.fInterpreterCombo.getComboControl((Composite)this.fGroup);
            GridData gridData = new GridData(1, 2, true, false);
            gridData.minimumWidth = 100;
            comboControl.setLayoutData((Object)gridData);
            comboControl.setVisibleItemCount(20);
            this.fUseDefaultInterpreter.setSelection(true);
            this.fInterpreterCombo.setEnabled(this.fUseProjectInterpreter.isSelected());
        }

        protected final IEnvironment getEnvironment() {
            return ProjectWizardFirstPage.this.fLocationGroup.getEnvironment();
        }

        private void fillInstalledInterpreters(ComboDialogField comboField) {
            String selectedItem = null;
            int selectionIndex = -1;
            if (this.fUseProjectInterpreter.isSelected() && (selectionIndex = comboField.getSelectionIndex()) != -1) {
                selectedItem = comboField.getItems()[selectionIndex];
            }
            this.fInstalledInterpreters = this.getWorkspaceInterpeters();
            selectionIndex = -1;
            this.fComplianceLabels = new String[this.fInstalledInterpreters.length];
            int i = 0;
            while (i < this.fInstalledInterpreters.length) {
                this.fComplianceLabels[i] = this.fInstalledInterpreters[i].getName();
                if (selectedItem != null && this.fComplianceLabels[i].equals(selectedItem)) {
                    selectionIndex = i;
                }
                ++i;
            }
            comboField.setItems(this.fComplianceLabels);
            if (selectionIndex == -1) {
                this.fInterpreterCombo.selectItem(this.getDefaultInterpreterName());
            } else {
                this.fInterpreterCombo.selectItem(selectedItem);
            }
            this.interpretersPresent = this.fInstalledInterpreters.length > 0;
        }

        private IInterpreterInstall[] getWorkspaceInterpeters() {
            ArrayList<InterpreterStandin> standins = new ArrayList<InterpreterStandin>();
            IInterpreterInstallType[] types = ScriptRuntime.getInterpreterInstallTypes((String)this.getCurrentLanguageNature());
            IEnvironment environment = this.getEnvironment();
            int i = 0;
            while (i < types.length) {
                IInterpreterInstallType type = types[i];
                IInterpreterInstall[] installs = type.getInterpreterInstalls();
                int j = 0;
                while (j < installs.length) {
                    IInterpreterInstall install = installs[j];
                    String envId = install.getEnvironmentId();
                    if (envId != null && envId.equals(environment.getId())) {
                        standins.add(new InterpreterStandin(install));
                    }
                    ++j;
                }
                ++i;
            }
            return standins.toArray(new IInterpreterInstall[standins.size()]);
        }

        private String getDefaultInterpreterName() {
            IInterpreterInstall inst = ScriptRuntime.getDefaultInterpreterInstall((String)this.getCurrentLanguageNature(), (IEnvironment)this.getEnvironment());
            if (inst != null) {
                return inst.getName();
            }
            return "undefined";
        }

        private String getDefaultInterpreterLabel() {
            return Messages.format(NewWizardMessages.ScriptProjectWizardFirstPage_InterpreterEnvironmentGroup_default_compliance, this.getDefaultInterpreterName());
        }

        public void update(Observable o, Object arg) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            if (ProjectWizardFirstPage.this.fDetectGroup == null) {
                return;
            }
            boolean detect = ProjectWizardFirstPage.this.fDetectGroup.mustDetect() && this.interpretersPresent;
            this.fUseDefaultInterpreter.setEnabled(!detect);
            this.fUseProjectInterpreter.setEnabled(!detect);
            this.fInterpreterCombo.setEnabled(!detect && this.fUseProjectInterpreter.isSelected());
            this.fPreferenceLink.setEnabled(!detect);
            this.fGroup.setEnabled(!detect);
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        void showInterpreterPreferencePage() {
            String pageId = this.getIntereprtersPreferencePageId();
            if (pageId == null) {
                return;
            }
            PreferencesUtil.createPreferenceDialogOn((Shell)ProjectWizardFirstPage.this.getShell(), (String)pageId, (String[])new String[]{pageId}, null).open();
        }

        protected String getIntereprtersPreferencePageId() {
            IDLTKUILanguageToolkit languageToolkit = DLTKUILanguageManager.getLanguageToolkit(this.getCurrentLanguageNature());
            if (languageToolkit != null) {
                return languageToolkit.getInterpreterPreferencePage();
            }
            return null;
        }

        protected final String getCurrentLanguageNature() {
            return ProjectWizardFirstPage.this.getScriptNature();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.showInterpreterPreferencePage();
            this.handlePossibleInterpreterChange();
            this.updateEnableState();
        }

        public void handlePossibleInterpreterChange() {
            this.refreshInterpreters();
        }

        private void refreshInterpreters() {
            this.fUseDefaultInterpreter.setLabelText(this.getDefaultInterpreterLabel());
            this.fillInstalledInterpreters(this.fInterpreterCombo);
            this.setChanged();
            this.notifyObservers();
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fUseDefaultInterpreter || field == this.fUseProjectInterpreter) {
                this.setChanged();
                this.notifyObservers();
            }
            this.updateEnableState();
        }

        public boolean isUseSpecific() {
            return this.fUseProjectInterpreter.isSelected();
        }

        public IInterpreterInstall getSelectedInterpreter() {
            int index;
            if (this.fUseProjectInterpreter.isSelected() && (index = this.fInterpreterCombo.getSelectionIndex()) >= 0 && index < this.fComplianceLabels.length) {
                return this.fInstalledInterpreters[index];
            }
            return null;
        }

        public boolean isInterpreterPresent() {
            return this.interpretersPresent;
        }

        public Control getDecorationTarget() {
            if (this.fUseDefaultInterpreter.isSelected()) {
                return this.fUseDefaultInterpreter.getSelectionButton();
            }
            return this.fUseProjectInterpreter.getSelectionButton();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultInterpreterGroup
    extends AbstractInterpreterGroup {
        public DefaultInterpreterGroup(Composite composite, DefaultInterpreterGroupOption ... options) {
            this(composite, Arrays.asList(options));
        }

        private DefaultInterpreterGroup(Composite composite, List<DefaultInterpreterGroupOption> options) {
            super(composite);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DefaultInterpreterGroupOption {
        NONE;

    }

    protected final class DetectGroup
    extends Observable
    implements Observer,
    SelectionListener {
        private final Link fHintText;
        private Label fIcon;
        private boolean fDetect;

        public DetectGroup(Composite parent) {
            Composite composite = new Composite(parent, 64);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            this.fIcon = new Label(composite, 16384);
            GridData gd = new GridData(16384, 0x1000000, false, false);
            this.fIcon.setLayoutData((Object)gd);
            this.fHintText = new Link(composite, 64);
            this.fHintText.setFont(parent.getFont());
            this.fHintText.addSelectionListener((SelectionListener)this);
            gd = new GridData(4, 4, true, true);
            gd.widthHint = ProjectWizardFirstPage.this.convertWidthInCharsToPixels(50);
            gd.heightHint = ProjectWizardFirstPage.this.convertHeightInCharsToPixels(3);
            this.fHintText.setLayoutData((Object)gd);
            if (ProjectWizardFirstPage.this.supportInterpreter()) {
                ProjectWizardFirstPage.this.handlePossibleInterpreterChange();
            }
        }

        private boolean isValidProjectName(String name) {
            if (name.length() == 0) {
                return false;
            }
            IWorkspace workspace = DLTKUIPlugin.getWorkspace();
            return workspace.validateName(name, 4).isOK() && workspace.getRoot().findMember(name) == null;
        }

        private boolean computeDetectState() {
            IPath location = ProjectWizardFirstPage.this.fLocationGroup.getLocation();
            if (ProjectWizardFirstPage.this.fLocationGroup.isInWorkspace()) {
                if (!this.isValidProjectName(ProjectWizardFirstPage.this.getProjectName())) {
                    return false;
                }
                IEnvironment environment = EnvironmentManager.getLocalEnvironment();
                IFileHandle directory = environment.getFile(location.append(ProjectWizardFirstPage.this.getProjectName()));
                return directory.isDirectory();
            }
            IEnvironment environment = ProjectWizardFirstPage.this.fLocationGroup.getEnvironment();
            if (!location.isEmpty()) {
                IFileHandle directory = environment.getFile(location);
                return directory.isDirectory();
            }
            return false;
        }

        public void update(Observable o, Object arg) {
            if (o instanceof LocationGroup) {
                boolean oldDetectState = this.fDetect;
                this.fDetect = this.computeDetectState();
                if (oldDetectState != this.fDetect) {
                    this.setChanged();
                    this.notifyObservers();
                    if (this.fDetect) {
                        this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                        this.fIcon.setVisible(true);
                        this.fHintText.setVisible(true);
                        this.fHintText.setText(NewWizardMessages.ScriptProjectWizardFirstPage_DetectGroup_message);
                        this.fHintText.getParent().layout();
                    } else {
                        this.fIcon.setVisible(false);
                        this.fHintText.setVisible(false);
                    }
                    if (ProjectWizardFirstPage.this.supportInterpreter()) {
                        ProjectWizardFirstPage.this.handlePossibleInterpreterChange();
                    }
                }
            }
        }

        public boolean mustDetect() {
            return this.fDetect;
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (DLTKCore.DEBUG) {
                System.err.println("DetectGroup show compilancePreferencePage...");
            }
            if (ProjectWizardFirstPage.this.supportInterpreter()) {
                ProjectWizardFirstPage.this.handlePossibleInterpreterChange();
            }
        }
    }

    protected static interface IInterpreterGroup {
        public IInterpreterInstall getSelectedInterpreter();

        public void handlePossibleInterpreterChange();

        public boolean isInterpreterPresent();

        public Control getDecorationTarget();
    }

    protected static interface IWorkingSetGroup {
        public void createControl(Composite var1);

        public IWorkingSet[] getSelectedWorkingSets();

        public void setWorkingSets(IWorkingSet[] var1);
    }

    public class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fWorkspaceRadio = new SelectionButtonDialogField(16);
        protected final SelectionButtonDialogField fExternalRadio;
        protected final StringButtonDialogField fLocation;
        protected final ComboDialogField fEnvironment;
        private IEnvironment[] environments;
        private String fPreviousExternalLocation = "";
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.dltk.ui.last.external.project";
        private static final String DIALOGSTORE_LAST_EXTERNAL_ENVIRONMENT = "org.eclipse.dltk.ui.last.external.environment";
        private IEnvironmentChangedListener environmentChangedListener = null;
        protected static final int ANY = 0;
        protected static final int WORKSPACE = 1;
        protected static final int EXTERNAL = 2;

        public LocationGroup() {
            this.fWorkspaceRadio.setDialogFieldListener(this);
            this.fWorkspaceRadio.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_workspace_desc);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setDialogFieldListener(this);
            this.fExternalRadio.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_external_desc);
            this.fLocation = new StringButtonDialogField(this);
            this.fLocation.setDialogFieldListener(this);
            this.fLocation.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_locationLabel_desc);
            this.fLocation.setButtonLabel(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_browseButton_desc);
            this.fEnvironment = new ComboDialogField(12);
            this.fEnvironment.setLabelText(NewWizardMessages.ProjectWizardFirstPage_host);
            this.fEnvironment.setDialogFieldListener(this);
            this.fEnvironment.setDialogFieldListener(new IDialogFieldListener(){

                public void dialogFieldChanged(DialogField field) {
                    LocationGroup.this.updateInterpreters();
                }
            });
        }

        public void createControls(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)ProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_title);
            this.createModeControls((Composite)group, 3);
            this.createEnvironmentControls((Composite)group, 3);
            this.createLocationControls((Composite)group, 3);
        }

        protected void initialize() {
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
        }

        @Deprecated
        protected final void createControls(Composite group, int numColumns) {
        }

        protected void createModeControls(Composite group, int numColumns) {
            this.fWorkspaceRadio.doFillIntoGrid(group, numColumns);
            this.fExternalRadio.doFillIntoGrid(group, numColumns);
        }

        protected void createEnvironmentControls(Composite group, int numColumns) {
            this.environmentChangedListener = new EnvironmentChangedListener(){

                public void environmentsModified() {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            block2: {
                                try {
                                    LocationGroup.this.initEnvironments(false);
                                }
                                catch (Exception e) {
                                    if (!DLTKCore.DEBUG) break block2;
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                }
            };
            EnvironmentManager.addEnvironmentChangedListener((IEnvironmentChangedListener)this.environmentChangedListener);
            this.initEnvironments(true);
            this.fEnvironment.doFillIntoGrid(group, numColumns);
            LayoutUtil.setHorizontalGrabbing((Control)this.fEnvironment.getComboControl(null));
        }

        protected void createLocationControls(Composite group, int numColumns) {
            this.fLocation.doFillIntoGrid(group, numColumns);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
        }

        private void initEnvironments(boolean initializeWithLocal) {
            int index;
            IEnvironment selection = !initializeWithLocal && this.environments != null ? ((index = this.fEnvironment.getSelectionIndex()) >= 0 && index < this.environments.length ? this.environments[index] : null) : null;
            this.environments = EnvironmentManager.getEnvironments((boolean)false);
            String[] items = new String[this.environments.length];
            int selectionIndex = 0;
            int i = 0;
            while (i < items.length) {
                IEnvironment env = this.environments[i];
                items[i] = env.getName();
                if (selection == null ? env.isLocal() : selection.equals(env)) {
                    selectionIndex = i;
                }
                ++i;
            }
            this.fEnvironment.setItems(items);
            this.fEnvironment.selectItem(selectionIndex);
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        private void updateInterpreters() {
            ProjectWizardFirstPage.this.handlePossibleInterpreterChange();
        }

        protected String getDefaultPath(String name) {
            return Platform.getLocation().append(name).toOSString();
        }

        public void update(Observable o, Object arg) {
            if (!this.canChangeEnvironment()) {
                this.selectLocalEnvironment();
            }
            if (!this.canChangeLocation()) {
                this.fLocation.setText(this.getDefaultPath(ProjectWizardFirstPage.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        private void selectLocalEnvironment() {
            this.setEnvironment(EnvironmentManager.getLocalEnvironment());
        }

        protected void setEnvironment(IEnvironment env) {
            if (this.environments == null) {
                return;
            }
            int i = 0;
            while (i < this.environments.length) {
                if (env.equals(this.environments[i])) {
                    if (this.fEnvironment.getSelectionIndex() == i) break;
                    this.fEnvironment.selectItem(i);
                    break;
                }
                ++i;
            }
        }

        public IPath getLocation() {
            if (this.isInWorkspace()) {
                return Platform.getLocation();
            }
            return new Path(this.fLocation.getText().trim());
        }

        public boolean isInWorkspace() {
            return this.fWorkspaceRadio.isSelected();
        }

        public boolean isExternalProject() {
            return this.fExternalRadio.isSelected();
        }

        protected boolean canChangeLocation() {
            return this.isExternalProject();
        }

        protected boolean canChangeEnvironment() {
            return this.isExternalProject();
        }

        public IEnvironment getEnvironment() {
            int index;
            if (this.canChangeEnvironment() && (index = this.fEnvironment.getSelectionIndex()) >= 0 && index < this.environments.length) {
                return this.environments[index];
            }
            return EnvironmentManager.getLocalEnvironment();
        }

        public void changeControlPressed(DialogField field) {
            IEnvironment environment = this.getEnvironment();
            IEnvironmentUI environmentUI = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class);
            if (environmentUI != null) {
                String selectedDirectory;
                String prevLocation;
                String directoryName = this.fLocation.getText().trim();
                if (directoryName.length() == 0 && (prevLocation = this.loadLastExternalLocation(environment)) != null) {
                    directoryName = prevLocation;
                }
                if ((selectedDirectory = environmentUI.selectFolder(ProjectWizardFirstPage.this.getShell(), directoryName)) != null) {
                    this.fLocation.setText(selectedDirectory);
                    this.saveLastExternalLocation(environment, selectedDirectory);
                }
            }
        }

        protected String loadLastExternalLocation(IEnvironment environment) {
            String browseLocation = ProjectWizardFirstPage.this.getWizardState().getString(ProjectWizardFirstPage.ATTR_EXTERNAL_BROWSE_LOCATION + environment.getId());
            if (browseLocation != null && browseLocation.length() != 0) {
                return browseLocation;
            }
            IDialogSettings ds = DLTKUIPlugin.getDefault().getDialogSettings();
            String savedEnvId = ds.get(DIALOGSTORE_LAST_EXTERNAL_ENVIRONMENT);
            if (savedEnvId == null || savedEnvId.equals(environment.getId())) {
                return ds.get(DIALOGSTORE_LAST_EXTERNAL_LOC);
            }
            return null;
        }

        protected void saveLastExternalLocation(IEnvironment environment, String directory) {
            IDialogSettings ds = DLTKUIPlugin.getDefault().getDialogSettings();
            ds.put(DIALOGSTORE_LAST_EXTERNAL_LOC, directory);
            ds.put(DIALOGSTORE_LAST_EXTERNAL_ENVIRONMENT, environment.getId());
        }

        protected boolean isModeField(DialogField field, int kind) {
            switch (kind) {
                case 0: {
                    return field == this.fWorkspaceRadio || field == this.fExternalRadio;
                }
                case 1: {
                    return field == this.fWorkspaceRadio;
                }
                case 2: {
                    return field == this.fExternalRadio;
                }
            }
            return false;
        }

        public void dialogFieldChanged(DialogField field) {
            if (this.isModeField(field, 0)) {
                if (field instanceof SelectionButtonDialogField && !((SelectionButtonDialogField)field).getSelectionButton().getSelection()) {
                    return;
                }
                this.refreshControls();
            }
            this.fireEvent();
        }

        protected void refreshControls() {
            boolean wasLocationEnabled = this.fLocation.isEnabled();
            this.fLocation.setEnabled(this.canChangeLocation());
            this.fEnvironment.setEnabled(this.canChangeEnvironment());
            if (!this.canChangeEnvironment()) {
                this.selectLocalEnvironment();
            }
            if (this.canChangeLocation() != wasLocationEnabled) {
                if (wasLocationEnabled) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(ProjectWizardFirstPage.this.fNameGroup.getName()));
                } else {
                    IEnvironment environment = this.getEnvironment();
                    if (environment != null && environment.isLocal()) {
                        this.fLocation.setText(this.fPreviousExternalLocation);
                    } else {
                        this.fLocation.setText("");
                    }
                }
            }
            this.updateInterpreters();
        }

        protected void dispose() {
            if (this.environmentChangedListener != null) {
                EnvironmentManager.removeEnvironmentChangedListener((IEnvironmentChangedListener)this.environmentChangedListener);
                this.environmentChangedListener = null;
            }
        }

        public IStatus validate(IProject handle) {
            IStatus locationStatus;
            String location = this.getLocation().toOSString();
            if (location.length() == 0) {
                return new StatusInfo(2, NewWizardMessages.ScriptProjectWizardFirstPage_Message_enterLocation);
            }
            if (!Path.EMPTY.isValidPath(location)) {
                return new StatusInfo(4, NewWizardMessages.ScriptProjectWizardFirstPage_Message_invalidDirectory);
            }
            IPath projectPath = Path.fromOSString((String)location);
            IEnvironment environment = this.getEnvironment();
            if (!this.isInWorkspace() && environment.isLocal() && Platform.getLocation().isPrefixOf(projectPath)) {
                return new StatusInfo(4, NewWizardMessages.ScriptProjectWizardFirstPage_Message_cannotCreateInWorkspace);
            }
            if (!this.isInWorkspace() && environment.isLocal() && !(locationStatus = DLTKUIPlugin.getWorkspace().validateProjectLocation(handle, projectPath)).isOK()) {
                return new StatusInfo(4, locationStatus.getMessage());
            }
            return Status.OK_STATUS;
        }
    }

    public final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField;

        public NameGroup(Composite composite, String initialName) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)ProjectWizardFirstPage.this.initGridLayout(new GridLayout(2, false), false));
            nameComposite.setLayoutData((Object)new GridData(768));
            this.fNameField = new StringDialogField();
            this.fNameField.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_NameGroup_label_text);
            this.fNameField.setDialogFieldListener(this);
            this.setName(initialName);
            this.fNameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(ProjectWizardFirstPage.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.fNameField.setText(name);
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        public void update(Observable o, Object arg) {
            IControlDecorationManager manager = ProjectWizardFirstPage.this.fDecorationManager.beginReporting();
            try {
                this.validate(manager, o, arg);
            }
            finally {
                manager.commit();
            }
        }

        private void validate(IControlDecorationManager decorations, Observable o, Object arg) {
            IStatus projectStatus = ProjectWizardFirstPage.this.validateProject();
            if (projectStatus == null) {
                decorations.hide((Control)ProjectWizardFirstPage.this.fNameGroup.fNameField.getTextControl());
                projectStatus = ProjectWizardFirstPage.this.fLocationGroup.validate(ProjectWizardFirstPage.this.getProjectHandle());
                if (projectStatus.isOK()) {
                    projectStatus = null;
                }
                if (projectStatus != null) {
                    if (projectStatus instanceof ControlStatus) {
                        ControlStatus cStatus = (ControlStatus)projectStatus;
                        decorations.show(cStatus.getControl(), cStatus);
                    } else {
                        decorations.show((Control)ProjectWizardFirstPage.this.fLocationGroup.fLocation.getTextControl(), projectStatus);
                    }
                }
            } else {
                decorations.show((Control)ProjectWizardFirstPage.this.fNameGroup.fNameField.getTextControl(), projectStatus);
            }
            if (projectStatus != null) {
                if (projectStatus.getSeverity() != 4) {
                    ProjectWizardFirstPage.this.setErrorMessage(null);
                    ProjectWizardFirstPage.this.setMessage(projectStatus.getMessage());
                } else {
                    ProjectWizardFirstPage.this.setErrorMessage(projectStatus.getMessage());
                }
                ProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (ProjectWizardFirstPage.this.supportInterpreter() && ProjectWizardFirstPage.this.interpeterRequired() && !ProjectWizardFirstPage.this.fInterpreterGroup.isInterpreterPresent()) {
                ProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ProjectWizardFirstPage_atLeastOneInterpreterMustBeConfigured);
                ProjectWizardFirstPage.this.setPageComplete(false);
                decorations.show(ProjectWizardFirstPage.this.fInterpreterGroup.getDecorationTarget(), new StatusInfo(4, NewWizardMessages.ProjectWizardFirstPage_atLeastOneInterpreterMustBeConfigured));
                return;
            }
            ProjectWizardFirstPage.this.setPageComplete(true);
            ProjectWizardFirstPage.this.setErrorMessage(null);
            ProjectWizardFirstPage.this.setMessage(null);
        }
    }

    private static final class WorkingSetGroup
    implements IWorkingSetGroup {
        private final WorkingSetConfigurationBlock fWorkingSetBlock;

        public WorkingSetGroup() {
            String[] workingSetIds = new String[]{"org.eclipse.dltk.ui.ScriptWorkingSetPage", "org.eclipse.ui.resourceWorkingSetPage"};
            this.fWorkingSetBlock = new WorkingSetConfigurationBlock(workingSetIds, DLTKUIPlugin.getDefault().getDialogSettings());
        }

        public void createControl(Composite composite) {
            Group workingSetGroup = new Group(composite, 0);
            workingSetGroup.setFont(composite.getFont());
            workingSetGroup.setText(NewWizardMessages.ProjectWizardFirstPage_WorkingSets_group);
            workingSetGroup.setLayoutData((Object)new GridData(768));
            workingSetGroup.setLayout((Layout)new GridLayout(1, false));
            this.fWorkingSetBlock.createContent((Composite)workingSetGroup);
        }

        public void setWorkingSets(IWorkingSet[] workingSets) {
            this.fWorkingSetBlock.setWorkingSets(workingSets);
        }

        public IWorkingSet[] getSelectedWorkingSets() {
            return this.fWorkingSetBlock.getSelectedWorkingSets();
        }
    }
}

