/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.eclipse.dltk.internal.javascript.ti.JSDocProblem;
import org.eclipse.dltk.internal.javascript.validation.ValidationMessages;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.parser.util.CharStreamUtil;
import org.eclipse.dltk.javascript.typeinfo.JSDocParseException;
import org.eclipse.dltk.javascript.typeinfo.JSDocTypeParserExtension;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.FunctionType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.RecordProperty;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelPackage;
import org.eclipse.dltk.javascript.typeinfo.model.UnionType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDocTypeParser {
    public static final String FUNCTION = "function";
    public static final String CLASS = "Class";
    private final char[] extensionChars;
    private JSDocTypeParserExtension extension;

    public JSDocTypeParser() {
        this(null);
    }

    protected JSDocTypeParser(char[] extensionChars) {
        this.extensionChars = extensionChars;
    }

    public void setExtension(JSDocTypeParserExtension extension) {
        this.extension = extension;
    }

    public JSType parse(String input) throws ParseException {
        ANTLRStringStream stream = new ANTLRStringStream(input);
        JSType type = this.parse((CharStream)stream, true);
        if (stream.LT(1) != -1) {
            throw new ParseException("Unexpected " + stream.substring(stream.index(), stream.size() - 1), stream.index());
        }
        return type;
    }

    public JSType parse(CharStream input, boolean autoUnion) throws ParseException {
        JSType type;
        boolean inParenthese;
        CharStreamUtil.skipSpaces((CharStream)input);
        ArrayList<JSType> types = new ArrayList<JSType>();
        boolean bl = inParenthese = input.LT(1) == 40;
        if (inParenthese) {
            input.consume();
            CharStreamUtil.skipSpaces((CharStream)input);
        }
        while ((type = this.parseType(input)) != null) {
            types.add(type);
            CharStreamUtil.skipSpaces((CharStream)input);
            if (!inParenthese && !autoUnion || input.LT(1) != 124) break;
            input.consume();
            CharStreamUtil.skipSpaces((CharStream)input);
        }
        if (inParenthese) {
            CharStreamUtil.match((CharStream)input, (char)')');
        }
        if (types.size() == 1) {
            return (JSType)types.get(0);
        }
        if (types.size() > 1) {
            UnionType unionType = TypeInfoModelFactory.eINSTANCE.createUnionType();
            unionType.getTargets().addAll(types);
            return unionType;
        }
        return null;
    }

    protected JSType parseType(CharStream input) throws ParseException {
        if (input.LT(1) == 63) {
            input.consume();
        } else if (input.LT(1) == 33) {
            input.consume();
        }
        if (input.LT(1) == 123) {
            input.consume();
            RecordType recordType = this.parseRecordType(input);
            CharStreamUtil.match((CharStream)input, (char)'}');
            return recordType;
        }
        if (input.LT(1) == 42) {
            input.consume();
            return TypeInfoModelFactory.eINSTANCE.createAnyType();
        }
        return this.parseTypeName(input);
    }

    protected JSType parseTypeName(CharStream input) throws ParseException {
        int start = input.index();
        while (true) {
            String baseType;
            int baseEnd;
            int ch = input.LT(1);
            if (this.extensionChars != null) {
                int i = 0;
                while (i < this.extensionChars.length) {
                    if (this.extensionChars[i] == ch) {
                        JSType result = this.parseExtension(input, start);
                        if (result == null) break;
                        if (this.extension != null) {
                            this.extension.reportType(result, start, input.index());
                        }
                        return result;
                    }
                    ++i;
                }
            }
            if (ch == 60) {
                baseEnd = input.index();
                baseType = input.substring(start, baseEnd - 1);
                input.consume();
                List<JSType> typeParams = this.parseTypeParams(input);
                CharStreamUtil.match((CharStream)input, (char)'>');
                JSType type = this.createGenericType(baseType, typeParams);
                if (this.extension != null) {
                    this.extension.reportType(type, start, baseEnd);
                }
                return this.checkIfArray(input, type);
            }
            if (ch == 46 && input.LT(2) == 60) {
                baseEnd = input.index();
                baseType = input.substring(start, baseEnd - 1);
                input.consume();
                input.consume();
                List<JSType> typeParams = this.parseTypeParams(input);
                CharStreamUtil.match((CharStream)input, (char)'>');
                JSType type = this.createGenericType(baseType, typeParams);
                if (this.extension != null) {
                    this.extension.reportType(type, start, baseEnd);
                }
                return this.checkIfArray(input, type);
            }
            if (ch == 40 && FUNCTION.equals(input.substring(start, input.index() - 1))) {
                input.consume();
                FunctionType functionType = TypeInfoModelFactory.eINSTANCE.createFunctionType();
                this.parseFunctionParams(input, functionType.getParameters());
                CharStreamUtil.match((CharStream)input, (char)')');
                CharStreamUtil.skipSpaces((CharStream)input);
                if (input.LT(1) == 58) {
                    input.consume();
                    CharStreamUtil.skipSpaces((CharStream)input);
                    functionType.setReturnType(this.parse(input, false));
                }
                return this.checkIfArray(input, functionType);
            }
            if (ch == 91) {
                JSType itemType = this.createType(input, start);
                input.consume();
                CharStreamUtil.match((CharStream)input, (char)']');
                JSType array = this.createArray(itemType);
                return this.checkIfArray(input, array);
            }
            if (ch == -1 || Character.isWhitespace(ch) || ch == 124 || ch == 44 || ch == 61 || ch == 125 || ch == 62 || ch == 41 || ch == 93) {
                return input.index() > start ? this.createType(input, start) : null;
            }
            input.consume();
        }
    }

    protected JSType parseExtension(CharStream input, int start) throws ParseException {
        return null;
    }

    private JSType createType(CharStream input, int start) {
        int end = input.index();
        JSType type = this.createType(this.translate(input.substring(start, end - 1)));
        if (this.extension != null) {
            this.extension.reportType(type, start, end);
        }
        return type;
    }

    private JSType checkIfArray(CharStream input, JSType type) throws ParseException {
        int ch = input.LT(1);
        while (ch == 91) {
            input.consume();
            CharStreamUtil.match((CharStream)input, (char)']');
            type = this.createArray(type);
            ch = input.LT(1);
        }
        return type;
    }

    protected JSType createType(String typeName) {
        if ("undefined".equals(typeName)) {
            return TypeInfoModelFactory.eINSTANCE.createUndefinedType();
        }
        if (CLASS.equals(typeName)) {
            return TypeInfoModelFactory.eINSTANCE.createClassType();
        }
        return TypeUtil.ref(typeName);
    }

    protected JSType createArray(JSType itemType) {
        return TypeUtil.arrayOf(itemType);
    }

    protected JSType createGenericType(String baseType, List<JSType> typeParams) throws ParseException {
        if ("Array".equals(baseType)) {
            if (typeParams.size() != 1) {
                throw new JSDocParseException(NLS.bind((String)ValidationMessages.IncorrectNumberOfTypeArguments, (Object)"Array"), JavaScriptProblems.PARAMETERIZED_TYPE_INCORRECT_ARGUMENTS);
            }
            return this.createArray(typeParams.get(0));
        }
        if (CLASS.equals(baseType)) {
            if (typeParams.size() != 1) {
                throw new JSDocParseException(NLS.bind((String)ValidationMessages.IncorrectNumberOfTypeArguments, (Object)CLASS), JavaScriptProblems.PARAMETERIZED_TYPE_INCORRECT_ARGUMENTS);
            }
            JSType typeParam = typeParams.get(0);
            if (typeParam.eClass() != TypeInfoModelPackage.Literals.SIMPLE_TYPE) {
                throw new JSDocParseException(JSDocProblem.WRONG_TYPE_PARAMETERIZATION, CLASS, typeParam.eClass().getName());
            }
            return TypeUtil.classType(((SimpleType)typeParam).getTarget());
        }
        if ("Object".equals(baseType)) {
            if (typeParams.isEmpty() || typeParams.size() > 2) {
                throw new JSDocParseException(NLS.bind((String)ValidationMessages.IncorrectNumberOfTypeArguments, (Object)"Object"), JavaScriptProblems.PARAMETERIZED_TYPE_INCORRECT_ARGUMENTS);
            }
            if (typeParams.size() == 2) {
                return TypeUtil.mapOf(typeParams.get(0), typeParams.get(1));
            }
            assert (typeParams.size() == 1);
            return TypeUtil.mapOf(null, typeParams.get(0));
        }
        return this.doCreateGenericType(baseType, typeParams);
    }

    protected JSType doCreateGenericType(String baseType, List<JSType> typeParams) throws ParseException {
        if (!typeParams.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(baseType);
            sb.append('<');
            int index = 0;
            for (JSType typeParam : typeParams) {
                if (++index > 1) {
                    sb.append(',');
                }
                sb.append(typeParam.getName());
            }
            sb.append('>');
            return TypeUtil.ref(sb.toString());
        }
        return TypeUtil.ref(baseType);
    }

    protected List<JSType> parseTypeParams(CharStream input) throws ParseException {
        JSType type;
        ArrayList<JSType> types = new ArrayList<JSType>();
        while ((type = this.parse(input, true)) != null) {
            types.add(type);
            CharStreamUtil.skipSpaces((CharStream)input);
            if (input.LT(1) != 44) break;
            input.consume();
        }
        return types;
    }

    public void parseFunctionParams(CharStream input, EList<Parameter> parameters) throws ParseException {
        while (true) {
            JSType type;
            CharStreamUtil.skipSpaces((CharStream)input);
            boolean varargs = false;
            boolean squareBracket = false;
            if (input.LT(1) == 46 && input.LT(2) == 46 && input.LT(3) == 46) {
                input.consume();
                input.consume();
                input.consume();
                varargs = true;
                if (input.LT(1) == 91) {
                    input.consume();
                    squareBracket = true;
                }
            }
            if ((type = this.parse(input, true)) == null) break;
            Parameter parameter = TypeInfoModelFactory.eINSTANCE.createParameter();
            parameter.setType(type);
            if (varargs) {
                parameter.setKind(ParameterKind.VARARGS);
                if (squareBracket) {
                    CharStreamUtil.match((CharStream)input, (char)']');
                }
            } else if (input.LT(1) == 61) {
                parameter.setKind(ParameterKind.OPTIONAL);
                input.consume();
            }
            parameters.add((Object)parameter);
            CharStreamUtil.skipSpaces((CharStream)input);
            if (input.LT(1) != 44) break;
            input.consume();
        }
    }

    protected RecordType parseRecordType(CharStream input) throws ParseException {
        int start = input.index();
        RecordType type = TypeInfoModelFactory.eINSTANCE.createRecordType();
        CharStreamUtil.skipSpaces((CharStream)input);
        while (true) {
            int ch;
            boolean optional;
            boolean bl = optional = (ch = input.LT(1)) == 91;
            if (optional) {
                input.consume();
                ch = input.LT(1);
            }
            boolean validPropertyName = true;
            int nameStart = input.index();
            String name = null;
            if (ch == 34 || ch == 39) {
                input.consume();
                ch = input.LT(1);
                while (ch != 34 && ch != 39 && ch != -1) {
                    input.consume();
                    ch = input.LT(1);
                }
                if (ch == -1) {
                    throw new ParseException("Ending quote expected", input.index());
                }
                validPropertyName = false;
                name = input.substring(nameStart + 1, input.index() - 1);
                input.consume();
            } else if (Character.isJavaIdentifierStart(ch)) {
                input.consume();
                while (Character.isJavaIdentifierPart(input.LT(1))) {
                    input.consume();
                }
                name = input.substring(nameStart, input.index() - 1);
            }
            if (name == null) break;
            RecordProperty property = TypeInfoModelFactory.eINSTANCE.createRecordProperty();
            property.setName(name);
            CharStreamUtil.skipSpaces((CharStream)input);
            if (optional) {
                CharStreamUtil.match((CharStream)input, (char)']');
                CharStreamUtil.skipSpaces((CharStream)input);
                property.setOptional(true);
            }
            if (input.LT(1) == 58) {
                input.consume();
                JSType memberType = this.parse(input, true);
                ch = input.LT(1);
                if (ch == 61) {
                    input.consume();
                    property.setOptional(true);
                }
                if (memberType != null) {
                    property.setType(memberType);
                } else {
                    property.setType(TypeInfoModelFactory.eINSTANCE.createAnyType());
                }
            } else {
                property.setType(TypeInfoModelFactory.eINSTANCE.createAnyType());
            }
            if (validPropertyName) {
                type.getMembers().add((Object)property);
            }
            CharStreamUtil.skipSpaces((CharStream)input);
            if (input.LT(1) != 44) break;
            input.consume();
            CharStreamUtil.skipSpaces((CharStream)input);
        }
        type.setTypeName(String.valueOf('{') + input.substring(start, input.index() - 1) + '}');
        return type;
    }

    protected String translate(String typeName) {
        return TypeInfoModelLoader.getInstance().translateTypeName(typeName);
    }
}

