/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser.definitions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionExtensionManager {
    private static final String EXTENSION_ID = "org.eclipse.dltk.tcl.parser.definitions";
    private static DefinitionExtensionManager sInstance;
    private Map<URL, String> extentions = new HashMap<URL, String>();
    private boolean initialized = false;

    private DefinitionExtensionManager() {
    }

    private void initialize() {
        IConfigurationElement[] configurationElements;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            String name = config.getAttribute("name");
            String url = config.getAttribute("url");
            try {
                URL urlValue = new URL(url);
                this.extentions.put(urlValue, name);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public URL[] getLocations() {
        this.initialize();
        return this.extentions.keySet().toArray(new URL[this.extentions.size()]);
    }

    public Map<URL, String> getExtentions() {
        return this.extentions;
    }

    public static synchronized DefinitionExtensionManager getInstance() {
        if (sInstance == null) {
            sInstance = new DefinitionExtensionManager();
        }
        return sInstance;
    }
}

