/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.browsing.LogicalPackage;
import org.eclipse.dltk.internal.ui.typehierarchy.OpenTypeHierarchyUtil;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;

public class OpenTypeHierarchyAction
extends SelectionDispatchAction {
    private IEditorPart fEditor;

    public OpenTypeHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenTypeHierarchyAction_label);
        this.setToolTipText(ActionMessages.OpenTypeHierarchyAction_tooltip);
        this.setDescription(ActionMessages.OpenTypeHierarchyAction_description);
    }

    public OpenTypeHierarchyAction(IWorkbenchSite site, ISelectionProvider provider) {
        this(site);
        this.setSpecialSelectionProvider(provider);
    }

    public OpenTypeHierarchyAction(IEditorPart editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object input = selection.getFirstElement();
        if (input instanceof LogicalPackage) {
            return true;
        }
        if (!(input instanceof IModelElement)) {
            return false;
        }
        switch (((IModelElement)input).getElementType()) {
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void run(ITextSelection selection) {
        IModelElement input = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        try {
            IModelElement[] elements = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (elements == null) {
                return;
            }
            ArrayList candidates = new ArrayList(elements.length);
            int i = 0;
            while (i < elements.length) {
                IModelElement[] resolvedElements = OpenTypeHierarchyUtil.getCandidates(elements[i]);
                if (resolvedElements != null) {
                    Collections.addAll(candidates, resolvedElements);
                }
                ++i;
            }
            this.run(candidates.toArray(new IModelElement[candidates.size()]));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), OpenTypeHierarchyAction.getDialogTitle(), ActionMessages.SelectionConverter_codeResolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object input = selection.getFirstElement();
        if (input instanceof LogicalPackage) {
            IScriptFolder[] fragments = ((LogicalPackage)((Object)input)).getFragments();
            if (fragments.length == 0) {
                return;
            }
            input = fragments[0];
        }
        if (!(input instanceof IModelElement)) {
            IStatus status = OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_script_element);
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)ActionMessages.OpenTypeHierarchyAction_messages_title, (IStatus)status);
            return;
        }
        IModelElement element = (IModelElement)input;
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        ArrayList<IModelElement> result = new ArrayList<IModelElement>(1);
        IStatus status = OpenTypeHierarchyAction.compileCandidates(result, element);
        if (status.isOK()) {
            this.run(result.toArray(new IModelElement[result.size()]));
        } else {
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)ActionMessages.OpenTypeHierarchyAction_messages_title, (IStatus)status);
        }
    }

    public void run(IModelElement[] elements) {
        if (elements.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        OpenTypeHierarchyUtil.open(elements, this.getSite().getWorkbenchWindow());
    }

    private static String getDialogTitle() {
        return ActionMessages.OpenTypeHierarchyAction_dialog_title;
    }

    private static IStatus compileCandidates(List<IModelElement> result, IModelElement elem) {
        Status ok = new Status(0, DLTKUIPlugin.getPluginId(), 0, "", null);
        try {
            switch (elem.getElementType()) {
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: {
                    result.add(elem);
                    return ok;
                }
                case 4: {
                    if (((IScriptFolder)elem).containsScriptResources()) {
                        result.add(elem);
                        return ok;
                    }
                    return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_script_resources);
                }
                case 10: {
                    result.add(elem.getAncestor(4));
                    return ok;
                }
                case 5: {
                    AbstractSourceModule cu = (AbstractSourceModule)elem;
                    IType[] types = cu.getTypes();
                    if (types.length > 0) {
                        result.addAll(Arrays.asList(types));
                        return ok;
                    }
                    return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_types);
                }
            }
        }
        catch (ModelException e) {
            return e.getStatus();
        }
        return OpenTypeHierarchyAction.createStatus(ActionMessages.OpenTypeHierarchyAction_messages_no_valid_script_element);
    }

    private static IStatus createStatus(String message) {
        return new Status(1, DLTKUIPlugin.getPluginId(), 10001, message, null);
    }
}

