/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.index2.search;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.index2.IElementResolver;
import org.eclipse.dltk.core.index2.IIndexer;
import org.eclipse.dltk.core.index2.IIndexerParticipant;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.index2.search.ISearchRequestor;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.index2.IndexerManager;

public class ModelAccess {
    public IField[] findFields(String name, ISearchEngine.MatchRule matchRule, int trueFlags, int falseFlags, IDLTKSearchScope scope, IProgressMonitor monitor) {
        LinkedList result = new LinkedList();
        if (!this.findElements(8, name, matchRule, trueFlags, falseFlags, scope, result, monitor)) {
            return null;
        }
        return result.toArray(new IField[result.size()]);
    }

    public IField[] findFields(String qualifier, String name, ISearchEngine.MatchRule matchRule, int trueFlags, int falseFlags, IDLTKSearchScope scope, IProgressMonitor monitor) {
        LinkedList result = new LinkedList();
        if (!this.findElements(8, qualifier, name, matchRule, trueFlags, falseFlags, scope, result, monitor)) {
            return null;
        }
        return result.toArray(new IField[result.size()]);
    }

    public IMethod[] findMethods(String name, ISearchEngine.MatchRule matchRule, int trueFlags, int falseFlags, IDLTKSearchScope scope, IProgressMonitor monitor) {
        LinkedList result = new LinkedList();
        if (!this.findElements(9, name, matchRule, trueFlags, falseFlags, scope, result, monitor)) {
            return null;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public IMethod[] findMethods(String qualifier, String name, ISearchEngine.MatchRule matchRule, int trueFlags, int falseFlags, IDLTKSearchScope scope, IProgressMonitor monitor) {
        LinkedList result = new LinkedList();
        if (!this.findElements(9, qualifier, name, matchRule, trueFlags, falseFlags, scope, result, monitor)) {
            return null;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public IType[] findTypes(String name, ISearchEngine.MatchRule matchRule, int trueFlags, int falseFlags, IDLTKSearchScope scope, IProgressMonitor monitor) {
        LinkedList result = new LinkedList();
        if (!this.findElements(7, name, matchRule, trueFlags, falseFlags, scope, result, monitor)) {
            return null;
        }
        return result.toArray(new IType[result.size()]);
    }

    public IType[] findTypes(String qualifier, String name, ISearchEngine.MatchRule matchRule, int trueFlags, int falseFlags, IDLTKSearchScope scope, IProgressMonitor monitor) {
        LinkedList result = new LinkedList();
        if (!this.findElements(7, qualifier, name, matchRule, trueFlags, falseFlags, scope, result, monitor)) {
            return null;
        }
        return result.toArray(new IType[result.size()]);
    }

    protected <T extends IModelElement> boolean findElements(int elementType, String name, ISearchEngine.MatchRule matchRule, int trueFlags, int falseFlags, IDLTKSearchScope scope, Collection<T> result, IProgressMonitor monitor) {
        String delim;
        int i;
        ISearchPatternProcessor processor;
        String qualifier = null;
        if (name != null && (processor = DLTKLanguageManager.getSearchPatternProcessor(scope.getLanguageToolkit())) != null && (i = name.lastIndexOf(delim = processor.getDelimiterReplacementString())) != -1) {
            qualifier = name.substring(0, i);
            name = name.substring(i + 1);
        }
        return this.findElements(elementType, qualifier, name, matchRule, trueFlags, falseFlags, scope, result, monitor);
    }

    protected <T extends IModelElement> boolean findElements(int elementType, String qualifier, String name, ISearchEngine.MatchRule matchRule, int trueFlags, int falseFlags, IDLTKSearchScope scope, final Collection<T> result, IProgressMonitor monitor) {
        IDLTKLanguageToolkit toolkit = scope.getLanguageToolkit();
        if (toolkit == null) {
            return false;
        }
        final IElementResolver elementResolver = ModelAccess.getElementResolver(toolkit);
        if (elementResolver == null) {
            return false;
        }
        ISearchEngine searchEngine = ModelAccess.getSearchEngine(toolkit);
        if (searchEngine == null) {
            return false;
        }
        searchEngine.search(elementType, qualifier, name, trueFlags, falseFlags, 0, ISearchEngine.SearchFor.DECLARATIONS, matchRule, scope, new ISearchRequestor(){

            @Override
            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                IModelElement element = elementResolver.resolve(elementType, flags, offset, length, nameOffset, nameLength, elementName, metadata, doc, qualifier, parent, sourceModule);
                if (element != null) {
                    result.add(element);
                }
            }
        }, monitor);
        return true;
    }

    public static ISearchEngine.MatchRule convertSearchRule(int searchRule) {
        ISearchEngine.MatchRule matchRule = (searchRule & 1) != 0 ? ISearchEngine.MatchRule.PREFIX : ((searchRule & 0x80) != 0 ? ISearchEngine.MatchRule.CAMEL_CASE : ((searchRule & 2) != 0 ? ISearchEngine.MatchRule.PATTERN : ISearchEngine.MatchRule.EXACT));
        return matchRule;
    }

    public static IIndexerParticipant getIndexerParticipant(IDLTKLanguageToolkit toolkit) {
        if (toolkit == null) {
            return null;
        }
        IIndexer indexer = IndexerManager.getIndexer();
        if (indexer == null) {
            return null;
        }
        return IndexerManager.getIndexerParticipant(indexer, toolkit.getNatureId());
    }

    public static ISearchEngine getSearchEngine(IDLTKLanguageToolkit toolkit) {
        IIndexer indexer;
        if (toolkit != null && (indexer = IndexerManager.getIndexer()) != null) {
            return indexer.createSearchEngine();
        }
        return null;
    }

    public static IElementResolver getElementResolver(IDLTKLanguageToolkit toolkit) {
        IIndexerParticipant participant;
        if (toolkit != null && (participant = ModelAccess.getIndexerParticipant(toolkit)) != null) {
            return participant.getElementResolver();
        }
        return null;
    }
}

