/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui;

import java.util.List;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.tcl.ast.ComplexString;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.ast.TclModuleDeclaration;
import org.eclipse.dltk.tcl.ast.VariableReference;
import org.eclipse.dltk.tcl.internal.ui.text.TclTextTools;
import org.eclipse.dltk.tcl.parser.TclParser;
import org.eclipse.dltk.tcl.parser.TclParserUtils;
import org.eclipse.dltk.tcl.parser.TclVisitor;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionManager;
import org.eclipse.dltk.tcl.parser.definitions.IScopeProcessor;
import org.eclipse.dltk.tcl.ui.semantilhighlighting.ISemanticHighlightingExtension;
import org.eclipse.dltk.ui.editor.highlighting.HighlightedPosition;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingRequestor;
import org.eclipse.dltk.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.emf.common.util.EList;

public class DefaultTclSemanticHighlightingExtension
implements ISemanticHighlightingExtension {
    private SemanticHighlighting[] highlightings = new SemanticHighlighting[]{new TclTextTools.SH("DLTK_function_definition", null, PreferencesMessages.DLTKEditorPreferencePage_function_colors), new TclTextTools.SH("DLTK_argument", null, PreferencesMessages.DLTKEditorPreferencePage_arguments), new TclTextTools.SH("DLTK_class_definition", null, PreferencesMessages.DLTKEditorPreferencePage_class_colors), new TclTextTools.SH("DLTK_base_class", null, PreferencesMessages.DLTKEditorPreferencePage_base_classes), new TclTextTools.SH("DLTK_string", null, PreferencesMessages.DLTKEditorPreferencePage_strings), new TclTextTools.SH("tcl_variable", null, PreferencesMessages.DLTKEditorPreferencePage_variables)};
    private static final String HL_PROCEDURES = "DLTK_function_definition";
    private static final String HL_ARGUMENTS = "DLTK_argument";
    private static final String HL_CLASSES = "DLTK_class_definition";
    private static final String HL_BASE_CLASSES = "DLTK_base_class";
    private static final String HL_STRINGS = "DLTK_string";
    private static final String HL_VARIABLES = "tcl_variable";

    public HighlightedPosition[] calculatePositions(ASTNode node, ISemanticHighlightingRequestor requestor) {
        MethodDeclaration m;
        if (node instanceof MethodDeclaration) {
            m = (MethodDeclaration)node;
            requestor.addPosition(m.getNameStart(), m.getNameEnd(), HL_PROCEDURES);
        }
        if (node instanceof Argument) {
            m = (Argument)node;
            requestor.addPosition(m.getNameStart(), m.getNameEnd(), HL_ARGUMENTS);
        }
        if (node instanceof TypeDeclaration) {
            TypeDeclaration t = (TypeDeclaration)node;
            ASTListNode s = t.getSuperClasses();
            if (s != null && s.getChilds() != null) {
                List children = s.getChilds();
                for (ASTNode n : children) {
                    requestor.addPosition(n.sourceStart(), n.sourceEnd(), HL_BASE_CLASSES);
                }
            }
            requestor.addPosition(t.getNameStart(), t.getNameEnd(), HL_CLASSES);
        }
        return null;
    }

    public void processNode(ASTNode node, ISemanticHighlightingRequestor requestor) {
        this.calculatePositions(node, requestor);
    }

    public SemanticHighlighting[] getHighlightings() {
        return this.highlightings;
    }

    public void doOtherHighlighting(IModuleSource code, final ISemanticHighlightingRequestor semanticHighlightingRequestor) {
        IModelElement modelElement = code.getModelElement();
        if (modelElement == null) {
            return;
        }
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)((ISourceModule)modelElement));
        if (moduleDeclaration instanceof TclModuleDeclaration) {
            TclModuleDeclaration tclModule = (TclModuleDeclaration)moduleDeclaration;
            TclModule module = tclModule.getTclModule();
            if (module == null) {
                TclParser parser = new TclParser();
                module = parser.parseModule(code.getSourceContents(), null, (IScopeProcessor)DefinitionManager.getInstance().createProcessor());
            }
            if (module != null) {
                TclParserUtils.traverse((List)module.getStatements(), (TclVisitor)new TclVisitor(){

                    public boolean visit(StringArgument arg) {
                        String value = arg.getValue();
                        if (value.startsWith("\"") && value.endsWith("\"")) {
                            semanticHighlightingRequestor.addPosition(arg.getStart(), arg.getEnd(), DefaultTclSemanticHighlightingExtension.HL_STRINGS);
                        } else {
                            int pos = value.indexOf(34);
                            while (pos != -1) {
                                int pos2 = value.indexOf(34, pos + 1);
                                if (pos2 == -1) break;
                                semanticHighlightingRequestor.addPosition(arg.getStart() + pos, arg.getStart() + pos2 + 1, DefaultTclSemanticHighlightingExtension.HL_STRINGS);
                                pos = value.indexOf(34, pos2 + 1);
                            }
                        }
                        return super.visit(arg);
                    }

                    public boolean visit(TclCommand command) {
                        String value;
                        TclArgument name = command.getName();
                        if (name instanceof StringArgument && (value = ((StringArgument)name).getValue()).startsWith("\"") && value.endsWith("\"")) {
                            semanticHighlightingRequestor.addPosition(name.getStart(), name.getEnd(), DefaultTclSemanticHighlightingExtension.HL_STRINGS);
                        }
                        return super.visit(command);
                    }

                    public boolean visit(VariableReference list) {
                        semanticHighlightingRequestor.addPosition(list.getStart(), list.getEnd(), DefaultTclSemanticHighlightingExtension.HL_VARIABLES);
                        return super.visit(list);
                    }

                    public boolean visit(ComplexString list) {
                        if (list.getKind() == 2) {
                            EList arguments = list.getArguments();
                            boolean addFirst = false;
                            boolean addLast = false;
                            int i = 0;
                            while (i < arguments.size()) {
                                TclArgument tclArgument = (TclArgument)arguments.get(i);
                                if (tclArgument instanceof StringArgument) {
                                    semanticHighlightingRequestor.addPosition(tclArgument.getStart(), tclArgument.getEnd(), DefaultTclSemanticHighlightingExtension.HL_STRINGS);
                                }
                                if (tclArgument instanceof VariableReference) {
                                    semanticHighlightingRequestor.addPosition(tclArgument.getStart(), tclArgument.getEnd(), DefaultTclSemanticHighlightingExtension.HL_VARIABLES);
                                    if (i == 0) {
                                        addFirst = true;
                                    }
                                    if (i == arguments.size() - 1) {
                                        addLast = true;
                                    }
                                }
                                if (tclArgument instanceof ComplexString) {
                                    this.visit((ComplexString)tclArgument);
                                }
                                ++i;
                            }
                            if (addFirst) {
                                semanticHighlightingRequestor.addPosition(list.getStart(), list.getStart() + 1, DefaultTclSemanticHighlightingExtension.HL_STRINGS);
                            }
                            if (addLast) {
                                semanticHighlightingRequestor.addPosition(list.getEnd() - 1, list.getEnd(), DefaultTclSemanticHighlightingExtension.HL_STRINGS);
                            }
                            return false;
                        }
                        return super.visit(list);
                    }
                });
            }
        }
    }
}

