/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.launching.EnvironmentResolver;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.Messages;
import org.eclipse.dltk.utils.PlatformFileUtils;

public class InterpreterConfig
implements Cloneable {
    private IPath scriptFile;
    private IPath workingDirectory;
    private ArrayList<String> interpreterArgs;
    private ArrayList<String> scriptArgs;
    private HashMap<String, String> environmentVariables;
    private HashMap<String, Object> properties;
    private IEnvironment environment;
    private boolean noFile = false;

    protected void checkScriptFile(IPath file) {
        if (file == null) {
            throw new IllegalArgumentException(Messages.InterpreterConfig_scriptFileCannotBeNull);
        }
    }

    protected void checkWorkingDirectory(IPath directory) {
        if (directory == null) {
            throw new IllegalArgumentException(Messages.InterpreterConfig_workingDirectoryCannotBeNull);
        }
    }

    protected void init(IEnvironment environment, IPath scriptFile, IPath workingDirectory) {
        this.init(environment, scriptFile, workingDirectory, true);
    }

    protected void init(IEnvironment environment, IPath scriptFile, IPath workingDirectory, boolean isLocal) {
        this.environment = environment;
        if (isLocal) {
            this.scriptFile = scriptFile;
            this.workingDirectory = workingDirectory != null ? workingDirectory : scriptFile.removeLastSegments(1);
        }
        this.interpreterArgs = new ArrayList();
        this.scriptArgs = new ArrayList();
        this.environmentVariables = new HashMap();
        this.properties = new HashMap();
    }

    public InterpreterConfig() {
        this.init(null, null, null, false);
    }

    public InterpreterConfig(IEnvironment environment, IPath scriptFile) {
        this(environment, scriptFile, null);
    }

    public InterpreterConfig(IEnvironment environment, IPath scriptFile, IPath workingDirectory) {
        if (scriptFile != null) {
            this.checkScriptFile(scriptFile);
        }
        this.init(environment, scriptFile, workingDirectory);
    }

    public IEnvironment getEnvironment() {
        return this.environment;
    }

    public IExecutionEnvironment getExecutionEnvironment() {
        IEnvironment environment = this.getEnvironment();
        if (environment != null) {
            return (IExecutionEnvironment)environment.getAdapter(IExecutionEnvironment.class);
        }
        return null;
    }

    public void setEnvironment(IEnvironment environment) {
        this.environment = environment;
    }

    public IPath getScriptFilePath() {
        return this.scriptFile;
    }

    public void setScriptFile(IPath file) {
        this.checkScriptFile(file);
        this.scriptFile = file;
    }

    public IPath getWorkingDirectoryPath() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(IPath directory) {
        this.checkWorkingDirectory(directory);
        this.workingDirectory = directory;
    }

    public boolean addInterpreterArg(String arg) {
        if (arg == null) {
            throw new IllegalArgumentException(Messages.InterpreterConfig_interpreterArgumentCannotBeNull);
        }
        return this.interpreterArgs.add(arg);
    }

    public void addInterpreterArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            this.addInterpreterArg(args[i]);
            ++i;
        }
    }

    public void addInterpreterArgs(List<String> args) {
        this.interpreterArgs.addAll(args);
    }

    public boolean hasInterpreterArg(String arg) {
        return this.interpreterArgs.contains(arg);
    }

    public boolean hasMatchedInterpreterArg(String regex) {
        Iterator<String> it = this.interpreterArgs.iterator();
        while (it.hasNext()) {
            if (!it.next().matches(regex)) continue;
            return true;
        }
        return false;
    }

    public boolean removeInterpreterArg(String arg) {
        return this.interpreterArgs.remove(arg);
    }

    public List<String> getInterpreterArgs() {
        return (List)this.interpreterArgs.clone();
    }

    public boolean addScriptArg(String arg) {
        if (arg == null) {
            throw new IllegalArgumentException(Messages.InterpreterConfig_scriptArgumentCannotBeNull);
        }
        return this.scriptArgs.add(arg);
    }

    public void addScriptArg(String arg, int pos) {
        if (arg == null) {
            throw new IllegalArgumentException(Messages.InterpreterConfig_scriptArgumentCannotBeNull);
        }
        this.scriptArgs.add(pos, arg);
    }

    public void addScriptArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            this.addScriptArg(args[i]);
            ++i;
        }
    }

    public void addScriptArgs(List<String> args) {
        this.scriptArgs.addAll(args);
    }

    public boolean hasScriptArg(String arg) {
        return this.scriptArgs.contains(arg);
    }

    public boolean removeScriptArg(String arg) {
        return this.scriptArgs.remove(arg);
    }

    public List<String> getScriptArgs() {
        return (List)this.scriptArgs.clone();
    }

    public String addEnvVar(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException();
        }
        return this.environmentVariables.put(name, value);
    }

    public void addEnvVars(Map<String, String> vars) {
        this.environmentVariables.putAll(vars);
    }

    public String removeEnvVar(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.environmentVariables.remove(name);
    }

    public String getEnvVar(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.environmentVariables.get(name);
    }

    public boolean hasEnvVar(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.environmentVariables.containsKey(name);
    }

    public Map<String, String> getEnvVars() {
        return (Map)this.environmentVariables.clone();
    }

    public String[] getEnvironmentAsStrings() {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.environmentVariables.keySet()) {
            String value = this.environmentVariables.get(key);
            list.add(String.valueOf(key) + "=" + value);
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getEnvironmentAsStringsIncluding(EnvironmentVariable[] vars) {
        EnvironmentVariable[] variables = EnvironmentResolver.resolve(this.getEnvVars(), vars, true);
        HashSet<String> pressentVars = new HashSet<String>();
        ArrayList<String> list = new ArrayList<String>();
        if (variables != null) {
            int i = 0;
            while (i < variables.length) {
                String name = variables[i].getName();
                list.add(String.valueOf(name) + "=" + variables[i].getValue());
                pressentVars.add(name);
                ++i;
            }
        }
        for (String key : this.environmentVariables.keySet()) {
            if (pressentVars.contains(key)) continue;
            String value = this.environmentVariables.get(key);
            list.add(String.valueOf(key) + "=" + value);
        }
        return list.toArray(new String[list.size()]);
    }

    public Object setProperty(String name, Object value) {
        return this.properties.put(name, value);
    }

    public void unsetProperty(String name) {
        this.properties.remove(name);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void addProperties(Map<String, Object> map) {
        this.properties.putAll(map);
    }

    public Map<String, Object> getPropeties() {
        return (Map)this.properties.clone();
    }

    public Object clone() {
        InterpreterConfig config = new InterpreterConfig(this.environment, this.scriptFile, this.workingDirectory);
        config.addProperties(this.getPropeties());
        config.addEnvVars(this.getEnvVars());
        config.addInterpreterArgs(this.getInterpreterArgs());
        config.addScriptArgs(this.getScriptArgs());
        return config;
    }

    public String[] renderCommandLine(IInterpreterInstall interpreter) {
        ArrayList<String> items = new ArrayList<String>();
        items.add(interpreter.getInstallLocation().toOSString());
        items.addAll(this.interpreterArgs);
        String[] interpreterOwnArgs = interpreter.getInterpreterArguments();
        if (interpreterOwnArgs != null) {
            items.addAll(Arrays.asList(interpreterOwnArgs));
        }
        items.add(interpreter.getEnvironment().convertPathToString(this.scriptFile));
        items.addAll(this.scriptArgs);
        return items.toArray(new String[items.size()]);
    }

    protected String[] renderCommandLine(IEnvironment environment, IPath interpreter) {
        ArrayList<String> items = new ArrayList<String>();
        items.add(environment.convertPathToString(interpreter));
        items.addAll(this.interpreterArgs);
        items.add(environment.convertPathToString(this.scriptFile));
        items.addAll(this.scriptArgs);
        return items.toArray(new String[items.size()]);
    }

    public String[] renderCommandLine(IEnvironment environment, String interpreter) {
        IFileHandle interpreterPath = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)environment, (IPath)new Path(interpreter));
        return this.renderCommandLine(environment, interpreterPath.getPath());
    }

    public String toString() {
        ArrayList<String> items = new ArrayList<String>();
        items.add("<interpreter>");
        items.addAll(this.interpreterArgs);
        items.add(String.valueOf(this.scriptFile));
        items.addAll(this.scriptArgs);
        Iterator it = items.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            sb.append((String)it.next());
            sb.append(' ');
        }
        return sb.toString();
    }

    public void clearScriptArgs() {
        this.scriptArgs.clear();
    }

    public void setNoFile(boolean value) {
        this.noFile = value;
    }

    public boolean isNoFile() {
        return this.noFile;
    }
}

