/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.structure;

import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.core.ISourceNode;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.structure.FunctionNode;
import org.eclipse.dltk.javascript.structure.IDeclaration;
import org.eclipse.dltk.javascript.structure.IParentNode;
import org.eclipse.dltk.javascript.structure.IStructureContext;
import org.eclipse.dltk.javascript.structure.IStructureNode;
import org.eclipse.dltk.javascript.structure.IStructureRequestor;
import org.eclipse.dltk.javascript.structure.ParentNode;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;

public class PropertyDeclaration
extends ParentNode
implements IDeclaration {
    private final String name;
    private final PropertyInitializer initializer;
    private final ReferenceLocation location;
    private IStructureNode value;

    public PropertyDeclaration(IParentNode parent, String name, PropertyInitializer initializer, ReferenceLocation location) {
        super(parent);
        this.name = name;
        this.initializer = initializer;
        this.location = location;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JSType getType() {
        if (this.value instanceof IDeclaration) {
            return ((IDeclaration)this.value).getType();
        }
        return null;
    }

    @Override
    public ReferenceLocation getLocation() {
        return this.location;
    }

    @Override
    public int start() {
        return this.location.getDeclarationStart();
    }

    public IStructureNode getValue() {
        return this.value;
    }

    public void setValue(IStructureNode value) {
        this.value = value;
    }

    public ISourceNode getNameNode() {
        return this.initializer.getName();
    }

    public List<IStructureNode> getChildren() {
        return this.value != null ? Collections.singletonList(this.value) : Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(":");
        if (this.value != null) {
            sb.append(this.value);
        } else {
            sb.append("<property?>");
        }
        return sb.toString();
    }

    @Override
    public void reportStructure(IStructureRequestor requestor, IStructureContext context) {
        boolean allowed = context.allow(1);
        if (!allowed) {
            context.pushMask(2);
        }
        if (this.value instanceof FunctionNode) {
            this.value.reportStructure(requestor, context);
        } else {
            if (allowed) {
                IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
                info.declarationStart = this.initializer.getName().start();
                info.name = this.getName();
                info.nameSourceStart = this.initializer.getName().start();
                info.nameSourceEnd = this.initializer.getName().end() - 1;
                requestor.enterField(info, this.initializer.getName(), null, false);
            }
            this.reportChildrenStructure(requestor, context);
            if (allowed) {
                requestor.exitField(this.initializer.end() - 1);
            }
        }
        if (!allowed) {
            context.popMask();
        }
    }
}

