/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.formatter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.formatter.FormatterTextNode;
import org.eclipse.dltk.formatter.IFormatterContainerNode;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterNode;
import org.eclipse.dltk.formatter.IFormatterTextNode;

public abstract class FormatterNodeRewriter {
    private final List<CommentInfo> comments = new ArrayList<CommentInfo>();

    protected void mergeTextNodes(IFormatterContainerNode root) {
        List<IFormatterNode> body = root.getBody();
        ArrayList<IFormatterNode> newBody = new ArrayList<IFormatterNode>();
        ArrayList<IFormatterNode> texts = new ArrayList<IFormatterNode>();
        for (IFormatterNode node : body) {
            if (this.isPlainTextNode(node)) {
                if (!texts.isEmpty() && ((IFormatterTextNode)texts.get(texts.size() - 1)).getEndOffset() != node.getStartOffset()) {
                    this.flushTextNodes(texts, newBody);
                }
                texts.add(node);
                continue;
            }
            if (!texts.isEmpty()) {
                this.flushTextNodes(texts, newBody);
            }
            newBody.add(node);
        }
        if (!texts.isEmpty()) {
            this.flushTextNodes(texts, newBody);
        }
        if (body.size() != newBody.size()) {
            body.clear();
            body.addAll(newBody);
        }
        for (IFormatterNode node : body) {
            if (!(node instanceof IFormatterContainerNode)) continue;
            this.mergeTextNodes((IFormatterContainerNode)node);
        }
    }

    private void flushTextNodes(List<IFormatterNode> texts, List<IFormatterNode> newBody) {
        if (texts.size() > 1) {
            IFormatterNode first = texts.get(0);
            IFormatterNode last = texts.get(texts.size() - 1);
            newBody.add(new FormatterTextNode(first.getDocument(), first.getStartOffset(), last.getEndOffset()));
        } else {
            newBody.addAll(texts);
        }
        texts.clear();
    }

    protected boolean isPlainTextNode(IFormatterNode node) {
        return node.getClass() == FormatterTextNode.class;
    }

    protected void addComment(int startOffset, int endOffset, Object object) {
        this.comments.add(new CommentInfo(startOffset, endOffset, object));
    }

    protected void insertComments(IFormatterContainerNode root) {
        List<IFormatterNode> body = root.getBody();
        ArrayList<IFormatterNode> newBody = new ArrayList<IFormatterNode>();
        boolean changes = false;
        for (IFormatterNode node : body) {
            if (this.isPlainTextNode(node)) {
                if (this.hasComments(node.getStartOffset(), node.getEndOffset())) {
                    this.selectValidRanges(root.getDocument(), node.getStartOffset(), node.getEndOffset(), newBody);
                    changes = true;
                    continue;
                }
                newBody.add(node);
                continue;
            }
            newBody.add(node);
        }
        if (changes) {
            body.clear();
            body.addAll(newBody);
        }
        for (IFormatterNode node : body) {
            if (!(node instanceof IFormatterContainerNode)) continue;
            this.insertComments((IFormatterContainerNode)node);
        }
    }

    private boolean hasComments(int startOffset, int endOffset) {
        for (CommentInfo commentNode : this.comments) {
            if (commentNode.startOffset >= endOffset || startOffset >= commentNode.endOffset) continue;
            return true;
        }
        return false;
    }

    private void selectValidRanges(IFormatterDocument document, int start, int end, List<IFormatterNode> result) {
        for (CommentInfo comment : this.comments) {
            if (start > comment.endOffset || comment.startOffset > end) continue;
            if (start < comment.startOffset) {
                int validEnd = Math.min(end, comment.startOffset);
                result.add(new FormatterTextNode(document, start, validEnd));
                start = comment.startOffset;
            }
            result.add(this.createCommentNode(document, start, Math.min(comment.endOffset, end), comment.object));
            start = comment.endOffset;
            if (start > end) break;
        }
        if (start < end) {
            result.add(new FormatterTextNode(document, start, end));
        }
    }

    protected abstract IFormatterNode createCommentNode(IFormatterDocument var1, int var2, int var3, Object var4);

    private static class CommentInfo {
        final int startOffset;
        final int endOffset;
        final Object object;

        public CommentInfo(int startOffset, int endOffset, Object object) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.object = object;
        }
    }
}

