/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.callhierarchy;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyContentProvider;
import org.eclipse.dltk.internal.ui.callhierarchy.MethodWrapperWorkbenchAdapter;
import org.eclipse.dltk.internal.ui.callhierarchy.TreeTermination;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredMethodWrapper
extends MethodWrapperWorkbenchAdapter
implements IDeferredWorkbenchAdapter {
    private final CallHierarchyContentProvider fProvider;

    DeferredMethodWrapper(CallHierarchyContentProvider provider, MethodWrapper methodWrapper) {
        super(methodWrapper);
        this.fProvider = provider;
    }

    private Object getCalls(IProgressMonitor monitor) {
        return this.getMethodWrapper().getCalls(monitor);
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        try {
            try {
                this.fProvider.startFetching();
                DeferredMethodWrapper methodWrapper = (DeferredMethodWrapper)object;
                collector.add((Object[])methodWrapper.getCalls(monitor), monitor);
                collector.done();
            }
            catch (OperationCanceledException operationCanceledException) {
                collector.add(new Object[]{TreeTermination.SEARCH_CANCELED}, monitor);
                this.fProvider.doneFetching();
            }
            catch (Exception e) {
                DLTKUIPlugin.log(e);
                this.fProvider.doneFetching();
            }
        }
        finally {
            this.fProvider.doneFetching();
        }
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object o) {
        return new BatchSimilarSchedulingRule("org.eclipse.dltk.ui.callhierarchy.methodwrapper");
    }

    @Override
    public Object[] getChildren(Object o) {
        return this.fProvider.fetchChildren(((DeferredMethodWrapper)o).getMethodWrapper());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IDeferredWorkbenchAdapter.class) {
            return this;
        }
        return null;
    }

    private class BatchSimilarSchedulingRule
    implements ISchedulingRule {
        public String id;

        public BatchSimilarSchedulingRule(String id) {
            this.id = id;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof BatchSimilarSchedulingRule) {
                return ((BatchSimilarSchedulingRule)rule).id.equals(this.id);
            }
            return false;
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }
    }
}

