/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core.dom.rewrite;

import java.util.Iterator;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.ArrayInitializer;
import org.eclipse.dltk.javascript.ast.AsteriskExpression;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.CommaExpression;
import org.eclipse.dltk.javascript.ast.ConditionalOperator;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.DoWhileStatement;
import org.eclipse.dltk.javascript.ast.EmptyExpression;
import org.eclipse.dltk.javascript.ast.EmptyStatement;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetAllChildrenExpression;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.GetLocalNameExpression;
import org.eclipse.dltk.javascript.ast.GetMethod;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.NullExpression;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SetMethod;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.SwitchComponent;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VoidExpression;
import org.eclipse.dltk.javascript.ast.XmlAttributeIdentifier;
import org.eclipse.dltk.javascript.ast.XmlExpressionFragment;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.XmlTextFragment;
import org.eclipse.dltk.javascript.ast.YieldOperator;
import org.eclipse.dltk.javascript.core.dom.ArrayAccessExpression;
import org.eclipse.dltk.javascript.core.dom.ArrayLiteral;
import org.eclipse.dltk.javascript.core.dom.AttributeIdentifier;
import org.eclipse.dltk.javascript.core.dom.BinaryExpression;
import org.eclipse.dltk.javascript.core.dom.BinaryOperator;
import org.eclipse.dltk.javascript.core.dom.BlockStatement;
import org.eclipse.dltk.javascript.core.dom.BooleanLiteral;
import org.eclipse.dltk.javascript.core.dom.BreakStatement;
import org.eclipse.dltk.javascript.core.dom.CallExpression;
import org.eclipse.dltk.javascript.core.dom.CaseClause;
import org.eclipse.dltk.javascript.core.dom.CatchClause;
import org.eclipse.dltk.javascript.core.dom.Comment;
import org.eclipse.dltk.javascript.core.dom.ConditionalExpression;
import org.eclipse.dltk.javascript.core.dom.ConstStatement;
import org.eclipse.dltk.javascript.core.dom.ContinueStatement;
import org.eclipse.dltk.javascript.core.dom.DefaultXmlNamespaceStatement;
import org.eclipse.dltk.javascript.core.dom.DescendantAccessExpression;
import org.eclipse.dltk.javascript.core.dom.DoStatement;
import org.eclipse.dltk.javascript.core.dom.DomFactory;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.ExpressionStatement;
import org.eclipse.dltk.javascript.core.dom.FinallyClause;
import org.eclipse.dltk.javascript.core.dom.ForEachInStatement;
import org.eclipse.dltk.javascript.core.dom.ForInStatement;
import org.eclipse.dltk.javascript.core.dom.ForStatement;
import org.eclipse.dltk.javascript.core.dom.FunctionExpression;
import org.eclipse.dltk.javascript.core.dom.IArrayElement;
import org.eclipse.dltk.javascript.core.dom.IForInitializer;
import org.eclipse.dltk.javascript.core.dom.IProperty;
import org.eclipse.dltk.javascript.core.dom.IPropertyName;
import org.eclipse.dltk.javascript.core.dom.IPropertySelector;
import org.eclipse.dltk.javascript.core.dom.ISelector;
import org.eclipse.dltk.javascript.core.dom.IUnqualifiedSelector;
import org.eclipse.dltk.javascript.core.dom.Identifier;
import org.eclipse.dltk.javascript.core.dom.IfStatement;
import org.eclipse.dltk.javascript.core.dom.Label;
import org.eclipse.dltk.javascript.core.dom.LabeledStatement;
import org.eclipse.dltk.javascript.core.dom.NewExpression;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.NumericLiteral;
import org.eclipse.dltk.javascript.core.dom.ObjectLiteral;
import org.eclipse.dltk.javascript.core.dom.Parameter;
import org.eclipse.dltk.javascript.core.dom.ParenthesizedExpression;
import org.eclipse.dltk.javascript.core.dom.PropertyAccessExpression;
import org.eclipse.dltk.javascript.core.dom.PropertyAssignment;
import org.eclipse.dltk.javascript.core.dom.QualifiedIdentifier;
import org.eclipse.dltk.javascript.core.dom.RegularExpressionLiteral;
import org.eclipse.dltk.javascript.core.dom.ReturnStatement;
import org.eclipse.dltk.javascript.core.dom.Source;
import org.eclipse.dltk.javascript.core.dom.Statement;
import org.eclipse.dltk.javascript.core.dom.StringLiteral;
import org.eclipse.dltk.javascript.core.dom.SwitchElement;
import org.eclipse.dltk.javascript.core.dom.SwitchStatement;
import org.eclipse.dltk.javascript.core.dom.ThrowStatement;
import org.eclipse.dltk.javascript.core.dom.TryStatement;
import org.eclipse.dltk.javascript.core.dom.UnaryExpression;
import org.eclipse.dltk.javascript.core.dom.UnaryOperator;
import org.eclipse.dltk.javascript.core.dom.VariableDeclaration;
import org.eclipse.dltk.javascript.core.dom.VariableReference;
import org.eclipse.dltk.javascript.core.dom.VariableStatement;
import org.eclipse.dltk.javascript.core.dom.WhileStatement;
import org.eclipse.dltk.javascript.core.dom.WithStatement;
import org.eclipse.dltk.javascript.core.dom.XmlFragment;
import org.eclipse.dltk.javascript.core.dom.XmlInitializer;
import org.eclipse.dltk.javascript.core.dom.rewrite.CommentContainer;

public class ASTConverter
extends ASTVisitor<Node> {
    private static final DomFactory DOM_FACTORY = DomFactory.eINSTANCE;

    public Node visit(ASTNode node) {
        if (node == null) {
            return null;
        }
        Node res = (Node)super.visit(node);
        if (res != null) {
            if (res.getBegin() == -1) {
                res.setBegin(node.sourceStart());
            }
            res.setEnd(node.sourceEnd());
        }
        return res;
    }

    public static Node convert(ASTNode node) {
        ASTConverter converter = new ASTConverter();
        return converter.visit(node);
    }

    private Label visitLabel(org.eclipse.dltk.javascript.ast.Label label) {
        if (label == null) {
            return null;
        }
        Label res = DOM_FACTORY.createLabel();
        res.setBegin(label.sourceStart());
        res.setEnd(label.sourceEnd());
        res.setName(label.getText());
        return res;
    }

    public Node visitArrayInitializer(ArrayInitializer node) {
        ArrayLiteral res = DOM_FACTORY.createArrayLiteral();
        for (ASTNode item : node.getItems()) {
            res.getElements().add((Object)((IArrayElement)this.visit(item)));
        }
        return res;
    }

    public Node visitBinaryOperation(BinaryOperation node) {
        BinaryExpression res = DOM_FACTORY.createBinaryExpression();
        BinaryOperator r = null;
        switch (node.getOperation()) {
            case 86: {
                r = BinaryOperator.ADD;
                break;
            }
            case 105: {
                r = BinaryOperator.ADD_ASSIGN;
                break;
            }
            case 112: {
                r = BinaryOperator.AND_ASSIGN;
                break;
            }
            case 104: {
                r = BinaryOperator.ASSIGN;
                break;
            }
            case 95: {
                r = BinaryOperator.BW_AND;
                break;
            }
            case 77: {
                r = BinaryOperator.COMMA;
                break;
            }
            case 96: {
                r = BinaryOperator.BW_OR;
                break;
            }
            case 97: {
                r = BinaryOperator.BW_XOR;
                break;
            }
            case 115: {
                r = BinaryOperator.DIV;
                break;
            }
            case 116: {
                r = BinaryOperator.DIV_ASSIGN;
                break;
            }
            case 82: {
                r = BinaryOperator.EQ;
                break;
            }
            case 81: {
                r = BinaryOperator.GEQ;
                break;
            }
            case 79: {
                r = BinaryOperator.GREATER;
                break;
            }
            case 20: {
                r = BinaryOperator.IN;
                break;
            }
            case 21: {
                r = BinaryOperator.INSTANCEOF;
                break;
            }
            case 80: {
                r = BinaryOperator.LEQ;
                break;
            }
            case 78: {
                r = BinaryOperator.LESS;
                break;
            }
            case 100: {
                r = BinaryOperator.LOG_AND;
                break;
            }
            case 101: {
                r = BinaryOperator.LOG_OR;
                break;
            }
            case 92: {
                r = BinaryOperator.LSH;
                break;
            }
            case 109: {
                r = BinaryOperator.LSH_ASSIGN;
                break;
            }
            case 89: {
                r = BinaryOperator.MOD;
                break;
            }
            case 108: {
                r = BinaryOperator.MOD_ASSIGN;
                break;
            }
            case 88: {
                r = BinaryOperator.MUL;
                break;
            }
            case 107: {
                r = BinaryOperator.MUL_ASSIGN;
                break;
            }
            case 83: {
                r = BinaryOperator.NEQ;
                break;
            }
            case 85: {
                r = BinaryOperator.NSAME;
                break;
            }
            case 113: {
                r = BinaryOperator.OR_ASSIGN;
                break;
            }
            case 93: {
                r = BinaryOperator.RSH;
                break;
            }
            case 110: {
                r = BinaryOperator.RSH_ASSIGN;
                break;
            }
            case 84: {
                r = BinaryOperator.SAME;
                break;
            }
            case 87: {
                r = BinaryOperator.SUB;
                break;
            }
            case 106: {
                r = BinaryOperator.SUB_ASSIGN;
                break;
            }
            case 94: {
                r = BinaryOperator.URSH;
                break;
            }
            case 111: {
                r = BinaryOperator.URSH_ASSIGN;
                break;
            }
            case 114: {
                r = BinaryOperator.XOR_ASSIGN;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown binary operator");
            }
        }
        res.setOperation(r);
        res.setOperatorPosition(node.getOperationPosition());
        res.setLeft((Expression)this.visit((ASTNode)node.getLeftExpression()));
        res.setRight((Expression)this.visit((ASTNode)node.getRightExpression()));
        return res;
    }

    public Node visitBooleanLiteral(org.eclipse.dltk.javascript.ast.BooleanLiteral node) {
        BooleanLiteral res = DOM_FACTORY.createBooleanLiteral();
        res.setText(node.getText());
        return res;
    }

    public Node visitBreakStatement(org.eclipse.dltk.javascript.ast.BreakStatement node) {
        BreakStatement res = DOM_FACTORY.createBreakStatement();
        res.setLabel(this.visitLabel(node.getLabel()));
        return res;
    }

    public Node visitCallExpression(org.eclipse.dltk.javascript.ast.CallExpression node) {
        CallExpression res = DOM_FACTORY.createCallExpression();
        res.setApplicant((Expression)this.visit((ASTNode)node.getExpression()));
        for (ASTNode arg : node.getArguments()) {
            res.getArguments().add((Object)((Expression)this.visit(arg)));
        }
        return res;
    }

    public Node visitCommaExpression(CommaExpression node) {
        Iterator it = node.getItems().iterator();
        Expression res = (Expression)this.visit((ASTNode)it.next());
        while (it.hasNext()) {
            BinaryExpression tmp = DOM_FACTORY.createBinaryExpression();
            tmp.setOperation(BinaryOperator.COMMA);
            tmp.setLeft(res);
            tmp.setRight((Expression)this.visit((ASTNode)it.next()));
            if (it.hasNext()) {
                tmp.setBegin(res.getBegin());
                tmp.setEnd(tmp.getRight().getEnd());
            }
            res = tmp;
        }
        return res;
    }

    public Node visitConditionalOperator(ConditionalOperator node) {
        ConditionalExpression res = DOM_FACTORY.createConditionalExpression();
        res.setPredicate((Expression)this.visit((ASTNode)node.getCondition()));
        res.setConsequent((Expression)this.visit((ASTNode)node.getTrueValue()));
        res.setAlternative((Expression)this.visit((ASTNode)node.getFalseValue()));
        return res;
    }

    public Node visitConstDeclaration(org.eclipse.dltk.javascript.ast.ConstStatement node) {
        ConstStatement res = DOM_FACTORY.createConstStatement();
        for (org.eclipse.dltk.javascript.ast.VariableDeclaration decl : node.getVariables()) {
            res.getDeclarations().add((Object)this.createVariableDeclaration(decl));
        }
        return res;
    }

    public Node visitContinueStatement(org.eclipse.dltk.javascript.ast.ContinueStatement node) {
        ContinueStatement res = DOM_FACTORY.createContinueStatement();
        res.setLabel(this.visitLabel(node.getLabel()));
        return res;
    }

    public Node visitDecimalLiteral(DecimalLiteral node) {
        NumericLiteral res = DOM_FACTORY.createNumericLiteral();
        res.setText(node.getText());
        return res;
    }

    public Node visitDoWhileStatement(DoWhileStatement node) {
        DoStatement res = DOM_FACTORY.createDoStatement();
        res.setBody((Statement)this.visit((ASTNode)node.getBody()));
        res.setCondition((Expression)this.visit((ASTNode)node.getCondition()));
        return res;
    }

    public Node visitEmptyExpression(EmptyExpression node) {
        return DOM_FACTORY.createElision();
    }

    public Node visitForStatement(org.eclipse.dltk.javascript.ast.ForStatement node) {
        ForStatement res = DOM_FACTORY.createForStatement();
        if (!this.isEmpty(node.getInitial())) {
            res.setInitialization((IForInitializer)this.visit((ASTNode)node.getInitial()));
        }
        if (!this.isEmpty(node.getCondition())) {
            res.setCondition((Expression)this.visit((ASTNode)node.getCondition()));
        }
        if (!this.isEmpty(node.getStep())) {
            res.setIncrement((Expression)this.visit((ASTNode)node.getStep()));
        }
        res.setBody((Statement)this.visit((ASTNode)node.getBody()));
        return res;
    }

    private boolean isEmpty(org.eclipse.dltk.javascript.ast.Expression expression) {
        return expression == null || expression instanceof EmptyExpression;
    }

    public Node visitForInStatement(org.eclipse.dltk.javascript.ast.ForInStatement node) {
        ForInStatement res = DOM_FACTORY.createForInStatement();
        res.setItem((IForInitializer)this.visit((ASTNode)node.getItem()));
        res.setCollection((Expression)this.visit((ASTNode)node.getIterator()));
        res.setBody((Statement)this.visit((ASTNode)node.getBody()));
        return res;
    }

    public Node visitForEachInStatement(org.eclipse.dltk.javascript.ast.ForEachInStatement node) {
        ForEachInStatement res = DOM_FACTORY.createForEachInStatement();
        res.setItem((IForInitializer)this.visit((ASTNode)node.getItem()));
        res.setCollection((Expression)this.visit((ASTNode)node.getIterator()));
        res.setBody((Statement)this.visit((ASTNode)node.getBody()));
        return res;
    }

    private static Identifier createIdentifier(org.eclipse.dltk.javascript.ast.Identifier id) {
        Identifier res = DOM_FACTORY.createIdentifier();
        res.setName(id.getName());
        res.setBegin(id.sourceStart());
        res.setEnd(id.sourceEnd());
        return res;
    }

    public Node visitFunctionStatement(FunctionStatement node) {
        org.eclipse.dltk.javascript.ast.Comment docs;
        FunctionExpression res = DOM_FACTORY.createFunctionExpression();
        if (node.getName() != null) {
            res.setIdentifier(ASTConverter.createIdentifier(node.getName()));
        }
        if ((docs = node.getDocumentation()) != null) {
            Comment comment = DOM_FACTORY.createComment();
            comment.setText(docs.getText());
            comment.setBegin(docs.sourceStart());
            comment.setEnd(docs.sourceEnd());
            res.setDocumentation(comment);
            res.setBegin(comment.getBegin());
        }
        for (Argument arg : node.getArguments()) {
            Parameter prm = DOM_FACTORY.createParameter();
            prm.setName(ASTConverter.createIdentifier(arg.getIdentifier()));
            prm.setBegin(arg.sourceStart());
            prm.setEnd(arg.sourceEnd());
            res.getParameters().add((Object)prm);
        }
        res.setBody((BlockStatement)this.visit((ASTNode)node.getBody()));
        res.setParametersPosition(node.getLP() + 1);
        return res;
    }

    public Node visitGetArrayItemExpression(GetArrayItemExpression node) {
        ArrayAccessExpression res = DOM_FACTORY.createArrayAccessExpression();
        res.setArray((Expression)this.visit((ASTNode)node.getArray()));
        res.setIndex((Expression)this.visit((ASTNode)node.getIndex()));
        return res;
    }

    public Node visitIdentifier(org.eclipse.dltk.javascript.ast.Identifier node) {
        VariableReference res = DOM_FACTORY.createVariableReference();
        res.setVariable(ASTConverter.createIdentifier(node));
        return res;
    }

    public Node visitIfStatement(org.eclipse.dltk.javascript.ast.IfStatement node) {
        IfStatement res = DOM_FACTORY.createIfStatement();
        res.setPredicate((Expression)this.visit((ASTNode)node.getCondition()));
        res.setConsequent((Statement)this.visit((ASTNode)node.getThenStatement()));
        res.setAlternative((Statement)this.visit((ASTNode)node.getElseStatement()));
        return res;
    }

    public Node visitLabelledStatement(LabelledStatement node) {
        LabeledStatement res = DOM_FACTORY.createLabeledStatement();
        res.setLabel(this.visitLabel(node.getLabel()));
        res.setStatement((Statement)this.visit((ASTNode)node.getStatement()));
        return res;
    }

    public Node visitNewExpression(org.eclipse.dltk.javascript.ast.NewExpression node) {
        NewExpression res = DOM_FACTORY.createNewExpression();
        res.setConstructor((Expression)this.visit((ASTNode)node.getObjectClass()));
        return res;
    }

    public Node visitNullExpression(NullExpression node) {
        return DOM_FACTORY.createNullLiteral();
    }

    public Node visitObjectInitializer(ObjectInitializer node) {
        ObjectLiteral res = DOM_FACTORY.createObjectLiteral();
        for (ObjectInitializerPart part : node.getInitializers()) {
            PropertyAssignment elem;
            PropertyAssignment cur = null;
            if (part instanceof PropertyInitializer) {
                PropertyInitializer pi = (PropertyInitializer)part;
                elem = DOM_FACTORY.createSimplePropertyAssignment();
                elem.setName(this.createPropertyName(pi.getName()));
                elem.setInitializer((Expression)this.visit((ASTNode)pi.getValue()));
                cur = elem;
            } else if (part instanceof GetMethod) {
                GetMethod gm = (GetMethod)part;
                elem = DOM_FACTORY.createGetterAssignment();
                elem.setName(this.createPropertyName((org.eclipse.dltk.javascript.ast.Expression)gm.getName()));
                elem.setBody((BlockStatement)this.visit((ASTNode)gm.getBody()));
                cur = elem;
                res.getProperties().add((Object)elem);
            } else if (part instanceof SetMethod) {
                SetMethod sm = (SetMethod)part;
                elem = DOM_FACTORY.createSetterAssignment();
                elem.setName(this.createPropertyName((org.eclipse.dltk.javascript.ast.Expression)sm.getName()));
                elem.setParameter(ASTConverter.createIdentifier(sm.getArgument()));
                elem.setBody((BlockStatement)this.visit((ASTNode)sm.getBody()));
                cur = elem;
                res.getProperties().add((Object)elem);
            } else {
                throw new UnsupportedOperationException("Unknown initializer type");
            }
            cur.setBegin(part.sourceStart());
            cur.setEnd(part.sourceEnd());
            res.getProperties().add((Object)cur);
        }
        return res;
    }

    private IPropertyName createPropertyName(org.eclipse.dltk.javascript.ast.Expression name) {
        if (name instanceof org.eclipse.dltk.javascript.ast.Identifier) {
            return ASTConverter.createIdentifier((org.eclipse.dltk.javascript.ast.Identifier)name);
        }
        return (IPropertyName)this.visit((ASTNode)name);
    }

    public Node visitParenthesizedExpression(org.eclipse.dltk.javascript.ast.ParenthesizedExpression node) {
        ParenthesizedExpression res = DOM_FACTORY.createParenthesizedExpression();
        res.setEnclosed((Expression)this.visit((ASTNode)node.getExpression()));
        return res;
    }

    public Node visitPropertyExpression(PropertyExpression node) {
        PropertyAccessExpression res = DOM_FACTORY.createPropertyAccessExpression();
        res.setObject((Expression)this.visit((ASTNode)node.getObject()));
        if (node.getProperty() instanceof org.eclipse.dltk.javascript.ast.Identifier) {
            res.setProperty(ASTConverter.createIdentifier((org.eclipse.dltk.javascript.ast.Identifier)node.getProperty()));
        } else {
            res.setProperty((IProperty)this.visit((ASTNode)node.getProperty()));
        }
        return res;
    }

    public Node visitRegExpLiteral(RegExpLiteral node) {
        RegularExpressionLiteral res = DOM_FACTORY.createRegularExpressionLiteral();
        res.setText(node.getText());
        return res;
    }

    public Node visitReturnStatement(org.eclipse.dltk.javascript.ast.ReturnStatement node) {
        ReturnStatement res = DOM_FACTORY.createReturnStatement();
        res.setExpression((Expression)this.visit((ASTNode)node.getValue()));
        return res;
    }

    public Node visitScript(Script node) {
        Source res = DOM_FACTORY.createSource();
        for (org.eclipse.dltk.javascript.ast.Statement stmt : node.getStatements()) {
            res.getStatements().add((Object)((Statement)this.visit((ASTNode)stmt)));
        }
        CommentContainer comments = CommentContainer.of(node.getComments());
        if (comments != null) {
            res.eAdapters().add((Object)comments);
        }
        return res;
    }

    public Node visitStatementBlock(StatementBlock node) {
        BlockStatement res = DOM_FACTORY.createBlockStatement();
        for (org.eclipse.dltk.javascript.ast.Statement stmt : node.getStatements()) {
            res.getStatements().add((Object)((Statement)this.visit((ASTNode)stmt)));
        }
        return res;
    }

    public Node visitStringLiteral(org.eclipse.dltk.javascript.ast.StringLiteral node) {
        StringLiteral res = DOM_FACTORY.createStringLiteral();
        res.setText(node.getText());
        return res;
    }

    public Node visitSwitchStatement(org.eclipse.dltk.javascript.ast.SwitchStatement node) {
        SwitchStatement res = DOM_FACTORY.createSwitchStatement();
        res.setSelector((Expression)this.visit((ASTNode)node.getCondition()));
        for (SwitchComponent elem : node.getCaseClauses()) {
            SwitchElement element;
            if (elem instanceof org.eclipse.dltk.javascript.ast.CaseClause) {
                CaseClause caseClause = DOM_FACTORY.createCaseClause();
                caseClause.setExpression((Expression)this.visit((ASTNode)((org.eclipse.dltk.javascript.ast.CaseClause)elem).getCondition()));
                element = caseClause;
            } else {
                element = DOM_FACTORY.createDefaultClause();
            }
            element.setBegin(elem.sourceStart());
            element.setEnd(elem.sourceEnd());
            for (org.eclipse.dltk.javascript.ast.Statement statement : elem.getStatements()) {
                element.getStatements().add((Object)((Statement)this.visit((ASTNode)statement)));
            }
            res.getElements().add((Object)element);
        }
        return res;
    }

    public Node visitThisExpression(ThisExpression node) {
        return DOM_FACTORY.createThisExpression();
    }

    public Node visitThrowStatement(org.eclipse.dltk.javascript.ast.ThrowStatement node) {
        ThrowStatement res = DOM_FACTORY.createThrowStatement();
        res.setException((Expression)this.visit((ASTNode)node.getException()));
        return res;
    }

    public Node visitTryStatement(org.eclipse.dltk.javascript.ast.TryStatement node) {
        TryStatement res = DOM_FACTORY.createTryStatement();
        for (org.eclipse.dltk.javascript.ast.CatchClause cc : node.getCatches()) {
            CatchClause ccr = DOM_FACTORY.createCatchClause();
            ccr.setException(ASTConverter.createIdentifier(cc.getException()));
            ccr.setFilter((Expression)this.visit((ASTNode)cc.getFilterExpression()));
            ccr.setBody((BlockStatement)this.visit((ASTNode)cc.getStatement()));
            ccr.setBegin(cc.sourceStart());
            ccr.setEnd(cc.sourceEnd());
            res.getCatches().add((Object)ccr);
        }
        if (node.getFinally() != null) {
            org.eclipse.dltk.javascript.ast.FinallyClause fc = node.getFinally();
            FinallyClause fcr = DOM_FACTORY.createFinallyClause();
            fcr.setBody((BlockStatement)this.visit((ASTNode)fc.getStatement()));
            fcr.setBegin(fc.sourceStart());
            fcr.setEnd(fc.sourceEnd());
            res.setFinallyClause(fcr);
        }
        return res;
    }

    public Node visitUnaryOperation(UnaryOperation node) {
        UnaryOperator r;
        UnaryExpression res = DOM_FACTORY.createUnaryExpression();
        switch (node.getOperation()) {
            case 99: {
                r = UnaryOperator.BW_NOT;
                break;
            }
            case 12: {
                r = UnaryOperator.DELETE;
                break;
            }
            case 98: {
                r = UnaryOperator.NOT;
                break;
            }
            case 87: 
            case 143: {
                r = UnaryOperator.NUM_NEG;
                break;
            }
            case 146: {
                r = UnaryOperator.POSTFIX_DEC;
                break;
            }
            case 147: {
                r = UnaryOperator.POSTFIX_INC;
                break;
            }
            case 91: {
                r = UnaryOperator.PREFIX_DEC;
                break;
            }
            case 90: {
                r = UnaryOperator.PREFIX_INC;
                break;
            }
            case 28: {
                r = UnaryOperator.TYPEOF;
                break;
            }
            case 86: 
            case 148: {
                r = UnaryOperator.UNARY_PLUS;
                break;
            }
            case 30: {
                r = UnaryOperator.VOID;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown binary operator");
            }
        }
        res.setOperation(r);
        res.setArgument((Expression)this.visit((ASTNode)node.getExpression()));
        return res;
    }

    public Node visitVariableStatement(org.eclipse.dltk.javascript.ast.VariableStatement node) {
        VariableStatement res = DOM_FACTORY.createVariableStatement();
        for (org.eclipse.dltk.javascript.ast.VariableDeclaration decl : node.getVariables()) {
            res.getDeclarations().add((Object)this.createVariableDeclaration(decl));
        }
        return res;
    }

    private VariableDeclaration createVariableDeclaration(org.eclipse.dltk.javascript.ast.VariableDeclaration decl) {
        VariableDeclaration res = DOM_FACTORY.createVariableDeclaration();
        res.setIdentifier(ASTConverter.createIdentifier(decl.getIdentifier()));
        res.setInitializer((Expression)this.visit((ASTNode)decl.getInitializer()));
        res.setBegin(decl.sourceStart());
        res.setEnd(decl.sourceEnd());
        return res;
    }

    public Node visitVoidExpression(VoidExpression node) {
        if (node.getExpression() instanceof org.eclipse.dltk.javascript.ast.VariableStatement) {
            return this.visit((ASTNode)node.getExpression());
        }
        ExpressionStatement res = DOM_FACTORY.createExpressionStatement();
        res.setExpression((Expression)this.visit((ASTNode)node.getExpression()));
        res.setBegin(res.getExpression().getBegin());
        return res;
    }

    public Node visitYieldOperator(YieldOperator node) {
        UnaryExpression res = DOM_FACTORY.createUnaryExpression();
        res.setOperation(UnaryOperator.YIELD);
        res.setArgument((Expression)this.visit((ASTNode)node.getExpression()));
        return res;
    }

    public Node visitWhileStatement(org.eclipse.dltk.javascript.ast.WhileStatement node) {
        WhileStatement res = DOM_FACTORY.createWhileStatement();
        res.setCondition((Expression)this.visit((ASTNode)node.getCondition()));
        res.setBody((Statement)this.visit((ASTNode)node.getBody()));
        return res;
    }

    public Node visitWithStatement(org.eclipse.dltk.javascript.ast.WithStatement node) {
        WithStatement res = DOM_FACTORY.createWithStatement();
        res.setExpression((Expression)this.visit((ASTNode)node.getExpression()));
        res.setStatement((Statement)this.visit((ASTNode)node.getStatement()));
        return res;
    }

    public Node visitXmlLiteral(XmlLiteral node) {
        XmlInitializer res = DOM_FACTORY.createXmlInitializer();
        for (org.eclipse.dltk.javascript.ast.XmlFragment fragment : node.getFragments()) {
            XmlFragment cur;
            XmlFragment elem;
            if (fragment instanceof XmlTextFragment) {
                XmlTextFragment text = (XmlTextFragment)fragment;
                elem = DOM_FACTORY.createXmlTextFragment();
                elem.setText(text.getXml());
                cur = elem;
            } else {
                XmlExpressionFragment expr = (XmlExpressionFragment)fragment;
                elem = DOM_FACTORY.createXmlExpressionFragment();
                elem.setExpression((Expression)this.visit((ASTNode)expr.getExpression()));
                cur = elem;
            }
            cur.setBegin(fragment.sourceStart());
            cur.setEnd(fragment.sourceEnd());
            res.getFragments().add((Object)cur);
        }
        return res;
    }

    public Node visitDefaultXmlNamespace(org.eclipse.dltk.javascript.ast.DefaultXmlNamespaceStatement node) {
        DefaultXmlNamespaceStatement res = DOM_FACTORY.createDefaultXmlNamespaceStatement();
        res.setExpression((Expression)this.visit((ASTNode)node.getValue()));
        return res;
    }

    public Node visitXmlPropertyIdentifier(XmlAttributeIdentifier node) {
        AttributeIdentifier res = DOM_FACTORY.createAttributeIdentifier();
        if (node.getExpression() instanceof org.eclipse.dltk.javascript.ast.Identifier) {
            res.setSelector(ASTConverter.createIdentifier((org.eclipse.dltk.javascript.ast.Identifier)node.getExpression()));
        } else {
            res.setSelector((ISelector)this.visit((ASTNode)node.getExpression()));
        }
        return res;
    }

    public Node visitAsteriskExpression(AsteriskExpression node) {
        return DOM_FACTORY.createWildcardIdentifier();
    }

    public Node visitGetAllChildrenExpression(GetAllChildrenExpression node) {
        DescendantAccessExpression res = DOM_FACTORY.createDescendantAccessExpression();
        res.setObject((Expression)this.visit((ASTNode)node.getObject()));
        if (node.getProperty() instanceof org.eclipse.dltk.javascript.ast.Identifier) {
            res.setProperty(ASTConverter.createIdentifier((org.eclipse.dltk.javascript.ast.Identifier)node.getProperty()));
        } else {
            res.setProperty((IProperty)this.visit((ASTNode)node.getProperty()));
        }
        return res;
    }

    public Node visitGetLocalNameExpression(GetLocalNameExpression node) {
        QualifiedIdentifier res = DOM_FACTORY.createQualifiedIdentifier();
        res.setNamespace((IPropertySelector)this.visit((ASTNode)node.getNamespace()));
        res.setMember((IUnqualifiedSelector)this.visit((ASTNode)node.getLocalName()));
        return res;
    }

    public Node visitEmptyStatement(EmptyStatement node) {
        return DOM_FACTORY.createEmptyStatement();
    }
}

