/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import org.jruby.ast.StrNode;
import org.jruby.lexer.yacc.HeredocEndTerm;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.SourcePosition;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.StringTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.util.ByteList;

public class HeredocTerm
extends StrTerm {
    private final String eos;
    private final int func;
    private final String lastLine;
    private final int savedColumn;
    private final int savedOffset;

    public HeredocTerm(String eos, int func, String lastLine, int savedColumn, int savedOffset) {
        this.eos = eos;
        this.func = func;
        this.lastLine = lastLine;
        this.savedColumn = savedColumn;
        this.savedOffset = savedOffset;
    }

    @Override
    public int parseString(RubyYaccLexer lexer, LexerSource src) throws IOException {
        int endMarker;
        boolean indent = (this.func & 0x20) != 0;
        ByteList str = new ByteList();
        char c = src.read();
        if (c == '\u0000') {
            throw new SyntaxException(src.getPosition(), "can't find string \"" + this.eos + "\" anywhere before EOF");
        }
        if (src.wasBeginOfLine() && c == this.eos.charAt(0) && src.matchString(String.valueOf(this.eos.substring(1)) + '\n', indent)) {
            lexer.yaccValue = new Token("\"", lexer.getPosition());
            src.unreadMany(this.lastLine, this.savedColumn, this.savedOffset);
            return 374;
        }
        if ((this.func & 2) == 0) {
            src.unread(c);
            do {
                str.append(src.readLineBytes());
                str.append(10);
                if (src.peek('\u0000')) {
                    throw new SyntaxException(src.getPosition(), "can't find string \"" + this.eos + "\" anywhere before EOF");
                }
                endMarker = src.getOffset();
            } while (!src.matchString(String.valueOf(this.eos) + '\n', indent));
        } else {
            ByteList buffer = new ByteList();
            if (c == '#') {
                c = src.read();
                switch (c) {
                    case '$': 
                    case '@': {
                        src.unread(c);
                        lexer.setValue(new Token("#" + c, lexer.getPosition()));
                        return 373;
                    }
                    case '{': {
                        lexer.setValue(new Token("#" + c, lexer.getPosition()));
                        return 372;
                    }
                }
                buffer.append(35);
            }
            src.unread(c);
            do {
                if ((c = new StringTerm(this.func, '\n', '\u0000').parseStringIntoBuffer(src, buffer)) == '\u0000') {
                    throw new SyntaxException(src.getPosition(), "can't find string \"" + this.eos + "\" anywhere before EOF");
                }
                if (c != '\n') {
                    lexer.yaccValue = new StrNode(lexer.getPosition(), buffer);
                    return 312;
                }
                buffer.append(src.read());
                c = src.read();
                if (c == '\u0000') {
                    throw new SyntaxException(src.getPosition(), "can't find string \"" + this.eos + "\" anywhere before EOF");
                }
                src.unread(c);
                endMarker = src.getOffset();
            } while (!src.matchString(String.valueOf(this.eos) + '\n', indent));
            str = buffer;
        }
        lexer.setStrTerm(new HeredocEndTerm(new SourcePosition(endMarker, src.getOffset())));
        ISourcePosition pos = lexer.getPosition();
        lexer.yaccValue = new StrNode((ISourcePosition)new SourcePosition(pos.getStartOffset(), endMarker), str);
        src.unreadMany(this.lastLine, this.savedColumn, this.savedOffset);
        return 312;
    }
}

