/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.sql.h2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.index.sql.Element;
import org.eclipse.dltk.core.index.sql.IElementDao;
import org.eclipse.dltk.core.index.sql.IElementHandler;
import org.eclipse.dltk.core.index.sql.h2.H2Index;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.index.sql.h2.Schema;
import org.eclipse.osgi.util.NLS;

public class H2ElementDao
implements IElementDao {
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile(",");
    private static final String Q_INSERT_REF = Schema.readSqlFile("resources/insert_ref.sql");
    private static final String Q_INSERT_DECL = Schema.readSqlFile("resources/insert_decl.sql");
    private static final Map<String, String> R_INSERT_QUERY_CACHE = new HashMap<String, String>();
    private static final Map<String, String> D_INSERT_QUERY_CACHE = new HashMap<String, String>();
    private final ModelManager modelManager = ModelManager.getModelManager();
    private final Map<String, PreparedStatement> batchStatements = new HashMap<String, PreparedStatement>();

    private String getTableName(Connection connection, int elementType, String natureId, boolean isReference) throws SQLException {
        Schema schema = new Schema();
        String tableName = schema.getTableName(elementType, natureId, isReference);
        schema.createTable(connection, tableName, isReference);
        return tableName;
    }

    private void insertBatch(Connection connection, PreparedStatement statement, int type, int flags, int offset, int length, int nameOffset, int nameLength, String name, String metadata, String doc, String qualifier, String parent, int fileId, String natureId, boolean isReference) throws SQLException {
        int param = 0;
        if (!isReference) {
            statement.setInt(++param, flags);
        }
        statement.setInt(++param, offset);
        statement.setInt(++param, length);
        if (!isReference) {
            statement.setInt(++param, nameOffset);
            statement.setInt(++param, nameLength);
        }
        statement.setString(++param, name);
        String camelCaseName = null;
        if (!isReference) {
            StringBuilder camelCaseNameBuf = new StringBuilder();
            int i = 0;
            while (i < name.length()) {
                char ch = name.charAt(i);
                if (Character.isUpperCase(ch)) {
                    camelCaseNameBuf.append(ch);
                } else if (i == 0) break;
                ++i;
            }
            camelCaseName = camelCaseNameBuf.length() > 0 ? camelCaseNameBuf.toString() : null;
            statement.setString(++param, camelCaseName);
        }
        statement.setString(++param, metadata);
        if (!isReference) {
            statement.setString(++param, doc);
        }
        statement.setString(++param, qualifier);
        if (!isReference) {
            statement.setString(++param, parent);
        }
        statement.setInt(++param, fileId);
        statement.addBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Connection connection, int type, int flags, int offset, int length, int nameOffset, int nameLength, String name, String metadata, String doc, String qualifier, String parent, int fileId, String natureId, boolean isReference) throws SQLException {
        String query;
        String tableName = this.getTableName(connection, type, natureId, isReference);
        if (isReference) {
            query = R_INSERT_QUERY_CACHE.get(tableName);
            if (query == null) {
                query = NLS.bind((String)Q_INSERT_REF, (Object)tableName);
                R_INSERT_QUERY_CACHE.put(tableName, query);
            }
        } else {
            query = D_INSERT_QUERY_CACHE.get(tableName);
            if (query == null) {
                query = NLS.bind((String)Q_INSERT_DECL, (Object)tableName);
                D_INSERT_QUERY_CACHE.put(tableName, query);
            }
        }
        Map<String, PreparedStatement> map = this.batchStatements;
        synchronized (map) {
            PreparedStatement statement = this.batchStatements.get(query);
            if (statement == null) {
                statement = connection.prepareStatement(query);
                this.batchStatements.put(query, statement);
            }
            this.insertBatch(connection, statement, type, flags, offset, length, nameOffset, nameLength, name, metadata, doc, qualifier, parent, fileId, natureId, isReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitInsertions() throws SQLException {
        Map<String, PreparedStatement> map = this.batchStatements;
        synchronized (map) {
            try {
                for (PreparedStatement statement : this.batchStatements.values()) {
                    try {
                        statement.executeBatch();
                    }
                    finally {
                        statement.close();
                    }
                }
            }
            finally {
                this.batchStatements.clear();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void search(Connection connection, String pattern, ISearchEngine.MatchRule matchRule, int elementType, int trueFlags, int falseFlags, String qualifier, String parent, int[] filesId, int[] containersId, String natureId, int limit, boolean isReference, IElementHandler handler, IProgressMonitor monitor) throws SQLException {
        timeStamp = System.currentTimeMillis();
        count = 0;
        tableName = this.getTableName(connection, elementType, natureId, isReference);
        begin = new StringBuilder("SELECT T.* FROM ").append(tableName);
        query = new StringBuilder();
        parameters = new ArrayList<Object>();
        if (filesId == null && containersId != null && containersId.length > 0) {
            begin.append("_TO_CONTAINER AS T");
            query.append(" AND T.CONTAINER_ID IN(");
            i = 0;
            while (i < containersId.length) {
                if (i > 0) {
                    query.append(",");
                }
                query.append("?");
                parameters.add(containersId[i]);
                ++i;
            }
            query.append(")");
        } else {
            begin.append(" AS T");
        }
        if (pattern != null && pattern.length() > 0) {
            if (isReference && matchRule == ISearchEngine.MatchRule.CAMEL_CASE) {
                H2Index.warn("MatchRule.CAMEL_CASE is not supported by element references search.");
                matchRule = ISearchEngine.MatchRule.EXACT;
            }
            if (matchRule == ISearchEngine.MatchRule.EXACT) {
                query.append(" AND NAME=?");
                parameters.add(pattern);
            } else if (matchRule == ISearchEngine.MatchRule.PREFIX) {
                query.append(" AND NAME LIKE ?");
                parameters.add(String.valueOf(this.escapeLikePattern(pattern)) + "%");
            } else if (matchRule == ISearchEngine.MatchRule.CAMEL_CASE) {
                query.append(" AND CC_NAME LIKE ?");
                parameters.add(String.valueOf(this.escapeLikePattern(pattern)) + "%");
            } else if (matchRule == ISearchEngine.MatchRule.SET) {
                patternSet = H2ElementDao.SEPARATOR_PATTERN.split(pattern);
                query.append(" AND NAME IN (");
                i = 0;
                while (i < patternSet.length) {
                    if (i > 0) {
                        query.append(',');
                    }
                    query.append('?');
                    parameters.add(patternSet[i]);
                    ++i;
                }
                query.append(')');
            } else if (matchRule == ISearchEngine.MatchRule.PATTERN) {
                query.append(" AND NAME LIKE ?");
                parameters.add(this.escapeLikePattern(pattern).replace('*', '%').replace('?', '_'));
            }
        }
        if (trueFlags != 0) {
            query.append(" AND BITAND(FLAGS, ?) <> 0");
            parameters.add(trueFlags);
        }
        if (falseFlags != 0) {
            query.append(" AND BITAND(FLAGS,?) = 0");
            parameters.add(falseFlags);
        }
        if (qualifier != null && qualifier.length() > 0) {
            query.append(" AND QUALIFIER=?");
            parameters.add(qualifier);
        }
        if (parent != null && parent.length() > 0) {
            query.append(" AND PARENT=?");
            parameters.add(parent);
        }
        if (filesId != null) {
            query.append(" AND FILE_ID IN(");
            i = 0;
            while (i < filesId.length) {
                if (i > 0) {
                    query.append(",");
                }
                query.append("?");
                parameters.add(filesId[i]);
                ++i;
            }
            query.append(")");
        }
        if (query.length() > 0) {
            begin.append(" WHERE ").append(query.substring(4));
            query = begin;
        } else {
            query = begin;
        }
        if (limit > 0) {
            query.append(" LIMIT ").append(limit);
        }
        query.append(";");
        if (H2Index.DEBUG) {
            System.out.println("Query: " + query.toString());
        }
        var23_25 = null;
        var24_28 = null;
        try {
            statement = connection.prepareStatement(query.toString());
            try {
                i = 0;
                while (i < parameters.size()) {
                    param = parameters.get(i);
                    if (param instanceof Integer) {
                        statement.setInt(i + 1, (Integer)param);
                    } else {
                        statement.setString(i + 1, (String)param);
                    }
                    ++i;
                }
                var26_32 = null;
                var27_34 = null;
                try {
                    result = statement.executeQuery();
                    try {
                        while (true) {
                            ++count;
                            if (monitor != null && monitor.isCanceled()) {
                                if (statement != null) {
                                    statement.close();
                                }
                                return;
                            }
                            columnIndex = 0;
                            result.getInt(++columnIndex);
                            f = 0;
                            if (!isReference) {
                                f = result.getInt(++columnIndex);
                            }
                            offset = result.getInt(++columnIndex);
                            length = result.getInt(++columnIndex);
                            nameOffset = 0;
                            nameLength = 0;
                            if (!isReference) {
                                nameOffset = result.getInt(++columnIndex);
                                nameLength = result.getInt(++columnIndex);
                            }
                            name = result.getString(++columnIndex);
                            camelCaseName = null;
                            if (!isReference) {
                                camelCaseName = result.getString(++columnIndex);
                            }
                            metadata = result.getString(++columnIndex);
                            doc = null;
                            if (!isReference) {
                                doc = result.getString(++columnIndex);
                            }
                            qualifier = result.getString(++columnIndex);
                            if (!isReference) {
                                parent = result.getString(++columnIndex);
                            }
                            fileId = result.getInt(++columnIndex);
                            element = new Element(elementType, f, offset, length, nameOffset, nameLength, this.modelManager.intern(name), camelCaseName, metadata, doc, qualifier, parent, fileId, isReference);
                            handler.handle(element);
                            break;
                        }
                    }
                    finally {
                        if (result.next()) ** continue;
                    }
                }
                catch (Throwable var27_35) {
                    if (var26_32 == null) {
                        var26_32 = var27_35;
                    } else if (var26_32 != var27_35) {
                        var26_32.addSuppressed(var27_35);
                    }
                    throw var26_32;
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (Throwable var24_29) {
            if (var23_25 == null) {
                var23_25 = var24_29;
            } else if (var23_25 != var24_29) {
                var23_25.addSuppressed(var24_29);
            }
            throw var23_25;
        }
        if (H2Index.DEBUG) {
            System.out.println("Results = " + count + " ; Time taken = " + (System.currentTimeMillis() - timeStamp) + " ms.");
        }
    }

    private String escapeLikePattern(String pattern) {
        return pattern.replaceAll("[\\\\%_]", "\\\\$0");
    }
}

