/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.testing.Messages;
import org.eclipse.dltk.internal.testing.model.ITestRunSessionListener;
import org.eclipse.dltk.internal.testing.model.ModelMessages;
import org.eclipse.dltk.internal.testing.model.RemoteTestRunnerClient;
import org.eclipse.dltk.internal.testing.model.SocketTestRunnerClient;
import org.eclipse.dltk.internal.testing.model.TestRunHandler;
import org.eclipse.dltk.internal.testing.model.TestRunSession;
import org.eclipse.dltk.internal.testing.model.TestRunSessionSerializer;
import org.eclipse.dltk.internal.testing.ui.TestRunnerViewPart;
import org.eclipse.dltk.testing.DLTKTestingConstants;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.dltk.testing.ITestSession;
import org.eclipse.dltk.testing.model.ITestRunSession;
import org.eclipse.dltk.testing.model.ITestingModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DLTKTestingModel
implements ITestingModel {
    private final ListenerList fTestRunSessionListeners = new ListenerList();
    private final LinkedList<TestRunSession> fTestRunSessions = new LinkedList();
    private final DLTKTestingLaunchListener fLaunchListener = new DLTKTestingLaunchListener();
    private boolean started = false;

    public TestRunnerViewPart showTestRunnerViewPartInActivePage() {
        return this.showTestRunnerViewPartInActivePage(this.findTestRunnerViewPartInActivePage());
    }

    private TestRunnerViewPart showTestRunnerViewPartInActivePage(TestRunnerViewPart testRunner) {
        TestRunnerViewPart testRunnerViewPart;
        block11: {
            IWorkbenchPage page;
            IWorkbenchPart activePart;
            block9: {
                block10: {
                    block7: {
                        TestRunnerViewPart testRunnerViewPart2;
                        block8: {
                            activePart = null;
                            page = null;
                            if (testRunner == null || !testRunner.isCreated()) break block7;
                            testRunnerViewPart2 = testRunner;
                            if (page == null || activePart == null) break block8;
                            page.activate(activePart);
                        }
                        return testRunnerViewPart2;
                    }
                    page = DLTKTestingPlugin.getActivePage();
                    if (page != null) break block9;
                    if (page == null || activePart == null) break block10;
                    page.activate(activePart);
                }
                return null;
            }
            try {
                activePart = page.getActivePart();
                testRunnerViewPart = (TestRunnerViewPart)page.showView("org.eclipse.dltk.testing.ResultView");
                if (page == null || activePart == null) break block11;
            }
            catch (PartInitException pie) {
                block12: {
                    try {
                        DLTKTestingPlugin.log(pie);
                        if (page == null || activePart == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (page != null && activePart != null) {
                            page.activate(activePart);
                        }
                        throw throwable;
                    }
                    page.activate(activePart);
                }
                return null;
            }
            page.activate(activePart);
        }
        return testRunnerViewPart;
    }

    private TestRunnerViewPart findTestRunnerViewPartInActivePage() {
        IWorkbenchPage page = DLTKTestingPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        return (TestRunnerViewPart)page.findView("org.eclipse.dltk.testing.ResultView");
    }

    public static IScriptProject getScriptProject(ILaunchConfiguration configuration) {
        try {
            String projectName = configuration.getAttribute("project", null);
            if (projectName != null && projectName.length() > 0) {
                return DLTKCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchListener)this.fLaunchListener);
        this.fLaunchListener.initialize(launchManager);
    }

    public void stop() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.removeLaunchListener((ILaunchListener)this.fLaunchListener);
        File historyDirectory = DLTKTestingPlugin.getHistoryDirectory();
        File[] swapFiles = historyDirectory.listFiles();
        if (swapFiles != null) {
            int i = 0;
            while (i < swapFiles.length) {
                swapFiles[i].delete();
                ++i;
            }
        }
        this.started = false;
    }

    @Override
    public void addTestRunSessionListener(ITestRunSessionListener listener) {
        this.fTestRunSessionListeners.add((Object)listener);
    }

    @Override
    public void removeTestRunSessionListener(ITestRunSessionListener listener) {
        this.fTestRunSessionListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TestRunSession> getTestRunSessions() {
        LinkedList<TestRunSession> linkedList = this.fTestRunSessions;
        synchronized (linkedList) {
            return new ArrayList<TestRunSession>(this.fTestRunSessions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITestRunSession getTestRunSession(ILaunch launch) {
        Assert.isNotNull((Object)launch);
        LinkedList<TestRunSession> linkedList = this.fTestRunSessions;
        synchronized (linkedList) {
            for (TestRunSession session : this.fTestRunSessions) {
                if (!launch.equals(session.getLaunch())) continue;
                return session;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTestRunSession(TestRunSession testRunSession) {
        Assert.isNotNull((Object)testRunSession);
        LinkedList<TestRunSession> linkedList = this.fTestRunSessions;
        synchronized (linkedList) {
            Assert.isLegal((!this.fTestRunSessions.contains(testRunSession) ? 1 : 0) != 0);
            this.fTestRunSessions.addFirst(testRunSession);
        }
        this.notifyTestRunSessionAdded(testRunSession);
    }

    public static ITestSession importTestRunSession(File file) throws CoreException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            TestRunHandler handler = new TestRunHandler();
            parser.parse(file, (DefaultHandler)handler);
            TestRunSession session = handler.getTestRunSession();
            DLTKTestingPlugin.getModel().addTestRunSession(session);
            return session;
        }
        catch (ParserConfigurationException e) {
            DLTKTestingModel.throwImportError(file, e);
        }
        catch (SAXException e) {
            DLTKTestingModel.throwImportError(file, e);
        }
        catch (IOException e) {
            DLTKTestingModel.throwImportError(file, e);
        }
        return null;
    }

    public static void importIntoTestRunSession(File swapFile, TestRunSession testRunSession) throws CoreException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            TestRunHandler handler = new TestRunHandler(testRunSession);
            parser.parse(swapFile, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            DLTKTestingModel.throwImportError(swapFile, e);
        }
        catch (SAXException e) {
            DLTKTestingModel.throwImportError(swapFile, e);
        }
        catch (IOException e) {
            DLTKTestingModel.throwImportError(swapFile, e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exportTestRunSession(TestRunSession testRunSession, File file) throws CoreException {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(file);
                DLTKTestingModel.exportTestRunSession(testRunSession, out);
                return;
            }
            catch (IOException e) {
                DLTKTestingModel.throwExportError(file, e);
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {
                    DLTKTestingPlugin.log(e2);
                }
                return;
            }
            catch (TransformerConfigurationException e) {
                DLTKTestingModel.throwExportError(file, e);
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {
                    DLTKTestingPlugin.log(e2);
                }
                return;
            }
            catch (TransformerException e) {
                DLTKTestingModel.throwExportError(file, e);
                if (out == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {
                    DLTKTestingPlugin.log(e2);
                }
                return;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e2) {
                    DLTKTestingPlugin.log(e2);
                }
            }
        }
    }

    public static void exportTestRunSession(TestRunSession testRunSession, OutputStream out) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        InputSource inputSource = new InputSource();
        SAXSource source = new SAXSource(new TestRunSessionSerializer(testRunSession), inputSource);
        StreamResult result = new StreamResult(out);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        transformer.transform(source, result);
    }

    private static void throwExportError(File file, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, DLTKTestingPlugin.getPluginId(), Messages.format(ModelMessages.JUnitModel_could_not_write, file.getAbsolutePath()), (Throwable)e));
    }

    private static void throwImportError(File file, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, DLTKTestingPlugin.getPluginId(), Messages.format(ModelMessages.JUnitModel_could_not_read, file.getAbsolutePath()), (Throwable)e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTestRunSession(TestRunSession testRunSession) {
        boolean existed;
        LinkedList<TestRunSession> linkedList = this.fTestRunSessions;
        synchronized (linkedList) {
            existed = this.fTestRunSessions.remove(testRunSession);
        }
        if (existed) {
            this.notifyTestRunSessionRemoved(testRunSession);
        }
        testRunSession.removeSwapFile();
    }

    private void notifyTestRunSessionRemoved(TestRunSession testRunSession) {
        testRunSession.stopTestRun();
        ILaunch launch = testRunSession.getLaunch();
        if (launch != null) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunch(launch);
        }
        Object[] listeners = this.fTestRunSessionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITestRunSessionListener)listeners[i]).sessionRemoved(testRunSession);
            ++i;
        }
    }

    private void notifyTestRunSessionAdded(TestRunSession testRunSession) {
        Object[] listeners = this.fTestRunSessionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITestRunSessionListener)listeners[i]).sessionAdded(testRunSession);
            ++i;
        }
    }

    private final class DLTKTestingLaunchListener
    implements ILaunchListener {
        private final HashSet<ILaunch> fTrackedLaunches = new HashSet(20);

        private DLTKTestingLaunchListener() {
        }

        protected void initialize(ILaunchManager launchManager) {
            this.fTrackedLaunches.clear();
            ILaunch[] launchs = launchManager.getLaunches();
            int i = 0;
            int size = launchs.length;
            while (i < size) {
                this.fTrackedLaunches.add(launchs[i]);
                ++i;
            }
        }

        public void launchAdded(ILaunch launch) {
            this.fTrackedLaunches.add(launch);
        }

        public void launchRemoved(ILaunch launch) {
            this.fTrackedLaunches.remove(launch);
        }

        public void launchChanged(final ILaunch launch) {
            if (!this.fTrackedLaunches.contains(launch)) {
                return;
            }
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            if (config == null) {
                return;
            }
            final IScriptProject javaProject = DLTKTestingConstants.getScriptProject(config);
            if (javaProject == null) {
                return;
            }
            String portStr = launch.getAttribute("org.eclipse.dltk.testing.PORT");
            if (portStr != null) {
                try {
                    final int port = Integer.parseInt(portStr);
                    this.fTrackedLaunches.remove(launch);
                    this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DLTKTestingLaunchListener.this.connectTestRunner(launch, javaProject, port);
                        }
                    });
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
            } else {
                String atr = launch.getAttribute("org.eclipse.dltk.testing.LAUNCH_KEY");
                if (atr != null) {
                    this.fTrackedLaunches.remove(launch);
                    this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DLTKTestingLaunchListener.this.connectTestRunner(launch, javaProject);
                        }
                    });
                }
            }
        }

        private void connectTestRunner(ILaunch launch, IScriptProject javaProject) {
            DLTKTestingModel.this.showTestRunnerViewPartInActivePage();
            this.limitSessionHistory();
            DLTKTestingModel.this.addTestRunSession(new TestRunSession(launch, javaProject, new RemoteTestRunnerClient()));
        }

        private void connectTestRunner(ILaunch launch, IScriptProject javaProject, int port) {
            DLTKTestingModel.this.showTestRunnerViewPartInActivePage();
            this.limitSessionHistory();
            DLTKTestingModel.this.addTestRunSession(new TestRunSession(launch, javaProject, new SocketTestRunnerClient(port)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void limitSessionHistory() {
            int maxCount = DLTKTestingPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.dltk.testing.max_test_runs");
            LinkedList linkedList = DLTKTestingModel.this.fTestRunSessions;
            synchronized (linkedList) {
                int toDelete = DLTKTestingModel.this.fTestRunSessions.size() - maxCount;
                while (toDelete > 0) {
                    --toDelete;
                    TestRunSession session = (TestRunSession)DLTKTestingModel.this.fTestRunSessions.removeLast();
                    DLTKTestingModel.this.notifyTestRunSessionRemoved(session);
                }
            }
        }

        private Display getDisplay() {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            return display;
        }
    }
}

