/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.formatter;

import java.util.Stack;
import org.eclipse.dltk.formatter.FormatterTextNode;
import org.eclipse.dltk.formatter.IFormatterContainerNode;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterNode;
import org.eclipse.dltk.formatter.IFormatterNodeProxy;
import org.eclipse.dltk.formatter.IFormatterTextNode;

public class AbstractFormatterNodeBuilder {
    private final Stack<IFormatterContainerNode> stack = new Stack();

    protected void start(IFormatterContainerNode root) {
        this.stack.clear();
        this.stack.push(root);
    }

    protected IFormatterContainerNode peek() {
        return this.stack.peek();
    }

    protected void push(IFormatterContainerNode node) {
        this.addChild(node);
        this.stack.push(node);
    }

    protected IFormatterNode addChild(IFormatterNode node) {
        IFormatterContainerNode parentNode = this.peek();
        if (!node.isEmpty()) {
            this.advanceParent(parentNode, node.getStartOffset());
        }
        parentNode.addChild(node);
        return node;
    }

    private void advanceParent(IFormatterContainerNode parentNode, int pos) {
        if (parentNode.getEndOffset() < pos) {
            parentNode.addChild(this.createTextNode(parentNode.getDocument(), parentNode.getEndOffset(), pos));
        }
    }

    protected void checkedPop(IFormatterContainerNode expected, int bodyEnd) {
        IFormatterNode target;
        IFormatterContainerNode top = this.stack.pop();
        if (top instanceof IFormatterNodeProxy && (target = ((IFormatterNodeProxy)((Object)top)).getTargetNode()) instanceof IFormatterContainerNode) {
            top = (IFormatterContainerNode)target;
        }
        if (top != expected) {
            throw new IllegalStateException();
        }
        if (bodyEnd > 0 && expected.getEndOffset() < bodyEnd) {
            expected.addChild(this.createTextNode(expected.getDocument(), expected.getEndOffset(), bodyEnd));
        }
    }

    protected IFormatterTextNode createTextNode(IFormatterDocument document, int startIndex, int endIndex) {
        return new FormatterTextNode(document, startIndex, endIndex);
    }
}

