/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser.raw;

import org.eclipse.dltk.tcl.internal.parser.raw.ICodeScanner;

public class TclTextUtils {
    public static void runToLineEnd(ICodeScanner scanner) {
        boolean esc = false;
        block5: while (true) {
            int c = scanner.read();
            switch (c) {
                case 92: {
                    esc = true;
                    continue block5;
                }
                case 13: {
                    continue block5;
                }
                case -1: 
                case 10: {
                    if (esc) break;
                    return;
                }
            }
            esc = false;
        }
    }

    public static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13;
    }

    public static boolean isTrueWhitespace(int c) {
        return c == 32 || c == 9;
    }

    public static boolean isHexDigit(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isOctDigit(int c) {
        return c >= 48 && c <= 55;
    }

    public static boolean isIdentifier(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 45 || c == 95 || c == 58;
    }

    public static boolean isNewLine(ICodeScanner input) {
        int c = input.read();
        if (c == 10) {
            input.unread();
            return true;
        }
        if (c == 13) {
            c = input.read();
            input.unread();
            input.unread();
            if (c == 10) {
                return true;
            }
        } else if (c != -1) {
            input.unread();
        }
        return false;
    }

    public static void skipNewLine(ICodeScanner input) {
        int c = input.read();
        if (c == 10) {
            return;
        }
        if (c == 13) {
            c = input.read();
            if (c == 10) {
                return;
            }
            input.unread();
        }
        input.unread();
    }
}

