/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.console.ui.ScriptConsole;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.ui.console.TextConsole;

public class DLTKConsolePropertyTester
extends PropertyTester {
    private static final String IS_DLTK_CONSOLE_PROPERTY = "isDLTKConsole";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (IS_DLTK_CONSOLE_PROPERTY.equals(property)) {
            TextConsole textConsole;
            Object process;
            if (receiver instanceof ScriptConsole) {
                return true;
            }
            if (receiver instanceof TextConsole && (process = (textConsole = (TextConsole)receiver).getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS")) != null && process instanceof IProcess) {
                String nature = DLTKConsolePropertyTester.getProcessNature((IProcess)process);
                return nature != null && DLTKLanguageManager.getLanguageToolkit((String)nature) != null;
            }
        }
        return false;
    }

    private static String getProcessNature(IProcess process) {
        block3: {
            ILaunch launch = process.getLaunch();
            ILaunchConfiguration configuration = launch.getLaunchConfiguration();
            if (configuration != null) {
                try {
                    return configuration.getAttribute("nature", null);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

