/*******************************************************************************
 * Copyright (c) 2011 NumberFour AG
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NumberFour AG - initial API and Implementation (Alex Panchenko)
 *******************************************************************************/
package org.eclipse.dltk.ui.text.completion;

import org.eclipse.dltk.annotations.ExtensionPoint;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.internal.ui.text.completion.ScriptCompletionProposalFactoryRegistry;

/**
 * Interface to plug-in factories for converting {@link CompletionProposal}
 * generated by the {@link org.eclipse.dltk.codeassist.ICompletionEngine} to
 * {@link IScriptCompletionProposal} used to display proposals to the user.
 * 
 * @since 3.0
 */
@ExtensionPoint(point = ScriptCompletionProposalFactoryRegistry.EXT_POINT, element = "proposalFactory", attribute = "class")
public interface IScriptCompletionProposalFactory {
	/**
	 * Creates the UI completion proposal or returns <code>null</code> if not
	 * applicable
	 * 
	 * @param collector
	 * @param proposal
	 * @return
	 */
	IScriptCompletionProposal create(
			ScriptCompletionProposalCollector collector,
			CompletionProposal proposal);
}
